<?php
/**
 * Plugin Name:       DPDPA Compliance India
 * Plugin URI:        https://wordpress.org/plugins/dpdpa-compliance-india/
 * Description:       Help Indian sites meet Digital Personal Data Protection Act obligations: consent, notices, rights requests, logging, and minimal data collection.
 * Version:           1.0.3
 * Author:            Vivek
 * Author URI:        https://github.com/VivekcEna
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       dpdpa-compliance-india
 * Domain Path:       /languages
 *
 * @package           DPDPA_Compliance_India
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

/**
 * Current plugin version.
 */
define('DPDPA_VERSION', '1.0.3');

/**
 * Plugin folder path.
 */
define('DPDPA_PATH', plugin_dir_path(__FILE__));

/**
 * Plugin folder URL.
 */
define('DPDPA_URL', plugin_dir_url(__FILE__));

/**
 * Simple autoloader.
 */
require_once DPDPA_PATH . 'includes/Autoloader.php';
\DPDPA\Autoloader::register();

/**
 * Begins execution of the plugin.
 */
function dpdpa_compliance_run()
{
    $plugin = new \DPDPA\Core();
    $plugin->run();
}
dpdpa_compliance_run();
