document.addEventListener('DOMContentLoaded', function () {
    const wizard = document.getElementById('dpdpa-wizard');
    if (!wizard) return;

    const nextBtn = document.getElementById('dpdpa-next-step');
    const skipBtn = document.getElementById('dpdpa-skip-wizard');
    const dots = document.querySelectorAll('.dpdpa-step-dot');
    const content = document.getElementById('dpdpa-wizard-content');

    let currentStep = 1;
    const totalSteps = 4;
    const wizardData = {
        role: 'blog',
        org_name: '',
        dpo_email: '',
        purposes: ['essential']
    };

    const steps = [
        {
            title: 'Identify your role',
            content: `
                <h3>Identify your role</h3>
                <p>This helps us tune the compliance requirements for your site type.</p>
                <div style="display: grid; gap: 10px; margin-top: 20px;">
                    <label><input type="radio" name="site_role" value="blog" checked> Blog / Information Site</label>
                    <label><input type="radio" name="site_role" value="business"> Business Site / Corporate</label>
                    <label><input type="radio" name="site_role" value="ecommerce"> WooCommerce / Online Store</label>
                    <label><input type="radio" name="site_role" value="membership"> Membership / Community Platform</label>
                </div>
            `,
            btnText: 'Next: Org Details'
        },
        {
            title: 'Organization Details',
            content: `
                <h3>Organization Details</h3>
                <p>Provide details of the Data Fiduciary (your organization).</p>
                <div style="display: grid; gap: 15px; margin-top: 20px;">
                    <div>
                        <label style="display:block; margin-bottom:5px;">Organization Name</label>
                        <input type="text" id="dpdpa_org_name" style="width:100%">
                    </div>
                    <div>
                        <label style="display:block; margin-bottom:5px;">DPO / Contact Email</label>
                        <input type="email" id="dpdpa_dpo_email" style="width:100%">
                    </div>
                </div>
            `,
            btnText: 'Next: Consent'
        },
        {
            title: 'Basic Consent Purposes',
            content: `
                <h3>Basic Consent Purposes</h3>
                <p>Which types of data collection do you use?</p>
                <div style="display: grid; gap: 10px; margin-top: 20px;">
                    <label><input type="checkbox" checked disabled> Essential (Required)</label>
                    <label><input type="checkbox" name="purpose" value="analytics" checked> Analytics & Statistics</label>
                    <label><input type="checkbox" name="purpose" value="marketing" checked> Marketing & Advertising</label>
                    <label><input type="checkbox" name="purpose" value="personalization"> Personalization</label>
                </div>
            `,
            btnText: 'Next: Finish Setup'
        },
        {
            title: 'Ready to go!',
            content: `
                <h3>Ready to go!</h3>
                <p>We'll now generate your draft Privacy Notice and Consent Banner.</p>
                <div style="background: #f0fdfa; padding: 20px; border-radius: 12px; margin-top: 20px; border: 1px solid #ccfbf1;">
                    <ul style="margin: 0; padding-left: 20px; color: #134e4a;">
                        <li>Privacy Policy page draft created</li>
                        <li>Consent Banner enabled (Draft mode)</li>
                        <li>DSR Request form shortcode ready</li>
                    </ul>
                </div>
            `,
            btnText: 'Go to Dashboard'
        }
    ];

    let isSkipping = false;

    nextBtn.addEventListener('click', function () {
        if (isSkipping) {
            finishWizard();
            return;
        }

        collectStepData();
        if (currentStep < totalSteps) {
            currentStep++;
            updateWizard();
        } else {
            finishWizard();
        }
    });

    skipBtn.addEventListener('click', function () {
        if (isSkipping) {
            updateWizard();
            return;
        }
        showSkipConfirmation();
    });

    function showSkipConfirmation() {
        isSkipping = true;
        content.innerHTML = `
            <div style="text-align: center; padding: 20px 0;">
                <div style="font-size: 48px; margin-bottom: 20px;">⚠️</div>
                <h3 style="margin-bottom: 10px;">Skip Quick Setup?</h3>
                <p style="color: var(--dpdpa-text-muted); line-height: 1.6;">
                    Are you sure you want to skip? You will need to manually configure your organization details and processing purposes in the settings later.
                </p>
                <div style="background: #fff8f1; border: 1px solid #ffedd5; padding: 15px; border-radius: 12px; margin-top: 20px; color: #9a3412; font-size: 13px;">
                    Note: Default pages will still be generated as drafts.
                </div>
            </div>
        `;

        nextBtn.textContent = 'Yes, Skip Setup';
        skipBtn.textContent = 'Go Back';
    }

    function collectStepData() {
        if (currentStep === 1) {
            const role = document.querySelector('input[name="site_role"]:checked');
            if (role) wizardData.role = role.value;
        } else if (currentStep === 2) {
            const org = document.getElementById('dpdpa_org_name');
            const email = document.getElementById('dpdpa_dpo_email');
            if (org) wizardData.org_name = org.value;
            if (email) wizardData.dpo_email = email.value;
        } else if (currentStep === 3) {
            const purposes = document.querySelectorAll('input[name="purpose"]:checked');
            wizardData.purposes = ['essential'];
            purposes.forEach(p => wizardData.purposes.push(p.value));
        }
    }

    function updateWizard() {
        isSkipping = false;
        const step = steps[currentStep - 1];
        content.innerHTML = step.content;
        nextBtn.textContent = step.btnText;
        skipBtn.textContent = 'Skip for now';

        // Re-calculate Site Role selected state
        if (currentStep === 1) {
            const radio = document.querySelector(`input[name="site_role"][value="${wizardData.role}"]`);
            if (radio) radio.checked = true;
        }

        // Restore values if going back (though back functionality isn't implemented, this is good practice)
        if (currentStep === 2) {
            if (wizardData.org_name) document.getElementById('dpdpa_org_name').value = wizardData.org_name;
            if (wizardData.dpo_email) document.getElementById('dpdpa_dpo_email').value = wizardData.dpo_email;
        }

        dots.forEach((dot, index) => {
            if (index < currentStep) {
                dot.classList.add('active');
            } else {
                dot.classList.remove('active');
            }
        });
    }

    function finishWizard() {
        wizard.style.display = 'none';

        const data = {
            action: 'dpdpa_finish_onboarding',
            nonce: dpdpa_vars.nonce,
            role: wizardData.role,
            org_name: wizardData.org_name,
            dpo_email: wizardData.dpo_email,
            purposes: JSON.stringify(wizardData.purposes)
        };

        fetch(ajaxurl, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: new URLSearchParams(data)
        })
            .then(response => response.json())
            .then(result => {
                if (result.success) {
                    window.location.reload();
                } else {
                    console.error('DPDPA Save Failed:', result.data);
                    alert('Failed to save settings: ' + (result.data || 'Unknown error'));
                }
            })
            .catch(error => {
                console.error('DPDPA AJAX Error:', error);
                alert('A connection error occurred while saving.');
            });
    }
});
