var WPDMDialog=function($){"use strict";var icons={info:'<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="16" x2="12" y2="12"></line><line x1="12" y1="8" x2="12.01" y2="8"></line></svg>',success:'<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"></path><polyline points="22 4 12 14.01 9 11.01"></polyline></svg>',warning:'<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M10.29 3.86L1.82 18a2 2 0 0 0 1.71 3h16.94a2 2 0 0 0 1.71-3L13.71 3.86a2 2 0 0 0-3.42 0z"></path><line x1="12" y1="9" x2="12" y2="13"></line><line x1="12" y1="17" x2="12.01" y2="17"></line></svg>',danger:'<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="15" y1="9" x2="9" y2="15"></line><line x1="9" y1="9" x2="15" y2="15"></line></svg>',question:'<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3"></path><line x1="12" y1="17" x2="12.01" y2="17"></line></svg>',close:'<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg>'};var loadingSpinner='<div class="wpdm-dialog__loading"><div class="wpdm-dialog__spinner"><span></span></div><p class="wpdm-dialog__loading-text">Loading...</p></div>';function detectDarkMode(){if(typeof wpdm_js!=="undefined"&&wpdm_js.color_scheme){if(wpdm_js.color_scheme==="light")return"light-mode";if(wpdm_js.color_scheme==="dark")return"dark-mode"}var isLightMode=$("body").hasClass("light-mode")||$(".w3eden").hasClass("light-mode")||$("html").attr("data-theme")==="light"||$("body").attr("data-theme")==="light";var isDarkMode=$("body").hasClass("dark-mode")||$(".w3eden").hasClass("dark-mode")||$("html").hasClass("dark-mode")||$("body").hasClass("dark")||$("html").attr("data-theme")==="dark"||$("body").attr("data-theme")==="dark";if(isLightMode)return"light-mode";if(isDarkMode)return"dark-mode";return""}function escapeHtml(text){if(typeof text!=="string")return text;var map={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#039;"};return text.replace(/[&<>"']/g,function(m){return map[m]})}function uniqueId(){return"wpdm-dialog-"+Date.now()+"-"+Math.random().toString(36).substr(2,9)}function createDialogHtml(options){var id=options.id||uniqueId();var darkModeClass=detectDarkMode();var sizeClass=options.size?"wpdm-dialog--"+options.size:"";var showIcon=options.icon!==false;var iconType=options.type||"info";var html='<div class="wpdm-dialog-wrapper w3eden '+darkModeClass+'" id="'+id+'">';html+='<div class="wpdm-dialog-backdrop"></div>';html+='<div class="wpdm-dialog '+sizeClass+'" role="dialog" aria-modal="true" aria-labelledby="'+id+'-title">';if(options.closable!==false){html+='<button type="button" class="wpdm-dialog__close" aria-label="Close">'+icons.close+"</button>"}html+='<div class="wpdm-dialog__header">';if(showIcon){html+='<div class="wpdm-dialog__icon wpdm-dialog__icon--'+iconType+'">'+icons[iconType]+"</div>"}html+='<div class="wpdm-dialog__header-content">';html+='<h3 class="wpdm-dialog__title" id="'+id+'-title">'+escapeHtml(options.title)+"</h3>";if(options.subtitle){html+='<p class="wpdm-dialog__subtitle">'+escapeHtml(options.subtitle)+"</p>"}html+="</div>";html+="</div>";html+='<div class="wpdm-dialog__body">';if(options.message){html+='<p class="wpdm-dialog__message">'+(options.html?options.message:escapeHtml(options.message))+"</p>"}if(options.input){html+='<div class="wpdm-dialog__input-wrapper">';html+='<input type="'+(options.inputType||"text")+'" class="wpdm-dialog__input" placeholder="'+escapeHtml(options.placeholder||"")+'" value="'+escapeHtml(options.inputValue||"")+'">';html+="</div>"}if(options.content){html+=options.content}html+="</div>";if(options.buttons&&options.buttons.length>0){var footerClass=options.compactFooter?"wpdm-dialog__footer wpdm-dialog__footer--compact":"wpdm-dialog__footer";html+='<div class="'+footerClass+'">';options.buttons.forEach(function(btn,index){var btnClass="wpdm-dialog__btn wpdm-dialog__btn--"+(btn.type||"secondary");html+='<button type="button" class="'+btnClass+'" data-action="'+(btn.action||index)+'">'+escapeHtml(btn.text)+"</button>"});html+="</div>"}html+="</div>";html+="</div>";return html}function show(options){return new Promise(function(resolve){var html=createDialogHtml(options);var $dialog=$(html);$("body").append($dialog);var $wrapper=$dialog;var $input=$wrapper.find(".wpdm-dialog__input");var $buttons=$wrapper.find(".wpdm-dialog__btn");var $closeBtn=$wrapper.find(".wpdm-dialog__close");requestAnimationFrame(function(){$wrapper.addClass("wpdm-dialog-visible");if($input.length){$input.focus().select()}else if($buttons.length){$buttons.last().focus()}});function close(result){$wrapper.removeClass("wpdm-dialog-visible");$(document).off("keydown.wpdmDialog");setTimeout(function(){$wrapper.remove();resolve(result)},250)}$buttons.on("click",function(){var action=$(this).data("action");var inputValue=$input.length?$input.val():null;close({action:action,value:inputValue})});$closeBtn.on("click",function(){close({action:"close",value:null})});if(options.backdrop!=="static"){$wrapper.find(".wpdm-dialog-backdrop").on("click",function(){close({action:"backdrop",value:null})})}if(options.keyboard!==false){$(document).on("keydown.wpdmDialog",function(e){if(e.key==="Escape"){close({action:"escape",value:null})}})}if(options.input){$input.on("keydown",function(e){if(e.key==="Enter"){e.preventDefault();close({action:"confirm",value:$input.val()})}})}})}return{show:show,alert:function(title,message,options){options=options||{};return show({title:title,message:message,type:options.type||"info",icon:options.icon,size:options.size||"sm",html:options.html,compactFooter:true,buttons:[{text:options.buttonText||"OK",type:"primary",action:"ok"}],backdrop:"static",keyboard:true}).then(function(result){return result.action==="ok"})},success:function(title,message,options){options=options||{};options.type="success";return this.alert(title,message,options)},warning:function(title,message,options){options=options||{};options.type="warning";return this.alert(title,message,options)},error:function(title,message,options){options=options||{};options.type="danger";return this.alert(title,message,options)},confirm:function(title,message,options){options=options||{};return show({title:title,message:message,type:options.type||"question",icon:options.icon,size:options.size||"sm",html:options.html,buttons:[{text:options.cancelText||"Cancel",type:"secondary",action:"cancel"},{text:options.confirmText||"Confirm",type:options.confirmType||"primary",action:"confirm"}],backdrop:options.backdrop||"static",keyboard:options.keyboard!==false}).then(function(result){return result.action==="confirm"})},confirmDelete:function(title,message,options){options=options||{};options.type="danger";options.confirmText=options.confirmText||"Delete";options.confirmType="danger";return this.confirm(title,message,options)},prompt:function(title,message,options){options=options||{};return show({title:title,message:message,type:options.type||"question",icon:options.icon,size:options.size||"md",input:true,inputType:options.inputType||"text",inputValue:options.inputValue||"",placeholder:options.placeholder||"",html:options.html,buttons:[{text:options.cancelText||"Cancel",type:"secondary",action:"cancel"},{text:options.confirmText||"Submit",type:"primary",action:"confirm"}],backdrop:options.backdrop||"static",keyboard:options.keyboard!==false}).then(function(result){return result.action==="confirm"?result.value:null})},ajax:function(title,urlOrOptions,options){options=options||{};var ajaxOptions=typeof urlOrOptions==="string"?{url:urlOrOptions}:urlOrOptions;return new Promise(function(resolve,reject){var dialogId=uniqueId();var darkModeClass=detectDarkMode();var sizeClass=options.size?"wpdm-dialog--"+options.size:"wpdm-dialog--md";var html='<div class="wpdm-dialog-wrapper w3eden '+darkModeClass+'" id="'+dialogId+'">';html+='<div class="wpdm-dialog-backdrop"></div>';html+='<div class="wpdm-dialog '+sizeClass+'" role="dialog" aria-modal="true" aria-labelledby="'+dialogId+'-title">';if(options.closable!==false){html+='<button type="button" class="wpdm-dialog__close" aria-label="Close">'+icons.close+"</button>"}html+='<div class="wpdm-dialog__header">';if(options.icon!==false){var iconType=options.type||"info";html+='<div class="wpdm-dialog__icon wpdm-dialog__icon--'+iconType+'">'+icons[iconType]+"</div>"}html+='<div class="wpdm-dialog__header-content">';html+='<h3 class="wpdm-dialog__title" id="'+dialogId+'-title">'+escapeHtml(title)+"</h3>";if(options.subtitle){html+='<p class="wpdm-dialog__subtitle">'+escapeHtml(options.subtitle)+"</p>"}html+="</div></div>";html+='<div class="wpdm-dialog__body wpdm-dialog__body--ajax">'+loadingSpinner+"</div>";html+='<div class="wpdm-dialog__footer wpdm-dialog__footer--hidden"></div>';html+="</div></div>";var $dialog=$(html);$("body").append($dialog);var $wrapper=$dialog;var $body=$wrapper.find(".wpdm-dialog__body");var $footer=$wrapper.find(".wpdm-dialog__footer");var $closeBtn=$wrapper.find(".wpdm-dialog__close");requestAnimationFrame(function(){$wrapper.addClass("wpdm-dialog-visible")});function close(result){$wrapper.removeClass("wpdm-dialog-visible");$(document).off("keydown.wpdmDialog");setTimeout(function(){$wrapper.remove();resolve(result)},250)}$closeBtn.on("click",function(){close({action:"close",data:null})});if(options.backdrop!=="static"){$wrapper.find(".wpdm-dialog-backdrop").on("click",function(){close({action:"backdrop",data:null})})}if(options.keyboard!==false){$(document).on("keydown.wpdmDialog",function(e){if(e.key==="Escape"){close({action:"escape",data:null})}})}$.ajax({url:ajaxOptions.url,method:ajaxOptions.method||"GET",data:ajaxOptions.data||{},dataType:ajaxOptions.dataType||"html",headers:ajaxOptions.headers||{},timeout:ajaxOptions.timeout||3e4}).done(function(response){var content=response;var buttons=options.buttons;var responseData=null;if(typeof response==="object"){responseData=response;content=response.content||response.html||response.body||"";if(response.buttons){buttons=response.buttons}}$body.removeClass("wpdm-dialog__body--ajax wpdm-dialog__body--loaded").html(content);requestAnimationFrame(function(){$body.addClass("wpdm-dialog__body--loaded")});if(buttons&&buttons.length>0){var footerHtml="";buttons.forEach(function(btn,index){var btnClass="wpdm-dialog__btn wpdm-dialog__btn--"+(btn.type||"secondary");footerHtml+='<button type="button" class="'+btnClass+'" data-action="'+(btn.action||index)+'">'+escapeHtml(btn.text)+"</button>"});$footer.html(footerHtml).removeClass("wpdm-dialog__footer--hidden");$footer.find(".wpdm-dialog__btn").on("click",function(){var action=$(this).data("action");close({action:action,data:responseData})})}if(typeof options.onLoad==="function"){options.onLoad($body,responseData)}}).fail(function(xhr,status,error){var errorHtml='<div class="wpdm-dialog__error">';errorHtml+='<div class="wpdm-dialog__error-icon">'+icons.danger+"</div>";errorHtml+='<p class="wpdm-dialog__error-message">'+escapeHtml(options.errorMessage||"Failed to load content. Please try again.")+"</p>";if(options.showRetry!==false){errorHtml+='<button type="button" class="wpdm-dialog__btn wpdm-dialog__btn--secondary wpdm-dialog__retry">Retry</button>'}errorHtml+="</div>";$body.removeClass("wpdm-dialog__body--ajax wpdm-dialog__body--loaded").html(errorHtml);requestAnimationFrame(function(){$body.addClass("wpdm-dialog__body--loaded")});$body.find(".wpdm-dialog__retry").on("click",function(){$body.addClass("wpdm-dialog__body--ajax").html(loadingSpinner);$.ajax({url:ajaxOptions.url,method:ajaxOptions.method||"GET",data:ajaxOptions.data||{},dataType:ajaxOptions.dataType||"html",headers:ajaxOptions.headers||{},timeout:ajaxOptions.timeout||3e4}).done(function(response){var content=response;if(typeof response==="object"){content=response.content||response.html||response.body||""}$body.removeClass("wpdm-dialog__body--ajax wpdm-dialog__body--loaded").html(content);requestAnimationFrame(function(){$body.addClass("wpdm-dialog__body--loaded")});if(typeof options.onLoad==="function"){options.onLoad($body,response)}}).fail(function(){$body.removeClass("wpdm-dialog__body--ajax wpdm-dialog__body--loaded").html(errorHtml);requestAnimationFrame(function(){$body.addClass("wpdm-dialog__body--loaded")})})});if(typeof options.onError==="function"){options.onError(xhr,status,error)}})})},load:function(title,url,options){return this.ajax(title,url,options)}}}(jQuery);jQuery(function($){if(typeof WPDM!=="undefined"){WPDM.dialog=WPDMDialog}});