/*! For license information please see index.js.LICENSE.txt */
(()=>{"use strict";const e=window.wp.blocks,t=JSON.parse('{"$schema":"https://schemas.wp.org/trunk/block.json","apiVersion":3,"name":"bpldl/document-library","version":"2.0.1","title":"Document Library","category":"widgets","description":"You can Embed Microsoft Word, Excel And Powerpodint File in wordpress Using \'Document Viewer for Office\' Plugin.","keywords":["block","document viewer","embed document","office viewer","document"],"textdomain":"eov","attributes":{"selectedPostId":{"type":"number","default":0}},"supports":{"align":["wide","full"],"html":false,"interactivity":true},"example":{"attributes":{}},"editorScript":["file:./index.js","wp-api"],"editorStyle":"file:./index.css","style":"file:./view.css","render":"file:./render.php","viewScript":["file:./view.js","react","react-dom"]}'),l=window.React,n=window.wp.blockEditor,a=window.wp.data,r=window.wp.components,o=()=>{setTimeout(()=>{const e=document.querySelectorAll(".bPlPanelBody:not(.itemPanelBody) > h2 > button");function t(){this.removeEventListener("click",t),e.forEach(e=>{"true"!==e.getAttribute("aria-expanded")||e.isEqualNode(this)||e.click()}),setTimeout(()=>{this.addEventListener("click",t)},500)}e.forEach(e=>{e.addEventListener("click",t)})},500)},s=e=>{const t=(e=>e.replace(/^([A-Z])|[\s-_]+(\w)/g,(e,t,l)=>l?l.toUpperCase():t.toLowerCase()))(e);return t.charAt(0).toUpperCase()+t.slice(1)},c=(...e)=>e.filter((e,t,l)=>Boolean(e)&&""!==e.trim()&&l.indexOf(e)===t).join(" ").trim(),i=e=>{for(const t in e)if(t.startsWith("aria-")||"role"===t||"title"===t)return!0};var p={xmlns:"http://www.w3.org/2000/svg",width:24,height:24,viewBox:"0 0 24 24",fill:"none",stroke:"currentColor",strokeWidth:2,strokeLinecap:"round",strokeLinejoin:"round"};const d=(0,l.forwardRef)(({color:e="currentColor",size:t=24,strokeWidth:n=2,absoluteStrokeWidth:a,className:r="",children:o,iconNode:s,...d},m)=>(0,l.createElement)("svg",{ref:m,...p,width:t,height:t,stroke:e,strokeWidth:a?24*Number(n)/Number(t):n,className:c("lucide",r),...!o&&!i(d)&&{"aria-hidden":"true"},...d},[...s.map(([e,t])=>(0,l.createElement)(e,t)),...Array.isArray(o)?o:[o]])),m=(e,t)=>{const n=(0,l.forwardRef)(({className:n,...a},r)=>{return(0,l.createElement)(d,{ref:r,iconNode:t,className:c(`lucide-${o=s(e),o.replace(/([a-z0-9])([A-Z])/g,"$1-$2").toLowerCase()}`,`lucide-${e}`,n),...a});var o});return n.displayName=s(e),n},u=m("file-text",[["path",{d:"M15 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7Z",key:"1rqfz7"}],["path",{d:"M14 2v4a2 2 0 0 0 2 2h4",key:"tnqrlb"}],["path",{d:"M10 9H8",key:"b1mrlr"}],["path",{d:"M16 13H8",key:"t4e002"}],["path",{d:"M16 17H8",key:"z1uh3a"}]]),b=m("image",[["rect",{width:"18",height:"18",x:"3",y:"3",rx:"2",ry:"2",key:"1m3agn"}],["circle",{cx:"9",cy:"9",r:"2",key:"af1f0g"}],["path",{d:"m21 15-3.086-3.086a2 2 0 0 0-2.828 0L6 21",key:"1xmnt7"}]]),h=m("video",[["path",{d:"m16 13 5.223 3.482a.5.5 0 0 0 .777-.416V7.87a.5.5 0 0 0-.752-.432L16 10.5",key:"ftymec"}],["rect",{x:"2",y:"6",width:"14",height:"12",rx:"2",key:"158x01"}]]),g=m("music",[["path",{d:"M9 18V5l12-2v13",key:"1jmyc2"}],["circle",{cx:"6",cy:"18",r:"3",key:"fqmcym"}],["circle",{cx:"18",cy:"16",r:"3",key:"1hluhg"}]]),y=m("archive",[["rect",{width:"20",height:"5",x:"2",y:"3",rx:"1",key:"1wp1u1"}],["path",{d:"M4 8v11a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8",key:"1s80jp"}],["path",{d:"M10 12h4",key:"a56b0p"}]]),v=m("file",[["path",{d:"M15 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7Z",key:"1rqfz7"}],["path",{d:"M14 2v4a2 2 0 0 0 2 2h4",key:"tnqrlb"}]]),f=m("search",[["path",{d:"m21 21-4.34-4.34",key:"14j7rj"}],["circle",{cx:"11",cy:"11",r:"8",key:"4ej97u"}]]),$=m("calendar",[["path",{d:"M8 2v4",key:"1cmpym"}],["path",{d:"M16 2v4",key:"4m81vk"}],["rect",{width:"18",height:"18",x:"3",y:"4",rx:"2",key:"1hopcy"}],["path",{d:"M3 10h18",key:"8toen8"}]]),w=m("eye",[["path",{d:"M2.062 12.348a1 1 0 0 1 0-.696 10.75 10.75 0 0 1 19.876 0 1 1 0 0 1 0 .696 10.75 10.75 0 0 1-19.876 0",key:"1nclc0"}],["circle",{cx:"12",cy:"12",r:"3",key:"1v7zrd"}]]),E=m("download",[["path",{d:"M12 15V3",key:"m9g1x1"}],["path",{d:"M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4",key:"ih7n3h"}],["path",{d:"m7 10 5 5 5-5",key:"brsn70"}]]),D=m("x",[["path",{d:"M18 6 6 18",key:"1bl5f8"}],["path",{d:"m6 6 12 12",key:"d8bk6v"}]]),k=({document:e,onClose:t})=>e?(0,l.createElement)("div",{className:"bplDl-modal-overlay"},(0,l.createElement)("div",{className:"bplDl-modal"},(0,l.createElement)("button",{className:"bplDl-modal-close",onClick:t},(0,l.createElement)(D,null)),(0,l.createElement)("div",{className:"bplDl-modal-body"},(e=>{const t=(e=>e.split(".").pop().toLowerCase())(e.url),n=e.url;return["jpg","jpeg","png","gif","webp"].includes(t)?(0,l.createElement)("img",{src:n,alt:e.title,className:"bplDl-preview-image"}):["mp4","webm","ogg"].includes(t)?(0,l.createElement)("video",{controls:!0,src:n,className:"bplDl-preview-video"}):["mp3","wav","ogg"].includes(t)?(0,l.createElement)("div",{className:"bplDl-audio-wrapper"},(0,l.createElement)("audio",{controls:!0,className:"bplDl-audio-player"},(0,l.createElement)("source",{src:n,type:`audio/${t}`}),"Your browser does not support the audio element."),(0,l.createElement)("p",{className:"bplDl-audio-title"},e.title)):"pdf"===t?(0,l.createElement)("iframe",{src:`//docs.google.com/gview?embedded=true&url=${n}`,title:e.title,className:"bplDl-preview-iframe"}):["ppt","pptx"].includes(t)||["xls","xlsx"].includes(t)||["doc","docx"].includes(t)?(0,l.createElement)("iframe",{src:`https://view.officeapps.live.com/op/embed.aspx?src=${encodeURIComponent(n)}`,className:"bplDl-preview-iframe",title:e.title}):(0,l.createElement)("div",{className:"bplDl-preview-unknown"},(0,l.createElement)("iframe",{src:n,title:e.title,className:"bplDl-preview-iframe"}),(0,l.createElement)("a",{href:n,target:"_blank",rel:"noreferrer",className:"bplDl-download-link"},"Download File"))})(e)))):null,x=(e,t)=>{return null==(l=t)||""===l||Array.isArray(l)&&0===l.length||"object"==typeof l&&0===Object.keys(l).length||"string"==typeof l&&""===l.trim()||"number"==typeof l&&0===l?"":`${e}: ${t};`;var l},N=e=>{if(!e)return"";const t=e=>{const{color:t="#000000",style:l="solid",width:n="0px"}=e;return`${n} ${l} ${t}`};return"object"!=typeof e||Array.isArray(e)?"":e.hasOwnProperty("top")||e.hasOwnProperty("right")||e.hasOwnProperty("bottom")||e.hasOwnProperty("left")?["top","right","bottom","left"].map(l=>e[l]?`border-${l}: ${t(e[l])};`:"").join(" ").trim():x("border",t(e))},C=(e,t,l=!0)=>{const{fontFamily:n="Default",fontCategory:a="sans-serif",fontVariant:r=400,fontWeight:o,isUploadFont:s=!0,fontSize:c={desktop:null,tablet:null,mobile:null},fontStyle:i,textTransform:p,textDecoration:d,lineHeight:m,letterSpace:u}=t||{},b=!l||!n||"Default"===n,h=c?.desktop||c,g=c?.tablet||h,y=c?.mobile||g,v=e=>{const t=String(e);return["px","em","rem","%","vh","vw"].some(e=>t.endsWith(e))?t:"number"==typeof e?`${t}px`:""},f=`\n\t\t${b?"":`font-family: '${n}', ${a};`}\n\t\t${x("font-weight",o)}\n\t\t${x("font-size",v(h))}\n\t\t${x("font-style",i)}\n\t\t${x("text-transform",p)}\n\t\t${x("text-decoration",d)}\n\t\t${x("line-height",m)}\n\t\t${x("letter-spacing",u)}\n\t`,$=r&&400!==r?"400i"===r?":ital@1":r?.includes("00i")?`: ital, wght@1, ${r?.replace("00i","00")} `:`: wght@${r} `:"",w=b?"":`https://fonts.googleapis.com/css2?family=${n?.split(" ").join("+")}${$.replace(/ /g,"")}&display=swap`;return{googleFontLink:!s||b?"":`@import url(${w});`,styles:`${e}{\n\t\t\t${f}\n\t\t}\n\t\t@media only screen and (max-width: 1024px) {\n\t\t\t${e}{\n\t\t\t\t${x("font-size",v(g))}\n\t\t\t}\n\t\t}\n\t\t@media only screen and (max-width: 640px) {\n\t\t\t${e}{\n\t\t\t\t${x("font-size",v(y))}\n\t\t\t}\n\t\t}`.replace(/\s+/g," ").trim()}},z=e=>{if(!e)return"";if("string"==typeof e)return e;if("object"==typeof e&&!Array.isArray(e)){const t=["top","right","bottom","left"];return t.map(t=>e[t]||"").every(e=>!e)?"":t.map(t=>e[t]||"0").join(" ")}return""},F=({settingsData:e,id:t})=>{const{styles:n,header:a,documentLibrary:r}=e,{toolbarBox:o,documentBox:s,docsViewPerRow:c}=r,{isDisplayToolbar:i,isDisplayFilterType:p,isDisplaySearchBox:d,isDisplaySortBy:m}=o,{downloadButton:u,viewButton:b,options:h}=s,{displayIcon:g,displaySize:y,displayDate:v}=h,{header:f}=n,$=`#${t} .bplDl-container`,w=`${$} .bplDl-header`,E=`${w} .bplDl-title`,D=`${w} .bplDl-subtitle`,k=`${$} .bplDl-content`,x=`${k} .bplDl-toolbar`,F=`${x} .bplDl-search`,B=`${x} .bplDl-select`,S=`${x} .bplDl-select-sort`,j=`${k} .bplDl-grid`,A=`${j} .bplDl-card`,L=`${A} .bplDl-name`,M=`${A} .bplDl-size`,P=`${A} .bplDl-meta`,I=`${A} .bplDl-card-top svg`,O=`${A} .bplDl-actions .bplDl-btn.bplDl-download-btn`,V=`${A} .bplDl-actions .bplDl-btn.bplDl-view-btn`;return(0,l.createElement)(l.Fragment,null,(0,l.createElement)("style",{dangerouslySetInnerHTML:{__html:`\n          ${C("",f?.title.typo)?.googleFontLink}\n          ${C("",f?.description.typo)?.googleFontLink}\n          ${C(`${E}`,f?.title.typo).styles}\n          ${C(`${D}`,f?.description.typo).styles}\n\n          ${w} {\n            display: ${a.isDisplayHeader?"block":"none"};\n            background: ${f.bgColor};\n            text-align: ${a.textAlign};\n          }\n          ${E} {\n            color: ${f.title.color};  \n          }\n          ${D} {\n            color: ${f.description.color};  \n          }\n          ${k} {\n            background: ${r.bgColor};\n            padding: ${z(r?.padding)};\n          }\n          ${x} {\n            ${i?"":"display: none"};\n            padding: ${z(o?.padding)};\n            background: ${o?.bgColor};\n          }\n          ${F} {\n            ${d?"":"display: none"};\n          }\n          ${B} {\n            ${p?"":"display: none"};\n          }\n          ${S} {\n            ${m?"":"display: none"};\n          }\n          ${j} {\n            grid-template-columns: repeat(${c},  minmax(0, 1fr));\n            gap: ${r?.rowGap}px;\n          }\n          ${A} {\n            background: ${s.bgColor.normal};\n            padding: ${z(s?.padding)};\n            ${N(s?.border?.normal)};\n            border-radius: ${s?.borderRadius}px;\n          }\n          ${A}:hover  {\n            background: ${s.bgColor.hover};\n            ${N(s?.border?.hover)};\n          }\n          ${I} {\n            ${g?"":"display: none"};\n            color: ${s.iconColor.normal};\n          }\n          ${L} {\n            color: ${s.fileNameColor.normal};\n          }\n          ${M} {\n            ${y?"":"display: none"};\n            color: ${s.sizeColor.normal};\n          }\n          ${P} {\n            ${v?"":"display: none"};\n            color: ${s.dateColor.normal};\n          }\n          ${A}:hover .bplDl-card-top svg{\n            color: ${s.iconColor.hover};\n          }\n          ${A}:hover .bplDl-name {\n            color: ${s.fileNameColor.hover};\n          }\n          ${A}:hover .bplDl-size {\n            color: ${s.sizeColor.hover};\n          }\n          ${A}:hover .bplDl-meta {\n            color: ${s.dateColor.hover};\n          }\n          ${O} {\n            ${u.isDisplay?"":"display: none"};\n            color: ${u.textColor.normal};\n            background: ${u.bgColor.normal};\n          }\n          ${O}:hover {\n            color: ${u.textColor.hover};\n            background: ${u.bgColor.hover};\n          }\n          ${O}>span {\n            ${u.isText?"":"display: none"};\n          }\n          ${V} {\n            ${b.isDisplay?"":"display: none"};\n            color: ${b.textColor.normal};\n            background: ${b.bgColor.normal};\n          }\n          ${V}:hover {\n            color: ${b.textColor.hover};\n            background: ${b.bgColor.hover};\n          }\n          ${V}>span {\n            ${b.isText?"":"display: none"};\n          }\n            \n          \n          `.replace(/\s+/g," ")}}))},B=function(e){const{settingsData:t,id:n=null}=e,[a,r]=(0,l.useState)(""),[o,s]=(0,l.useState)("all"),[c,i]=(0,l.useState)(null),[p,d]=(0,l.useState)("default"),{header:m,documentLibrary:D}=t,{documentBox:x,docItems:N=[]}=D,{downloadButton:C,viewButton:z,options:B}=x,{displaySize:S,displayDate:j,displayIcon:A}=B,[L,M]=(0,l.useState)([...N]);(0,l.useEffect)(()=>{M([...N])},[N]);const P={Images:["png","jpg","jpeg","gif","webp"],Videos:["mp4","avi","mov","mkv"],PDF:["pdf"],Documents:["doc","docx","xls","xlsx","ppt","pptx","pages"],Audio:["mp3","wav","ogg"],Archives:["zip","rar","7z"]},I=e=>{const t=(e.url||"").toLowerCase().split(".").pop().split("?")[0].split("#")[0];for(const[e,l]of Object.entries(P))if(l.includes(t))return e;return"Others"},O=Array.from(new Set(L.map(e=>I(e)))),V=L.filter(e=>{var t;const l=a.toLowerCase(),n=e.title.toLowerCase().includes(l)||(null!==(t=e.url?.toLowerCase())&&void 0!==t?t:"").includes(l),r=I(e);return n&&("all"===o||r===o)}),T=e=>{if(!e)return new Date(0);const[t,l,n]=e.split("/").map(Number);return new Date(n,l-1,t)},H=e=>{if(!e)return 0;const[t,l]=e.split(" ");return parseFloat(t)*({B:1,KB:1024,MB:1048576,GB:1024**3}[l]||1)},_=[...V].sort((e,t)=>{switch(p){case"name-asc":return e.title.localeCompare(t.title);case"name-desc":return t.title.localeCompare(e.title);case"date-asc":return T(e.date)-T(t.date);case"date-desc":return T(t.date)-T(e.date);case"size-asc":return H(e.size)-H(t.size);case"size-desc":return H(t.size)-H(e.size);default:return 0}});return(0,l.createElement)(l.Fragment,null,(0,l.createElement)(F,{settingsData:t,id:n}),(0,l.createElement)("div",{className:"bplDl-container"},(0,l.createElement)("div",{className:"bplDl-header"},(0,l.createElement)("h1",{className:"bplDl-title"},m.title),(0,l.createElement)("p",{className:"bplDl-subtitle"},m.description)),(0,l.createElement)("div",{className:"bplDl-content"},(0,l.createElement)("div",{className:"bplDl-toolbar"},(0,l.createElement)("div",{className:"bplDl-search"},(0,l.createElement)(f,{className:"bplDl-search-icon"}),(0,l.createElement)("input",{type:"text",placeholder:"Search documents, authors, or tags...",className:"bplDl-search-input",value:a,onChange:e=>r(e.target.value)})),(0,l.createElement)("select",{className:"bplDl-select",value:o,onChange:e=>s(e.target.value)},(0,l.createElement)("option",{value:"all"},"All Types"),O.map(e=>(0,l.createElement)("option",{key:e,value:e},e))),(0,l.createElement)("select",{className:"bplDl-select-sort",value:p,onChange:e=>d(e.target.value)},(0,l.createElement)("option",{value:"default"},"Sort By"),(0,l.createElement)("option",{value:"name-asc"},"Name (A → Z)"),(0,l.createElement)("option",{value:"name-desc"},"Name (Z → A)"),(0,l.createElement)("option",{value:"date-asc"},"Date (Oldest)"),(0,l.createElement)("option",{value:"date-desc"},"Date (Newest)"),(0,l.createElement)("option",{value:"size-asc"},"Size (Smallest)"),(0,l.createElement)("option",{value:"size-desc"},"Size (Largest)"))),0!==_.length?(0,l.createElement)("div",{className:"bplDl-grid"},_.map(e=>{return(0,l.createElement)("div",{key:`${e.id}-${e.title}`,className:"bplDl-card"},A&&(0,l.createElement)("div",{className:"bplDl-card-top"},(t=e?.type,t.includes("pdf")||t.includes("doc")?(0,l.createElement)(u,{className:"bplDl-icon"}):t.includes("png")||t.includes("jpg")||t.includes("jpeg")?(0,l.createElement)(b,{className:"bplDl-icon"}):t.includes("mp4")||t.includes("avi")||t.includes("mov")?(0,l.createElement)(h,{className:"bplDl-icon"}):t.includes("mp3")||t.includes("wav")?(0,l.createElement)(g,{className:"bplDl-icon"}):t.includes("zip")||t.includes("rar")?(0,l.createElement)(y,{className:"bplDl-icon"}):(0,l.createElement)(v,{className:"bplDl-icon"}))),(0,l.createElement)("h3",{className:"bplDl-name"},e.title),S&&(0,l.createElement)("p",{className:"bplDl-size"},"Size: ",e.size),j&&(0,l.createElement)("div",{className:"bplDl-meta"},(0,l.createElement)($,{className:"bplDl-meta-icon"})," ",e.date),(0,l.createElement)("div",{className:"bplDl-actions"},(0,l.createElement)("button",{className:"bplDl-btn bplDl-view-btn",onClick:()=>{i(e)}},(0,l.createElement)(w,{className:"bplDl-btn-icon"}),(0,l.createElement)("span",null,z.text)),(0,l.createElement)("button",{className:"bplDl-btn bplDl-download-btn",onClick:()=>(e=>{const t=e.url,l=document.createElement("a");l.href=t,l.download=e.title,l.click(),URL.revokeObjectURL(t)})(e)},(0,l.createElement)(E,{className:"bplDl-btn-icon"}),(0,l.createElement)("span",null,C.text))));var t})):(0,l.createElement)("div",{className:"bplDl-empty"},(0,l.createElement)(v,{className:"bplDl-empty-icon"}),(0,l.createElement)("p",{className:"bplDl-empty-text"},"No documents found")))),(0,l.createElement)(k,{document:c,onClose:()=>i(null)}))},S=()=>(0,l.createElement)(l.Fragment,null,(0,l.createElement)(n.InspectorControls,null,(0,l.createElement)("div",{className:"bBlocksInspectorInfo"},"Need more block like this? Checkout the bundle ➡"," ",(0,l.createElement)("a",{href:"https://wordpress.org/plugins/b-blocks",target:"_blank",rel:"noopener noreferrer"},"B Blocks")))),j=(0,l.createElement)("svg",{version:"1.1",viewBox:"0 0 300 300",xmlns:"http://www.w3.org/2000/svg"},(0,l.createElement)("path",{transform:"translate(0)",d:"m0 0h300v300h-300v-300z",fill:"#FCFBFC"}),(0,l.createElement)("path",{transform:"translate(68,131)",d:"m0 0 1 98c3.7996-9.1005 3.7996-9.1005 7.5396-18.224 0.4304-1.0608 0.86079-2.1217 1.3042-3.2147 0.44601-1.1004 0.89201-2.2009 1.3515-3.3346 0.97254-2.3946 1.9452-4.7891 2.918-7.1836 1.513-3.7256 3.0255-7.4514 4.5356-11.178 1.4712-3.6305 2.9462-7.2593 4.4214-10.888 0.45005-1.1126 0.90011-2.2251 1.3638-3.3714 6.085-14.95 6.085-14.95 10.566-17.605 2.9614-0.38032 2.9614-0.38032 6.4836-0.38768 0.97376-0.0080783 0.97376-0.0080783 1.9672-0.01632 2.1734-0.014298 4.3462-0.0071718 6.5196-5.286e-5 1.559-0.0057027 3.1179-0.012667 4.6769-0.020798 4.2335-0.017958 8.4668-0.016758 12.7-0.011058 3.5339 0.0030881 7.0677-0.0029963 10.602-0.0090388 8.3367-0.014052 16.673-0.012478 25.01-0.0010981 8.6013 0.011482 17.202-0.0025935 25.804-0.029396 7.3844-0.02215 14.769-0.028796 22.153-0.022924 4.4106 0.0033726 8.8209 9.3461e-4 13.231-0.016251 4.1476-0.015455 8.2948-0.011529 12.442 0.0073051 1.5218 0.0036898 3.0436 5.6588e-4 4.5653-0.0098858 2.0786-0.013186 4.1557-0.0016866 6.2343 0.015991 1.7441 3.1392e-4 1.7441 3.1392e-4 3.5234 6.3419e-4 3.7408 0.60654 5.3991 1.8821 8.0872 4.5006 1.4763 2.9526 1.3193 4.6673 1 8-1.2474 3.6839-2.8522 7.2009-4.4375 10.75-1.0113 2.324-2.0188 4.6497-3.0234 6.9766-0.2746 0.63465-0.54919 1.2693-0.83211 1.9232-3.5243 8.1843-6.8334 16.456-10.16 24.722-1.1067 2.7475-2.2169 5.4934-3.3285 8.239-4.3421 10.723-4.3421 10.723-8.6334 21.466-1.1015 2.7702-2.2196 5.5337-3.3346 8.2984-0.3694 0.94891-0.73879 1.8978-1.1194 2.8755-0.34732 0.8532-0.69464 1.7064-1.0525 2.5854-0.28456 0.7172-0.56912 1.4344-0.8623 2.1733-1.6909 2.7687-3.5198 4.1815-6.2158 5.9907-3.1157 0.50057-3.1157 0.50057-6.6798 0.50121-0.98729 0.0083016-0.98729 0.0083016-1.9945 0.016771-2.1981 0.013577-4.3951-0.0013451-6.5932-0.016267-1.5788 0.0037843-3.1576 0.0092852-4.7364 0.016373-4.2831 0.013958-8.5658 0.0027827-12.849-0.013711-4.4833-0.013854-8.9666-0.00739-13.45-0.0038669-7.5288 0.0027018-15.058-0.010771-22.586-0.033951-8.703-0.02661-17.406-0.028357-26.109-0.016612-8.3737 0.010781-16.747 0.0045881-25.121-0.0095553-3.5629-0.0057569-7.1257-0.0056795-10.689-9.346e-4 -4.196 0.0047742-8.3917-0.00535-12.588-0.026955-1.5395-0.0055621-3.079-0.0060385-4.6185-0.0010471-2.1024 0.0059614-4.204-0.0065673-6.3064-0.023769-1.1762-0.0024299-2.3523-0.0048598-3.5641-0.0073633-3.4806-0.42486-5.3303-1.2817-8.1157-3.3803-2.0466-3.0699-2.4861-4.7214-3.1133-8.2852-0.19352-1.0756-0.38704-2.1511-0.58643-3.2593-0.20222-1.161-0.40444-2.3219-0.61279-3.5181-0.44062-2.452-0.88205-4.9038-1.3242-7.3555-0.33717-1.884-0.33717-1.884-0.68115-3.8062-1.0642-5.891-2.1804-11.772-3.3071-17.651-0.19376-1.0249-0.38752-2.0498-0.58716-3.1057-0.96994-5.0632-2.0232-10.089-3.2136-15.105-1.9917-8.5009-3.5453-17.081-5.1367-25.664-0.45742-2.4595-0.91569-4.9188-1.3757-7.3777-0.28324-1.5146-0.56499-3.0295-0.84488-4.5448-0.83188-4.4567-1.7706-8.8764-2.7998-13.292-0.96584-4.7133-1.2053-7.827 1.4579-11.911 8.4862-8.4862 15.262-3.125 31.125-3.125z",fill:"#1F3C88"}),(0,l.createElement)("path",{transform:"translate(47.102 130.9)",d:"m0 0c1.2117 0.0032227 2.4234 0.0064453 3.6719 0.0097656 1.271 0.0083789 2.542 0.016758 3.8516 0.025391 1.2788 0.0045117 2.5575 0.0090234 3.875 0.013672 3.1667 0.011816 6.3333 0.02829 9.5 0.048828 0.11616 13.353 0.20485 26.705 0.25906 40.058 0.026026 6.2012 0.061296 12.402 0.11814 18.603 0.054569 5.9912 0.084276 11.982 0.097189 17.973 0.0091952 2.2788 0.027151 4.5576 0.054264 6.8363 0.26003 22.772 0.26003 22.772-5.5287 32.529-1.5459 3.0917-1.2936 5.5943-1 9 2.1555 2.9336 3.3557 3.89 6.9754 4.5078 1.1688 0.0036872 2.3377 0.0073743 3.5419 0.011173 0.6527 0.0075013 1.3054 0.015003 1.9779 0.022731 2.1852 0.020286 4.3694 0.012174 6.5546 0.0041854 1.5671 0.0087346 3.1342 0.01922 4.7012 0.031326 4.2538 0.027895 8.5074 0.031264 12.761 0.03028 4.4457 0.0031261 8.8913 0.028738 13.337 0.05198 8.4182 0.040587 16.836 0.060907 25.255 0.073974 9.584 0.015861 19.168 0.054273 28.752 0.094593 19.715 0.082435 39.429 0.1365 59.144 0.17195v1c-20.905 0.070062-41.811 0.12297-62.716 0.15544-9.7067 0.015473-19.413 0.03657-29.12 0.070882-8.4597 0.02989-16.919 0.049254-25.379 0.055947-4.4799 0.003913-8.9597 0.013118-13.44 0.034925-4.2164 0.020358-8.4326 0.026645-12.649 0.022133-1.5476 8.2551e-4 -3.0952 0.0067953-4.6427 0.018293-2.1136 0.014934-4.2264 0.011335-6.34 0.0031471-1.1827 0.0027654-2.3653 0.0055308-3.5838 0.0083799-3.4955-0.4123-5.3361-1.2602-8.1296-3.3691-2.0466-3.0699-2.4861-4.7214-3.1133-8.2852-0.19352-1.0756-0.38704-2.1511-0.58643-3.2593-0.20222-1.161-0.40444-2.3219-0.61279-3.5181-0.44062-2.452-0.88205-4.9038-1.3242-7.3555-0.33717-1.884-0.33717-1.884-0.68115-3.8062-1.0642-5.891-2.1804-11.772-3.3071-17.651-0.19376-1.0249-0.38752-2.0498-0.58716-3.1057-0.96994-5.0632-2.0232-10.089-3.2136-15.105-1.9917-8.5009-3.5453-17.081-5.1367-25.664-0.45742-2.4595-0.91569-4.9188-1.3757-7.3777-0.28324-1.5146-0.56499-3.0295-0.84488-4.5448-0.83188-4.4567-1.7706-8.8764-2.7998-13.292-0.96584-4.7133-1.2053-7.827 1.4579-11.911 3.4249-3.4249 5.4829-3.2448 10.227-3.2227z",fill:"#506FC0"}),(0,l.createElement)("path",{transform:"translate(79.125 84.938)",d:"m0 0c1.0957 0.0090234 2.1914 0.018047 3.3203 0.027344 0.84305 0.011602 1.6861 0.023203 2.5547 0.035156 0.0080868 1.1938 0.016174 2.3876 0.024506 3.6176 0.077432 11.242 0.16516 22.484 0.26302 33.726 0.049979 5.7798 0.096309 11.559 0.13435 17.339 0.036832 5.5762 0.083187 11.152 0.13619 16.728 0.018555 2.1291 0.033659 4.2581 0.04528 6.3873 0.016843 2.9785 0.045874 5.9567 0.077808 8.9351 0.0021602 0.88329 0.0043204 1.7666 0.006546 2.6766 0.011163 0.81326 0.022327 1.6265 0.033829 2.4644 0.0055308 0.70425 0.011062 1.4085 0.01676 2.1341 0.15593 2.0777 0.15593 2.0777 1.3403 4.0387 0.92142 1.9527 0.92142 1.9527-0.057337 5.3216-0.55504 1.3407-1.1272 2.6745-1.7126 4.0022-0.45257 1.0773-0.45257 1.0773-0.91429 2.1763-0.97111 2.3032-1.9632 4.5966-2.9568 6.8901-0.96096 2.2563-1.9175 4.5144-2.8739 6.7726-0.6257 1.4761-1.2533 2.9513-1.8829 4.4257-2.7234 6.3949-5.2467 12.853-7.6808 19.364h-1c-0.13287-12.478-0.26338-24.956-0.39115-37.434-0.05945-5.7989-0.11961-11.598-0.1816-17.397-0.13017-12.22-0.24853-24.441-0.34291-36.662-0.049887-6.2151-0.12207-12.429-0.21502-18.644-0.052748-3.7473-0.089489-7.4947-0.12223-11.242-0.01868-1.7283-0.044366-3.4565-0.077545-5.1846-0.044392-2.3542-0.064074-4.7074-0.077744-7.062-0.017765-1.3123-0.03553-2.6245-0.053833-3.9766 0.54039-3.9748 1.6567-5.5903 4.462-8.3984 2.7645-1.3823 5.0461-1.0953 8.125-1.0625z",fill:"#BCCDF5"}),(0,l.createElement)("path",{transform:"translate(110.28 127.74)",d:"m0 0c0.89873-0.0070848 1.7975-0.01417 2.7234-0.021469 0.98863 0.0024774 1.9773 0.0049548 2.9958 0.0075073 1.0391-0.0051109 2.0782-0.010222 3.1488-0.015488 3.4486-0.013946 6.897-0.012935 10.346-0.010635 2.3889-0.0038842 4.7778-0.0082183 7.1668-0.012985 5.0129-0.0074729 10.026-0.0071632 15.039-0.0019074 6.4343 0.005796 12.868-0.011134 19.303-0.034345 4.9353-0.014709 9.8705-0.015613 14.806-0.01249 2.3727-5.1467e-4 4.7455-0.0057794 7.1182-0.015812 3.3138-0.012291 6.6271-0.0056165 9.9409 0.0060062 1.4799-0.011466 1.4799-0.011466 2.9897-0.023163 0.90155 0.0070143 1.8031 0.014029 2.732 0.021255 1.1755-2.5161e-4 1.1755-2.5161e-4 2.3748-5.0831e-4 2.575 0.47425 3.4946 1.2845 5.0346 3.3747-0.42105 4.4211-0.42105 4.4211-2 6-1.4121 0.09982-2.8292 0.13075-4.2449 0.13371-1.3734 0.0063975-1.3734 0.0063975-2.7746 0.012924-1.0125-4.5318e-4 -2.025-9.0637e-4 -3.0682-0.0013733-1.0601 0.0033586-2.1201 0.0067172-3.2123 0.010178-3.5237 0.0095423-7.0474 0.011455-10.571 0.012527-2.4376 0.0032102-4.8752 0.0065741-7.3128 0.010086-5.1172 0.0059994-10.234 0.0078391-15.352 0.0072479-6.5723-1.0169e-4 -13.144 0.013553-19.717 0.030772-5.0364 0.011093-10.073 0.013148-15.109 0.012618-2.4238 0.0011841-4.8476 0.00563-7.2714 0.013332-3.3835 0.0097452-6.7667 0.0069436-10.15 8.9454e-4 -1.5157 0.0084293-1.5157 0.0084293-3.062 0.017029-0.91845-0.0041945-1.8369-0.008389-2.7832-0.012711-0.80066 5.4477e-4 -1.6013 0.0010895-2.4262 0.0016508-1.9456-0.24889-1.9456-0.24889-3.9456-2.2489 0.52868-5.2868 1.9401-7.2467 7.2825-7.2607z",fill:"#E5F0FC"}),(0,l.createElement)("path",{transform:"translate(110.28 102.86)",d:"m0 0c0.89873-0.0057101 1.7975-0.01142 2.7234-0.017303 1.4829-0.0016768 1.4829-0.0016768 2.9958-0.0033874 1.5587-0.0074474 1.5587-0.0074474 3.1488-0.015045 3.4485-0.014644 6.897-0.021427 10.346-0.026947 2.3889-0.0057489 4.7778-0.011507 7.1668-0.017273 5.0129-0.010516 10.026-0.016355 15.039-0.019836 6.4343-0.0054909 12.868-0.029529 19.303-0.057972 4.9353-0.018589 9.8705-0.02383 14.806-0.025364 2.3727-0.0030346 4.7455-0.01109 7.1182-0.024185 3.3138-0.016986 6.6271-0.015199 9.9409-0.0086899 1.4799-0.013822 1.4799-0.013822 2.9897-0.027924 0.90155 0.0055692 1.8031 0.011138 2.732 0.016876 0.78369-0.0014666 1.5674-0.0029331 2.3748-0.0044441 2.6137 0.47779 3.5059 1.2156 5.0346 3.3719v4h-2v2c-14.177 0.04668-28.355 0.081837-42.532 0.10362-6.5825 0.010455-13.165 0.024645-19.747 0.047255-6.3477 0.021668-12.695 0.033677-19.043 0.038876-2.4266 0.0037067-4.8532 0.010945-7.2798 0.021706-3.3884 0.014434-6.7765 0.016521-10.165 0.015591-1.5181 0.010786-1.5181 0.010786-3.0668 0.02179-0.91989-0.0027493-1.8398-0.0054987-2.7876-0.0083313-0.80196 0.0018436-1.6039 0.0036872-2.4302 0.0055866-1.9484-0.2461-1.9484-0.2461-3.9484-2.2461 0.25-3.0625 0.25-3.0625 1-6 2.3292-1.1646 3.6881-1.1306 6.2825-1.1404z",fill:"#BFDAF8"}),(0,l.createElement)("path",{transform:"translate(110.28 75.86)",d:"m0 0c0.89873-0.0057101 1.7975-0.01142 2.7234-0.017303 1.4829-0.0016768 1.4829-0.0016768 2.9958-0.0033874 1.5587-0.0074474 1.5587-0.0074474 3.1488-0.015045 3.4485-0.014644 6.897-0.021427 10.346-0.026947 2.3889-0.0057489 4.7778-0.011507 7.1668-0.017273 5.0129-0.010516 10.026-0.016355 15.039-0.019836 6.4343-0.0054909 12.868-0.029529 19.303-0.057972 4.9353-0.018589 9.8705-0.02383 14.806-0.025364 2.3727-0.0030346 4.7455-0.01109 7.1182-0.024185 3.3138-0.016986 6.6271-0.015199 9.9409-0.0086899 1.4799-0.013822 1.4799-0.013822 2.9897-0.027924 0.90155 0.0055692 1.8031 0.011138 2.732 0.016876 0.78369-0.0014666 1.5674-0.0029331 2.3748-0.0044441 2.5767 0.47103 3.4914 1.2835 5.0346 3.3719-0.1875 2.625-0.1875 2.625-1 5-2.3417 1.1708-3.7177 1.1282-6.3271 1.1337-0.90859 0.004265-1.8172 0.00853-2.7533 0.012924-0.99955-4.5319e-4 -1.9991-9.0637e-4 -3.0289-0.0013733-1.0505 0.0033586-2.1009 0.0067172-3.1832 0.010178-3.4858 0.0095293-6.9716 0.011454-10.457 0.012527-2.4137 0.0032108-4.8275 0.0065748-7.2412 0.010086-5.0641 0.005996-10.128 0.0078394-15.192 0.0072479-6.5038-1.0174e-4 -13.008 0.01356-19.511 0.030772-4.9858 0.011092-9.9716 0.013148-14.957 0.012618-2.3987 0.001184-4.7974 0.005629-7.196 0.013332-3.3475 0.0097448-6.6947 0.0069439-10.042 8.9455e-4 -0.99955 0.0056195-1.9991 0.011239-3.0289 0.017029-0.90859-0.0041945-1.8172-0.008389-2.7533-0.012711-0.79199 5.4477e-4 -1.584 0.0010895-2.4 0.0016508-1.9272-0.24889-1.9272-0.24889-3.9272-2.2489 0.25-3.0625 0.25-3.0625 1-6 2.3292-1.1646 3.6881-1.1306 6.2825-1.1404z",fill:"#BFDAF8"}),(0,l.createElement)("path",{transform:"translate(114 48.832)",d:"m0 0c0.79148-0.0033284 1.583-0.0066568 2.3984-0.010086 1.6745-0.0050656 3.349-0.0074084 5.0234-0.0072479 2.5679-0.0021885 5.1353-0.020353 7.7031-0.039307 1.625-0.0029335 3.25-0.0049186 4.875-0.0058594 1.1563-0.010778 1.1563-0.010778 2.3359-0.021774 5.4352 0.023416 5.4352 0.023416 7.6641 2.2522 0.25 2.5 0.25 2.5 0 5-2.5706 2.5706-4.3109 2.258-7.8165 2.3035-1.1891-0.0013671-1.1891-0.0013671-2.4022-0.0027618-0.81368 0.0042851-1.6274 0.0085702-2.4657 0.012985-1.7215 0.0057469-3.4431 0.0062409-5.1647 0.0019074-2.6406-0.0031615-5.28 0.020299-7.9204 0.045654-1.6706 0.0022727-3.3411 0.0029766-5.0117 0.0019531-0.79273 0.0092098-1.5855 0.018419-2.4022 0.027908-2.2247-0.018875-2.2247-0.018875-5.8165-0.39119-2-3-2-3-1.75-5.625 0.2475-0.78375 0.495-1.5675 0.75-2.375 3.1533-1.5767 6.5376-1.163 10-1.168z",fill:"#5C9FED"}),(0,l.createElement)("path",{transform:"translate(27,75)",d:"m0 0c2.5 1.5625 2.5 1.5625 4 4 0.55802 3.9061 0.58393 6.0511-1.5 9.4375-3.0304 1.894-5.0583 2.2058-8.5898 2.0078-1.9102-0.44531-1.9102-0.44531-4.4727-2.5078-1.8738-3.829-1.5671-5.8708-0.4375-9.9375 2.2829-4.163 6.773-3.7484 11-3z",fill:"#BDCEFE"}),(0,l.createElement)("path",{transform:"translate(266,21)",d:"m0 0 4 1 1 7c2.97-0.66 5.94-1.32 9-2v4c-2.31 0.33-4.62 0.66-7 1l2 9-4 1-2-7-8 1-1-4 7-2-1-9z",fill:"#BECFFE"}),(0,l.createElement)("path",{transform:"translate(269,248)",d:"m0 0h3v8h8v3h-8v7h-4v-7h-7v-4h8v-7z",fill:"#C2D2FE"}),(0,l.createElement)("path",{transform:"translate(21,78)",d:"m0 0c4.5556 0.55556 4.5556 0.55556 6 2 0.040808 1.9996 0.042544 4.0005 0 6-2.875 0.625-2.875 0.625-6 1-2-2-2-2-2.25-4.5 0.25-2.5 0.25-2.5 2.25-4.5z",fill:"#FBFCFF"}));(0,l.createElement)("svg",{xmlns:"http://www.w3.org/2000/svg",width:24,height:24,viewBox:"0 0 14.707 14.707"},(0,l.createElement)("rect",{x:"6.275",y:"0",width:"2.158",height:"14.707"})),(0,l.createElement)("svg",{xmlns:"http://www.w3.org/2000/svg",width:24,height:24,viewBox:"0 0 357 357"},(0,l.createElement)("path",{d:"M357,204H0v-51h357V204z"})),(0,e.registerBlockType)(t,{icon:j,edit:({attributes:e,setAttributes:t,clientId:s,isSelected:c})=>{const{selectedPostId:i}=e,[p,d]=(0,l.useState)(null),m=`bplDocumentLibrary-${s}`,u=(0,a.useSelect)(e=>e("core").getEntityRecords("postType","document_library",{per_page:-1,status:"publish"}),[]);return(0,l.useEffect)(()=>{i&&(d(null),fetch(`${window.bpldlData.ajax_url}?action=bplde_get_single&nonce=${window.bpldlData.nonce}&id=${i}`).then(e=>e.json()).then(e=>{e.success&&d({title:e.data.title,settings:e.data.settings})}))},[i]),(0,l.useEffect)(()=>o(),[c]),(0,l.createElement)(l.Fragment,null,(0,l.createElement)(S,{attributes:e,setAttributes:t}),(0,l.createElement)("div",{...(0,n.useBlockProps)(),id:m},(0,l.createElement)(r.SelectControl,{label:"Select a Post",value:i,options:[{label:"Select a post",value:""},...u?.map(e=>({label:e.title.rendered||"(No title)",value:e.id}))||[]],onChange:e=>t({selectedPostId:parseInt(e)})}),i?p?(0,l.createElement)(B,{postId:i,settingsData:p?.settings,id:m}):(0,l.createElement)("p",{style:{textAlign:"center",margin:"20px 0",color:"black"}},"Loading..."):(0,l.createElement)("p",null,"Please select a post to display the document library.")))}})})();