document.addEventListener('DOMContentLoaded', function () {
    let wpcf7Forms = document.querySelectorAll('.wpcf7-form');

    function addSurfPointDataToForm(name, value) {
        let surfpointInput = document.createElement('input');
        surfpointInput.hidden = 'hidden';
        surfpointInput.name = '_docoform_surfpoint[' + name + ']';
        surfpointInput.value = value;

        wpcf7Forms.forEach(wpcf7Form => wpcf7Form.appendChild(surfpointInput));
    }

    if (wpcf7Forms.length > 0) {
        // SURFPOINTが読み込まれるまで時間を空けてリトライする
        const limit = 10;
        let count = 0;
        const docodocoTagWaiter = setInterval(function () {
            if (typeof SURFPOINT !== 'undefined') {
                clearInterval(docodocoTagWaiter);
                [
                    'OrgName',
                    'OrgZipCode',
                    'OrgAddress',
                    'OrgTel',
                    'OrgFax',
                    'OrgIpoType',
                    'StockTickerNumber',
                    'OrgCapitalCode',
                    'OrgEmployeesCode',
                    'OrgGrossCode',
                    'OrgIndustrialCategoryL',
                    'OrgIndustrialCategoryM',
                    'OrgIndustrialCategoryS',
                    'OrgUrl',

                    'PrefJName',
                    'CityJName',
                ].forEach(function (key) {
                    if (SURFPOINT['get' + key] !== undefined) {
                        addSurfPointDataToForm(key, SURFPOINT['get' + key]());
                    }
                });

                if (SURFPOINT.HoujinBangou_3 !== undefined && SURFPOINT.HoujinBangou_3.getHoujinBangou !== undefined) {
                    addSurfPointDataToForm('HoujinBangou', SURFPOINT.HoujinBangou_3.getHoujinBangou());
                }
            }

            if (count++ >= limit) {
                // limit 回試行してもSURFPOINTが読み込めなかった場合は処理を終了する
                clearInterval(docodocoTagWaiter);
            }
        }, 500);
    }
});
