<?php

namespace DocodocoCf7Extension;

class ConstantsGenerated
{
    const orgIpoType = [
        '1' => ['code' => '1', 'contents' => '東証一部'],
        '2' => ['code' => '2', 'contents' => '東証二部'],
        '3' => ['code' => '3', 'contents' => '地方上場'],
        '4' => ['code' => '4', 'contents' => 'JASDAQ'],
        '5' => ['code' => '5', 'contents' => 'マザーズ'],
        '6' => ['code' => '6', 'contents' => 'ヘラクレス'],
        '9' => ['code' => '9', 'contents' => '非上場'],
        '11' => ['code' => '11', 'contents' => 'プライム'],
        '12' => ['code' => '12', 'contents' => 'スタンダード'],
        '13' => ['code' => '13', 'contents' => 'グロース'],
    ];

    const orgCapitalCode = [
        '1' => ['code' => '1', 'contents' => '1千万円未満'],
        '2' => ['code' => '2', 'contents' => '1千万円以上2千万円未満'],
        '3' => ['code' => '3', 'contents' => '2千万円以上5千万円未満'],
        '4' => ['code' => '4', 'contents' => '5千万円以上7千万円未満'],
        '5' => ['code' => '5', 'contents' => '7千万円以上1億円未満'],
        '6' => ['code' => '6', 'contents' => '1億円以上2億円未満'],
        '7' => ['code' => '7', 'contents' => '2億円以上'],
        '99' => ['code' => '99', 'contents' => '不明'],
    ];

    const orgEmployeesCode = [
        '1' => ['code' => '1', 'contents' => '1人以上5人未満'],
        '2' => ['code' => '2', 'contents' => '5人以上10人未満'],
        '3' => ['code' => '3', 'contents' => '10人以上30人未満'],
        '4' => ['code' => '4', 'contents' => '30人以上50人未満'],
        '5' => ['code' => '5', 'contents' => '50人以上100人未満'],
        '6' => ['code' => '6', 'contents' => '100人以上200人未満'],
        '7' => ['code' => '7', 'contents' => '200人以上300人未満'],
        '8' => ['code' => '8', 'contents' => '300人以上500人未満'],
        '9' => ['code' => '9', 'contents' => '500人以上'],
        '99' => ['code' => '99', 'contents' => '不明'],
    ];

    const orgGrossCode = [
        '1' => ['code' => '1', 'contents' => '1億未満'],
        '2' => ['code' => '2', 'contents' => '1億以上5億未満'],
        '3' => ['code' => '3', 'contents' => '5億以上10億未満'],
        '4' => ['code' => '4', 'contents' => '10億以上50億未満'],
        '5' => ['code' => '5', 'contents' => '50億以上100億未満'],
        '6' => ['code' => '6', 'contents' => '100億以上500億未満'],
        '7' => ['code' => '7', 'contents' => '500億以上1000億未満'],
        '8' => ['code' => '8', 'contents' => '1000億以上5000億未満'],
        '9' => ['code' => '9', 'contents' => '5000億以上'],
        '99' => ['code' => '99', 'contents' => '不明'],
    ];

    const orgCategoryL = [
        'A' => ['code' => 'A', 'contents' => '農業，林業'],
        'B' => ['code' => 'B', 'contents' => '漁業'],
        'C' => ['code' => 'C', 'contents' => '鉱業，採石業，砂利採取業'],
        'D' => ['code' => 'D', 'contents' => '建設業'],
        'E' => ['code' => 'E', 'contents' => '製造業'],
        'F' => ['code' => 'F', 'contents' => '電気・ガス・熱供給・水道業'],
        'G' => ['code' => 'G', 'contents' => '情報通信業'],
        'H' => ['code' => 'H', 'contents' => '運輸業，郵便業'],
        'I' => ['code' => 'I', 'contents' => '卸売業，小売業'],
        'J' => ['code' => 'J', 'contents' => '金融業，保険業'],
        'K' => ['code' => 'K', 'contents' => '不動産業，物品賃貸業'],
        'L' => ['code' => 'L', 'contents' => '学術研究，専門・技術サービス業'],
        'M' => ['code' => 'M', 'contents' => '宿泊業，飲食サービス業'],
        'N' => ['code' => 'N', 'contents' => '生活関連サービス業，娯楽業'],
        'O' => ['code' => 'O', 'contents' => '教育，学習支援業'],
        'P' => ['code' => 'P', 'contents' => '医療，福祉'],
        'Q' => ['code' => 'Q', 'contents' => '複合サービス事業'],
        'R' => ['code' => 'R', 'contents' => 'サービス業（他に分類されないもの）'],
        'S' => ['code' => 'S', 'contents' => '公務（他に分類されるものを除く）'],
        'T' => ['code' => 'T', 'contents' => '分類不能の産業'],
    ];

    const orgCategoryM = [
        '01' => ['code' => '01', 'contents' => '農業'],
        '02' => ['code' => '02', 'contents' => '林業'],
        '03' => ['code' => '03', 'contents' => '漁業（水産養殖業を除く）'],
        '04' => ['code' => '04', 'contents' => '水産養殖業'],
        '05' => ['code' => '05', 'contents' => '鉱業，採石業，砂利採取業'],
        '06' => ['code' => '06', 'contents' => '総合工事業'],
        '07' => ['code' => '07', 'contents' => '職別工事業(設備工事業を除く)'],
        '08' => ['code' => '08', 'contents' => '設備工事業'],
        '09' => ['code' => '09', 'contents' => '食料品製造業'],
        '10' => ['code' => '10', 'contents' => '飲料・たばこ・飼料製造業'],
        '11' => ['code' => '11', 'contents' => '繊維工業'],
        '12' => ['code' => '12', 'contents' => '木材・木製品製造業（家具を除く）'],
        '13' => ['code' => '13', 'contents' => '家具・装備品製造業'],
        '14' => ['code' => '14', 'contents' => 'パルプ・紙・紙加工品製造業'],
        '15' => ['code' => '15', 'contents' => '印刷・同関連業'],
        '16' => ['code' => '16', 'contents' => '化学工業'],
        '17' => ['code' => '17', 'contents' => '石油製品・石炭製品製造業'],
        '18' => ['code' => '18', 'contents' => 'プラスチック製品製造業（別掲を除く）'],
        '19' => ['code' => '19', 'contents' => 'ゴム製品製造業'],
        '20' => ['code' => '20', 'contents' => 'なめし革・同製品・毛皮製造業'],
        '21' => ['code' => '21', 'contents' => '窯業・土石製品製造業'],
        '22' => ['code' => '22', 'contents' => '鉄鋼業'],
        '23' => ['code' => '23', 'contents' => '非鉄金属製造業'],
        '24' => ['code' => '24', 'contents' => '金属製品製造業'],
        '25' => ['code' => '25', 'contents' => 'はん用機械器具製造業'],
        '26' => ['code' => '26', 'contents' => '生産用機械器具製造業'],
        '27' => ['code' => '27', 'contents' => '業務用機械器具製造業'],
        '28' => ['code' => '28', 'contents' => '電子部品・デバイス・電子回路製造業'],
        '29' => ['code' => '29', 'contents' => '電気機械器具製造業'],
        '30' => ['code' => '30', 'contents' => '情報通信機械器具製造業'],
        '31' => ['code' => '31', 'contents' => '輸送用機械器具製造業'],
        '32' => ['code' => '32', 'contents' => 'その他の製造業'],
        '33' => ['code' => '33', 'contents' => '電気業'],
        '34' => ['code' => '34', 'contents' => 'ガス業'],
        '35' => ['code' => '35', 'contents' => '熱供給業'],
        '36' => ['code' => '36', 'contents' => '水道業'],
        '37' => ['code' => '37', 'contents' => '通信業'],
        '38' => ['code' => '38', 'contents' => '放送業'],
        '39' => ['code' => '39', 'contents' => '情報サービス業'],
        '40' => ['code' => '40', 'contents' => 'インターネット附随サービス業'],
        '41' => ['code' => '41', 'contents' => '映像・音声・文字情報制作業'],
        '42' => ['code' => '42', 'contents' => '鉄道業'],
        '43' => ['code' => '43', 'contents' => '道路旅客運送業'],
        '44' => ['code' => '44', 'contents' => '道路貨物運送業'],
        '45' => ['code' => '45', 'contents' => '水運業'],
        '46' => ['code' => '46', 'contents' => '航空運輸業'],
        '47' => ['code' => '47', 'contents' => '倉庫業'],
        '48' => ['code' => '48', 'contents' => '運輸に附帯するサービス業'],
        '49' => ['code' => '49', 'contents' => '郵便業（信書便事業を含む）'],
        '50' => ['code' => '50', 'contents' => '各種商品卸売業'],
        '51' => ['code' => '51', 'contents' => '繊維・衣服等卸売業'],
        '52' => ['code' => '52', 'contents' => '飲食料品卸売業'],
        '53' => ['code' => '53', 'contents' => '建築材料，鉱物・金属材料等卸売業'],
        '54' => ['code' => '54', 'contents' => '機械器具卸売業'],
        '55' => ['code' => '55', 'contents' => 'その他の卸売業'],
        '56' => ['code' => '56', 'contents' => '各種商品小売業'],
        '57' => ['code' => '57', 'contents' => '織物・衣服・身の回り品小売業'],
        '58' => ['code' => '58', 'contents' => '飲食料品小売業'],
        '59' => ['code' => '59', 'contents' => '機械器具小売業'],
        '60' => ['code' => '60', 'contents' => 'その他の小売業'],
        '61' => ['code' => '61', 'contents' => '無店舗小売業'],
        '62' => ['code' => '62', 'contents' => '銀行業'],
        '63' => ['code' => '63', 'contents' => '協同組織金融業'],
        '64' => ['code' => '64', 'contents' => '貸金業，クレジットカード業等非預金信用機関'],
        '65' => ['code' => '65', 'contents' => '金融商品取引業，商品先物取引業'],
        '66' => ['code' => '66', 'contents' => '補助的金融業等'],
        '67' => ['code' => '67', 'contents' => '保険業（保険媒介代理業，保険サービス業を含む）'],
        '68' => ['code' => '68', 'contents' => '不動産取引業'],
        '69' => ['code' => '69', 'contents' => '不動産賃貸業・管理業'],
        '70' => ['code' => '70', 'contents' => '物品賃貸業'],
        '71' => ['code' => '71', 'contents' => '学術・開発研究機関'],
        '72' => ['code' => '72', 'contents' => '専門サービス業（他に分類されないもの）'],
        '73' => ['code' => '73', 'contents' => '広告業'],
        '74' => ['code' => '74', 'contents' => '技術サービス業（他に分類されないもの）'],
        '75' => ['code' => '75', 'contents' => '宿泊業'],
        '76' => ['code' => '76', 'contents' => '飲食店'],
        '77' => ['code' => '77', 'contents' => '持ち帰り・配達飲食サービス業'],
        '78' => ['code' => '78', 'contents' => '洗濯・理容・美容・浴場業'],
        '79' => ['code' => '79', 'contents' => 'その他の生活関連サービス業'],
        '80' => ['code' => '80', 'contents' => '娯楽業'],
        '81' => ['code' => '81', 'contents' => '学校教育'],
        '82' => ['code' => '82', 'contents' => 'その他の教育，学習支援業'],
        '83' => ['code' => '83', 'contents' => '医療業'],
        '84' => ['code' => '84', 'contents' => '保健衛生'],
        '85' => ['code' => '85', 'contents' => '社会保険・社会福祉・介護事業'],
        '86' => ['code' => '86', 'contents' => '郵便局'],
        '87' => ['code' => '87', 'contents' => '協同組合（他に分類されないもの）'],
        '88' => ['code' => '88', 'contents' => '廃棄物処理業'],
        '89' => ['code' => '89', 'contents' => '自動車整備業'],
        '90' => ['code' => '90', 'contents' => '機械等修理業（別掲を除く）'],
        '91' => ['code' => '91', 'contents' => '職業紹介・労働者派遣業'],
        '92' => ['code' => '92', 'contents' => 'その他の事業サービス業'],
        '93' => ['code' => '93', 'contents' => '政治・経済・文化団体'],
        '94' => ['code' => '94', 'contents' => '宗教'],
        '95' => ['code' => '95', 'contents' => 'その他のサービス業'],
        '96' => ['code' => '96', 'contents' => '外国公務'],
        '97' => ['code' => '97', 'contents' => '国家公務'],
        '98' => ['code' => '98', 'contents' => '地方公務'],
        '99' => ['code' => '99', 'contents' => '分類不能の産業'],
    ];

    const orgCategoryS = [
        '010' => ['code' => '010', 'contents' => '管理，補助的経済活動を行う事業所（01農業）'],
        '011' => ['code' => '011', 'contents' => '耕種農業'],
        '012' => ['code' => '012', 'contents' => '畜産農業'],
        '013' => ['code' => '013', 'contents' => '農業サービス業（園芸サービス業を除く）'],
        '014' => ['code' => '014', 'contents' => '園芸サービス業'],
        '020' => ['code' => '020', 'contents' => '管理，補助的経済活動を行う事業所（02林業）'],
        '021' => ['code' => '021', 'contents' => '育林業'],
        '022' => ['code' => '022', 'contents' => '素材生産業'],
        '023' => ['code' => '023', 'contents' => '特用林産物生産業（きのこ類の栽培を除く）'],
        '024' => ['code' => '024', 'contents' => '林業サービス業'],
        '029' => ['code' => '029', 'contents' => 'その他の林業'],
        '030' => ['code' => '030', 'contents' => '管理，補助的経済活動を行う事業所（03漁業）'],
        '031' => ['code' => '031', 'contents' => '海面漁業'],
        '032' => ['code' => '032', 'contents' => '内水面漁業'],
        '040' => ['code' => '040', 'contents' => '管理，補助的経済活動を行う事業所（04水産養殖業）'],
        '041' => ['code' => '041', 'contents' => '海面養殖業'],
        '042' => ['code' => '042', 'contents' => '内水面養殖業'],
        '050' => ['code' => '050', 'contents' => '管理，補助的経済活動を行う事業所（05鉱業，採石業，砂利採取業）'],
        '051' => ['code' => '051', 'contents' => '金属鉱業'],
        '052' => ['code' => '052', 'contents' => '石炭・亜炭鉱業'],
        '053' => ['code' => '053', 'contents' => '原油・天然ガス鉱業'],
        '054' => ['code' => '054', 'contents' => '採石業，砂・砂利・玉石採取業'],
        '055' => ['code' => '055', 'contents' => '窯業原料用鉱物鉱業（耐火物・陶磁器・ガラス・セメント原料用に限る）'],
        '059' => ['code' => '059', 'contents' => 'その他の鉱業'],
        '060' => ['code' => '060', 'contents' => '管理，補助的経済活動を行う事業所（06総合工事業）'],
        '061' => ['code' => '061', 'contents' => '一般土木建築工事業'],
        '062' => ['code' => '062', 'contents' => '土木工事業（舗装工事業を除く）'],
        '063' => ['code' => '063', 'contents' => '舗装工事業'],
        '064' => ['code' => '064', 'contents' => '建築工事業(木造建築工事業を除く)'],
        '065' => ['code' => '065', 'contents' => '木造建築工事業'],
        '066' => ['code' => '066', 'contents' => '建築リフォーム工事業'],
        '070' => ['code' => '070', 'contents' => '管理，補助的経済活動を行う事業所（07職別工事業）'],
        '071' => ['code' => '071', 'contents' => '大工工事業'],
        '072' => ['code' => '072', 'contents' => 'とび・土工・コンクリート工事業'],
        '073' => ['code' => '073', 'contents' => '鉄骨・鉄筋工事業'],
        '074' => ['code' => '074', 'contents' => '石工・れんが・タイル・ブロック工事業'],
        '075' => ['code' => '075', 'contents' => '左官工事業'],
        '076' => ['code' => '076', 'contents' => '板金・金物工事業'],
        '077' => ['code' => '077', 'contents' => '塗装工事業'],
        '078' => ['code' => '078', 'contents' => '床・内装工事業'],
        '079' => ['code' => '079', 'contents' => 'その他の職別工事業'],
        '080' => ['code' => '080', 'contents' => '管理，補助的経済活動を行う事業所（08設備工事業）'],
        '081' => ['code' => '081', 'contents' => '電気工事業'],
        '082' => ['code' => '082', 'contents' => '電気通信・信号装置工事業'],
        '083' => ['code' => '083', 'contents' => '管工事業（さく井工事業を除く）'],
        '084' => ['code' => '084', 'contents' => '機械器具設置工事業'],
        '089' => ['code' => '089', 'contents' => 'その他の設備工事業'],
        '090' => ['code' => '090', 'contents' => '管理，補助的経済活動を行う事業所（09食料品製造業）'],
        '091' => ['code' => '091', 'contents' => '畜産食料品製造業'],
        '092' => ['code' => '092', 'contents' => '水産食料品製造業'],
        '093' => ['code' => '093', 'contents' => '野菜缶詰・果実缶詰・農産保存食料品製造業'],
        '094' => ['code' => '094', 'contents' => '調味料製造業'],
        '095' => ['code' => '095', 'contents' => '糖類製造業'],
        '096' => ['code' => '096', 'contents' => '精穀・製粉業'],
        '097' => ['code' => '097', 'contents' => 'パン・菓子製造業'],
        '098' => ['code' => '098', 'contents' => '動植物油脂製造業'],
        '099' => ['code' => '099', 'contents' => 'その他の食料品製造業'],
        '100' => ['code' => '100', 'contents' => '管理，補助的経済活動を行う事業所（10飲料・たばこ・飼料製造業）'],
        '101' => ['code' => '101', 'contents' => '清涼飲料製造業'],
        '102' => ['code' => '102', 'contents' => '酒類製造業'],
        '103' => ['code' => '103', 'contents' => '茶・コーヒー製造業（清涼飲料を除く）'],
        '104' => ['code' => '104', 'contents' => '製氷業'],
        '105' => ['code' => '105', 'contents' => 'たばこ製造業'],
        '106' => ['code' => '106', 'contents' => '飼料・有機質肥料製造業'],
        '110' => ['code' => '110', 'contents' => '管理，補助的経済活動を行う事業所（11繊維工業）'],
        '111' => ['code' => '111', 'contents' => '製糸業，紡績業，化学繊維・ねん糸等製造業'],
        '112' => ['code' => '112', 'contents' => '織物業'],
        '113' => ['code' => '113', 'contents' => 'ニット生地製造業'],
        '114' => ['code' => '114', 'contents' => '染色整理業'],
        '115' => ['code' => '115', 'contents' => '綱・網・レース・繊維粗製品製造業'],
        '116' => ['code' => '116', 'contents' => '外衣・シャツ製造業（和式を除く）'],
        '117' => ['code' => '117', 'contents' => '下着類製造業'],
        '118' => ['code' => '118', 'contents' => '和装製品・その他の衣服・繊維製身の回り品製造業'],
        '119' => ['code' => '119', 'contents' => 'その他の繊維製品製造業'],
        '120' => ['code' => '120', 'contents' => '管理，補助的経済活動を行う事業所（12木材・木製品製造業）'],
        '121' => ['code' => '121', 'contents' => '製材業，木製品製造業'],
        '122' => ['code' => '122', 'contents' => '造作材・合板・建築用組立材料製造業'],
        '123' => ['code' => '123', 'contents' => '木製容器製造業（竹，とうを含む）'],
        '129' => ['code' => '129', 'contents' => 'その他の木製品製造業(竹，とうを含む)'],
        '130' => ['code' => '130', 'contents' => '管理，補助的経済活動を行う事業所（13家具・装備品製造業）'],
        '131' => ['code' => '131', 'contents' => '家具製造業'],
        '132' => ['code' => '132', 'contents' => '宗教用具製造業'],
        '133' => ['code' => '133', 'contents' => '建具製造業'],
        '139' => ['code' => '139', 'contents' => 'その他の家具・装備品製造業'],
        '140' => ['code' => '140', 'contents' => '管理，補助的経済活動を行う事業所（14パルプ・紙・紙加工品製造業）'],
        '141' => ['code' => '141', 'contents' => 'パルプ製造業'],
        '142' => ['code' => '142', 'contents' => '紙製造業'],
        '143' => ['code' => '143', 'contents' => '加工紙製造業'],
        '144' => ['code' => '144', 'contents' => '紙製品製造業'],
        '145' => ['code' => '145', 'contents' => '紙製容器製造業'],
        '149' => ['code' => '149', 'contents' => 'その他のパルプ・紙・紙加工品製造業'],
        '150' => ['code' => '150', 'contents' => '管理，補助的経済活動を行う事業所（15印刷・同関連業）'],
        '151' => ['code' => '151', 'contents' => '印刷業'],
        '152' => ['code' => '152', 'contents' => '製版業'],
        '153' => ['code' => '153', 'contents' => '製本業，印刷物加工業'],
        '159' => ['code' => '159', 'contents' => '印刷関連サービス業'],
        '160' => ['code' => '160', 'contents' => '管理，補助的経済活動を行う事業所（16化学工業）'],
        '161' => ['code' => '161', 'contents' => '化学肥料製造業'],
        '162' => ['code' => '162', 'contents' => '無機化学工業製品製造業'],
        '163' => ['code' => '163', 'contents' => '有機化学工業製品製造業'],
        '164' => ['code' => '164', 'contents' => '油脂加工製品・石けん・合成洗剤・界面活性剤・塗料製造業'],
        '165' => ['code' => '165', 'contents' => '医薬品製造業'],
        '166' => ['code' => '166', 'contents' => '化粧品・歯磨・その他の化粧用調整品製造業'],
        '169' => ['code' => '169', 'contents' => 'その他の化学工業'],
        '170' => ['code' => '170', 'contents' => '管理，補助的経済活動を行う事業所（17石油製品・石炭製品製造業）'],
        '171' => ['code' => '171', 'contents' => '石油精製業'],
        '172' => ['code' => '172', 'contents' => '潤滑油・グリース製造業（石油精製業によらないもの）'],
        '173' => ['code' => '173', 'contents' => 'コークス製造業'],
        '174' => ['code' => '174', 'contents' => '舗装材料製造業'],
        '179' => ['code' => '179', 'contents' => 'その他の石油製品・石炭製品製造業'],
        '180' => ['code' => '180', 'contents' => '管理，補助的経済活動を行う事業所（18プラスチック製品製造業）'],
        '181' => ['code' => '181', 'contents' => 'プラスチック板・棒・管・継手・異形押出製品製造業'],
        '182' => ['code' => '182', 'contents' => 'プラスチックフィルム・シート・床材・合成皮革製造業'],
        '183' => ['code' => '183', 'contents' => '工業用プラスチック製品製造業'],
        '184' => ['code' => '184', 'contents' => '発泡・強化プラスチック製品製造業'],
        '185' => ['code' => '185', 'contents' => 'プラスチック成形材料製造業（廃プラスチックを含む）'],
        '189' => ['code' => '189', 'contents' => 'その他のプラスチック製品製造業'],
        '190' => ['code' => '190', 'contents' => '管理，補助的経済活動を行う事業所（19ゴム製品製造業）'],
        '191' => ['code' => '191', 'contents' => 'タイヤ・チューブ製造業'],
        '192' => ['code' => '192', 'contents' => 'ゴム製・プラスチック製履物・同附属品製造業'],
        '193' => ['code' => '193', 'contents' => 'ゴムベルト・ゴムホース・工業用ゴム製品製造業'],
        '199' => ['code' => '199', 'contents' => 'その他のゴム製品製造業'],
        '200' => ['code' => '200', 'contents' => '管理，補助的経済活動を行う事業所（20なめし革・同製品・毛皮製造業）'],
        '201' => ['code' => '201', 'contents' => 'なめし革製造業'],
        '202' => ['code' => '202', 'contents' => '工業用革製品製造業（手袋を除く）'],
        '203' => ['code' => '203', 'contents' => '革製履物用材料・同附属品製造業'],
        '204' => ['code' => '204', 'contents' => '革製履物製造業'],
        '205' => ['code' => '205', 'contents' => '革製手袋製造業'],
        '206' => ['code' => '206', 'contents' => 'かばん製造業'],
        '207' => ['code' => '207', 'contents' => '袋物製造業'],
        '208' => ['code' => '208', 'contents' => '毛皮製造業'],
        '209' => ['code' => '209', 'contents' => 'その他のなめし革製品製造業'],
        '210' => ['code' => '210', 'contents' => '管理，補助的経済活動を行う事業所（21窯業・土石製品製造業）'],
        '211' => ['code' => '211', 'contents' => 'ガラス・同製品製造業'],
        '212' => ['code' => '212', 'contents' => 'セメント・同製品製造業'],
        '213' => ['code' => '213', 'contents' => '建設用粘土製品製造業（陶磁器製を除く)'],
        '214' => ['code' => '214', 'contents' => '陶磁器・同関連製品製造業'],
        '215' => ['code' => '215', 'contents' => '耐火物製造業'],
        '216' => ['code' => '216', 'contents' => '炭素・黒鉛製品製造業'],
        '217' => ['code' => '217', 'contents' => '研磨材・同製品製造業'],
        '218' => ['code' => '218', 'contents' => '骨材・石工品等製造業'],
        '219' => ['code' => '219', 'contents' => 'その他の窯業・土石製品製造業'],
        '220' => ['code' => '220', 'contents' => '管理，補助的経済活動を行う事業所（22鉄鋼業）'],
        '221' => ['code' => '221', 'contents' => '製鉄業'],
        '222' => ['code' => '222', 'contents' => '製鋼・製鋼圧延業'],
        '223' => ['code' => '223', 'contents' => '製鋼を行わない鋼材製造業（表面処理鋼材を除く）'],
        '224' => ['code' => '224', 'contents' => '表面処理鋼材製造業'],
        '225' => ['code' => '225', 'contents' => '鉄素形材製造業'],
        '229' => ['code' => '229', 'contents' => 'その他の鉄鋼業'],
        '230' => ['code' => '230', 'contents' => '管理，補助的経済活動を行う事業所（23非鉄金属製造業）'],
        '231' => ['code' => '231', 'contents' => '非鉄金属第１次製錬・精製業'],
        '232' => ['code' => '232', 'contents' => '非鉄金属第２次製錬・精製業（非鉄金属合金製造業を含む）'],
        '233' => ['code' => '233', 'contents' => '非鉄金属・同合金圧延業（抽伸，押出しを含む）'],
        '234' => ['code' => '234', 'contents' => '電線・ケーブル製造業'],
        '235' => ['code' => '235', 'contents' => '非鉄金属素形材製造業'],
        '239' => ['code' => '239', 'contents' => 'その他の非鉄金属製造業'],
        '240' => ['code' => '240', 'contents' => '管理，補助的経済活動を行う事業所（24金属製品製造業）'],
        '241' => ['code' => '241', 'contents' => 'ブリキ缶・その他のめっき板等製品製造業'],
        '242' => ['code' => '242', 'contents' => '洋食器・刃物・手道具・金物類製造業'],
        '243' => ['code' => '243', 'contents' => '暖房装置・配管工事用附属品製造業'],
        '244' => ['code' => '244', 'contents' => '建設用・建築用金属製品製造業（製缶板金業を含む)'],
        '245' => ['code' => '245', 'contents' => '金属素形材製品製造業'],
        '246' => ['code' => '246', 'contents' => '金属被覆・彫刻業，熱処理業（ほうろう鉄器を除く）'],
        '247' => ['code' => '247', 'contents' => '金属線製品製造業（ねじ類を除く)'],
        '248' => ['code' => '248', 'contents' => 'ボルト・ナット・リベット・小ねじ・木ねじ等製造業'],
        '249' => ['code' => '249', 'contents' => 'その他の金属製品製造業'],
        '250' => ['code' => '250', 'contents' => '管理，補助的経済活動を行う事業所（25はん用機械器具製造業）'],
        '251' => ['code' => '251', 'contents' => 'ボイラ・原動機製造業'],
        '252' => ['code' => '252', 'contents' => 'ポンプ・圧縮機器製造業'],
        '253' => ['code' => '253', 'contents' => '一般産業用機械・装置製造業'],
        '259' => ['code' => '259', 'contents' => 'その他のはん用機械・同部分品製造業'],
        '260' => ['code' => '260', 'contents' => '管理，補助的経済活動を行う事業所（26生産用機械器具製造業）'],
        '261' => ['code' => '261', 'contents' => '農業用機械製造業（農業用器具を除く）'],
        '262' => ['code' => '262', 'contents' => '建設機械・鉱山機械製造業'],
        '263' => ['code' => '263', 'contents' => '繊維機械製造業'],
        '264' => ['code' => '264', 'contents' => '生活関連産業用機械製造業'],
        '265' => ['code' => '265', 'contents' => '基礎素材産業用機械製造業'],
        '266' => ['code' => '266', 'contents' => '金属加工機械製造業'],
        '267' => ['code' => '267', 'contents' => '半導体・フラットパネルディスプレイ製造装置製造業'],
        '269' => ['code' => '269', 'contents' => 'その他の生産用機械・同部分品製造業'],
        '270' => ['code' => '270', 'contents' => '管理，補助的経済活動を行う事業所（27業務用機械器具製造業）'],
        '271' => ['code' => '271', 'contents' => '事務用機械器具製造業'],
        '272' => ['code' => '272', 'contents' => 'サービス用・娯楽用機械器具製造業'],
        '273' => ['code' => '273', 'contents' => '計量器・測定器・分析機器・試験機・測量機械器具・理化学機械器具製造業'],
        '274' => ['code' => '274', 'contents' => '医療用機械器具・医療用品製造業'],
        '275' => ['code' => '275', 'contents' => '光学機械器具・レンズ製造業'],
        '276' => ['code' => '276', 'contents' => '武器製造業'],
        '280' => ['code' => '280', 'contents' => '管理，補助的経済活動を行う事業所（28電子部品・デバイス・電子回路製造業）'],
        '281' => ['code' => '281', 'contents' => '電子デバイス製造業'],
        '282' => ['code' => '282', 'contents' => '電子部品製造業'],
        '283' => ['code' => '283', 'contents' => '記録メディア製造業'],
        '284' => ['code' => '284', 'contents' => '電子回路製造業'],
        '285' => ['code' => '285', 'contents' => 'ユニット部品製造業'],
        '289' => ['code' => '289', 'contents' => 'その他の電子部品・デバイス・電子回路製造業'],
        '290' => ['code' => '290', 'contents' => '管理，補助的経済活動を行う事業所（29電気機械器具製造業）'],
        '291' => ['code' => '291', 'contents' => '発電用・送電用・配電用電気機械器具製造業'],
        '292' => ['code' => '292', 'contents' => '産業用電気機械器具製造業'],
        '293' => ['code' => '293', 'contents' => '民生用電気機械器具製造業'],
        '294' => ['code' => '294', 'contents' => '電球・電気照明器具製造業'],
        '295' => ['code' => '295', 'contents' => '電池製造業'],
        '296' => ['code' => '296', 'contents' => '電子応用装置製造業'],
        '297' => ['code' => '297', 'contents' => '電気計測器製造業'],
        '299' => ['code' => '299', 'contents' => 'その他の電気機械器具製造業'],
        '300' => ['code' => '300', 'contents' => '管理，補助的経済活動を行う事業所（30情報通信機械器具製造業）'],
        '301' => ['code' => '301', 'contents' => '通信機械器具・同関連機械器具製造業'],
        '302' => ['code' => '302', 'contents' => '映像・音響機械器具製造業'],
        '303' => ['code' => '303', 'contents' => '電子計算機・同附属装置製造業'],
        '310' => ['code' => '310', 'contents' => '管理，補助的経済活動を行う事業所（31輸送用機械器具製造業）'],
        '311' => ['code' => '311', 'contents' => '自動車・同附属品製造業'],
        '312' => ['code' => '312', 'contents' => '鉄道車両・同部分品製造業'],
        '313' => ['code' => '313', 'contents' => '船舶製造・修理業，舶用機関製造業'],
        '314' => ['code' => '314', 'contents' => '航空機・同附属品製造業'],
        '315' => ['code' => '315', 'contents' => '産業用運搬車両・同部分品・附属品製造業'],
        '319' => ['code' => '319', 'contents' => 'その他の輸送用機械器具製造業'],
        '320' => ['code' => '320', 'contents' => '管理，補助的経済活動を行う事業所（32その他の製造業）'],
        '321' => ['code' => '321', 'contents' => '貴金属・宝石製品製造業'],
        '322' => ['code' => '322', 'contents' => '装身具・装飾品・ボタン・同関連品製造業（貴金属・宝石製を除く）'],
        '323' => ['code' => '323', 'contents' => '時計・同部分品製造業'],
        '324' => ['code' => '324', 'contents' => '楽器製造業'],
        '325' => ['code' => '325', 'contents' => 'がん具・運動用具製造業'],
        '326' => ['code' => '326', 'contents' => 'ペン・鉛筆・絵画用品・その他の事務用品製造業'],
        '327' => ['code' => '327', 'contents' => '漆器製造業'],
        '328' => ['code' => '328', 'contents' => '畳等生活雑貨製品製造業'],
        '329' => ['code' => '329', 'contents' => '他に分類されない製造業'],
        '330' => ['code' => '330', 'contents' => '管理，補助的経済活動を行う事業所（33電気業）'],
        '331' => ['code' => '331', 'contents' => '電気業'],
        '340' => ['code' => '340', 'contents' => '管理，補助的経済活動を行う事業所（34ガス業）'],
        '341' => ['code' => '341', 'contents' => 'ガス業'],
        '350' => ['code' => '350', 'contents' => '管理，補助的経済活動を行う事業所（35熱供給業）'],
        '351' => ['code' => '351', 'contents' => '熱供給業'],
        '360' => ['code' => '360', 'contents' => '管理，補助的経済活動を行う事業所（36水道業）'],
        '361' => ['code' => '361', 'contents' => '上水道業'],
        '362' => ['code' => '362', 'contents' => '工業用水道業'],
        '363' => ['code' => '363', 'contents' => '下水道業'],
        '370' => ['code' => '370', 'contents' => '管理，補助的経済活動を行う事業所（37通信業）'],
        '371' => ['code' => '371', 'contents' => '固定電気通信業'],
        '372' => ['code' => '372', 'contents' => '移動電気通信業'],
        '373' => ['code' => '373', 'contents' => '電気通信に附帯するサービス業'],
        '380' => ['code' => '380', 'contents' => '管理，補助的経済活動を行う事業所（38放送業）'],
        '381' => ['code' => '381', 'contents' => '公共放送業（有線放送業を除く）'],
        '382' => ['code' => '382', 'contents' => '民間放送業（有線放送業を除く）'],
        '383' => ['code' => '383', 'contents' => '有線放送業'],
        '390' => ['code' => '390', 'contents' => '管理，補助的経済活動を行う事業所（39情報サービス業）'],
        '391' => ['code' => '391', 'contents' => 'ソフトウェア業'],
        '392' => ['code' => '392', 'contents' => '情報処理・提供サービス業'],
        '400' => ['code' => '400', 'contents' => '管理，補助的経済活動を行う事業所（40インターネット附随サービス業）'],
        '401' => ['code' => '401', 'contents' => 'インターネット附随サービス業'],
        '410' => ['code' => '410', 'contents' => '管理，補助的経済活動を行う事業所（41映像・音声・文字情報制作業）'],
        '411' => ['code' => '411', 'contents' => '映像情報制作・配給業'],
        '412' => ['code' => '412', 'contents' => '音声情報制作業'],
        '413' => ['code' => '413', 'contents' => '新聞業'],
        '414' => ['code' => '414', 'contents' => '出版業'],
        '415' => ['code' => '415', 'contents' => '広告制作業'],
        '416' => ['code' => '416', 'contents' => '映像・音声・文字情報制作に附帯するサービス業'],
        '420' => ['code' => '420', 'contents' => '管理，補助的経済活動を行う事業所（42鉄道業）'],
        '421' => ['code' => '421', 'contents' => '鉄道業'],
        '430' => ['code' => '430', 'contents' => '管理，補助的経済活動を行う事業所（43道路旅客運送業）'],
        '431' => ['code' => '431', 'contents' => '一般乗合旅客自動車運送業'],
        '432' => ['code' => '432', 'contents' => '一般乗用旅客自動車運送業'],
        '433' => ['code' => '433', 'contents' => '一般貸切旅客自動車運送業'],
        '439' => ['code' => '439', 'contents' => 'その他の道路旅客運送業'],
        '440' => ['code' => '440', 'contents' => '管理，補助的経済活動を行う事業所（44道路貨物運送業）'],
        '441' => ['code' => '441', 'contents' => '一般貨物自動車運送業'],
        '442' => ['code' => '442', 'contents' => '特定貨物自動車運送業'],
        '443' => ['code' => '443', 'contents' => '貨物軽自動車運送業'],
        '444' => ['code' => '444', 'contents' => '集配利用運送業'],
        '449' => ['code' => '449', 'contents' => 'その他の道路貨物運送業'],
        '450' => ['code' => '450', 'contents' => '管理，補助的経済活動を行う事業所（45水運業）'],
        '451' => ['code' => '451', 'contents' => '外航海運業'],
        '452' => ['code' => '452', 'contents' => '沿海海運業'],
        '453' => ['code' => '453', 'contents' => '内陸水運業'],
        '454' => ['code' => '454', 'contents' => '船舶貸渡業'],
        '460' => ['code' => '460', 'contents' => '管理，補助的経済活動を行う事業所（46航空運輸業）'],
        '461' => ['code' => '461', 'contents' => '航空運送業'],
        '462' => ['code' => '462', 'contents' => '航空機使用業（航空運送業を除く）'],
        '470' => ['code' => '470', 'contents' => '管理，補助的経済活動を行う事業所（47倉庫業）'],
        '471' => ['code' => '471', 'contents' => '倉庫業（冷蔵倉庫業を除く）'],
        '472' => ['code' => '472', 'contents' => '冷蔵倉庫業'],
        '480' => ['code' => '480', 'contents' => '管理，補助的経済活動を行う事業所（48運輸に附帯するサービス業）'],
        '481' => ['code' => '481', 'contents' => '港湾運送業'],
        '482' => ['code' => '482', 'contents' => '貨物運送取扱業（集配利用運送業を除く）'],
        '483' => ['code' => '483', 'contents' => '運送代理店'],
        '484' => ['code' => '484', 'contents' => 'こん包業'],
        '485' => ['code' => '485', 'contents' => '運輸施設提供業'],
        '489' => ['code' => '489', 'contents' => 'その他の運輸に附帯するサービス業'],
        '490' => ['code' => '490', 'contents' => '管理，補助的経済活動を行う事業所（49郵便業）'],
        '491' => ['code' => '491', 'contents' => '郵便業（信書便事業を含む）'],
        '500' => ['code' => '500', 'contents' => '管理，補助的経済活動を行う事業所（50各種商品卸売業）'],
        '501' => ['code' => '501', 'contents' => '各種商品卸売業'],
        '510' => ['code' => '510', 'contents' => '管理，補助的経済活動を行う事業所（51繊維・衣服等卸売業）'],
        '511' => ['code' => '511', 'contents' => '繊維品卸売業（衣服，身の回り品を除く）'],
        '512' => ['code' => '512', 'contents' => '衣服卸売業'],
        '513' => ['code' => '513', 'contents' => '身の回り品卸売業'],
        '520' => ['code' => '520', 'contents' => '管理，補助的経済活動を行う事業所（52飲食料品卸売業）'],
        '521' => ['code' => '521', 'contents' => '農畜産物・水産物卸売業'],
        '522' => ['code' => '522', 'contents' => '食料・飲料卸売業'],
        '530' => ['code' => '530', 'contents' => '管理，補助的経済活動を行う事業所（53建築材料，鉱物・金属材料等卸売業）'],
        '531' => ['code' => '531', 'contents' => '建築材料卸売業'],
        '532' => ['code' => '532', 'contents' => '化学製品卸売業'],
        '533' => ['code' => '533', 'contents' => '石油・鉱物卸売業'],
        '534' => ['code' => '534', 'contents' => '鉄鋼製品卸売業'],
        '535' => ['code' => '535', 'contents' => '非鉄金属卸売業'],
        '536' => ['code' => '536', 'contents' => '再生資源卸売業'],
        '540' => ['code' => '540', 'contents' => '管理，補助的経済活動を行う事業所（54機械器具卸売業）'],
        '541' => ['code' => '541', 'contents' => '産業機械器具卸売業'],
        '542' => ['code' => '542', 'contents' => '自動車卸売業'],
        '543' => ['code' => '543', 'contents' => '電気機械器具卸売業'],
        '549' => ['code' => '549', 'contents' => 'その他の機械器具卸売業'],
        '550' => ['code' => '550', 'contents' => '管理，補助的経済活動を行う事業所（55その他の卸売業）'],
        '551' => ['code' => '551', 'contents' => '家具・建具・じゅう器等卸売業'],
        '552' => ['code' => '552', 'contents' => '医薬品・化粧品等卸売業'],
        '553' => ['code' => '553', 'contents' => '紙・紙製品卸売業'],
        '559' => ['code' => '559', 'contents' => '他に分類されない卸売業'],
        '560' => ['code' => '560', 'contents' => '管理，補助的経済活動を行う事業所（56各種商品小売業）'],
        '561' => ['code' => '561', 'contents' => '百貨店，総合スーパー'],
        '569' => ['code' => '569', 'contents' => 'その他の各種商品小売業（従業者が常時50人未満のもの）'],
        '570' => ['code' => '570', 'contents' => '管理，補助的経済活動を行う事業所（57織物・衣服・身の回り品小売業）'],
        '571' => ['code' => '571', 'contents' => '呉服・服地・寝具小売業'],
        '572' => ['code' => '572', 'contents' => '男子服小売業'],
        '573' => ['code' => '573', 'contents' => '婦人・子供服小売業'],
        '574' => ['code' => '574', 'contents' => '靴・履物小売業'],
        '579' => ['code' => '579', 'contents' => 'その他の織物・衣服・身の回り品小売業'],
        '580' => ['code' => '580', 'contents' => '管理，補助的経済活動を行う事業所（58飲食料品小売業）'],
        '581' => ['code' => '581', 'contents' => '各種食料品小売業'],
        '582' => ['code' => '582', 'contents' => '野菜・果実小売業'],
        '583' => ['code' => '583', 'contents' => '食肉小売業'],
        '584' => ['code' => '584', 'contents' => '鮮魚小売業'],
        '585' => ['code' => '585', 'contents' => '酒小売業'],
        '586' => ['code' => '586', 'contents' => '菓子・パン小売業'],
        '589' => ['code' => '589', 'contents' => 'その他の飲食料品小売業'],
        '590' => ['code' => '590', 'contents' => '管理，補助的経済活動を行う事業所（59機械器具小売業）'],
        '591' => ['code' => '591', 'contents' => '自動車小売業'],
        '592' => ['code' => '592', 'contents' => '自転車小売業'],
        '593' => ['code' => '593', 'contents' => '機械器具小売業（自動車，自転車を除く）'],
        '600' => ['code' => '600', 'contents' => '管理，補助的経済活動を行う事業所（60その他の小売業）'],
        '601' => ['code' => '601', 'contents' => '家具・建具・畳小売業'],
        '602' => ['code' => '602', 'contents' => 'じゅう器小売業'],
        '603' => ['code' => '603', 'contents' => '医薬品・化粧品小売業'],
        '604' => ['code' => '604', 'contents' => '農耕用品小売業'],
        '605' => ['code' => '605', 'contents' => '燃料小売業'],
        '606' => ['code' => '606', 'contents' => '書籍・文房具小売業'],
        '607' => ['code' => '607', 'contents' => 'スポーツ用品・がん具・娯楽用品・楽器小売業'],
        '608' => ['code' => '608', 'contents' => '写真機・時計・眼鏡小売業'],
        '609' => ['code' => '609', 'contents' => '他に分類されない小売業'],
        '610' => ['code' => '610', 'contents' => '管理，補助的経済活動を行う事業所（61無店舗小売業）'],
        '611' => ['code' => '611', 'contents' => '通信販売・訪問販売小売業'],
        '612' => ['code' => '612', 'contents' => '自動販売機による小売業'],
        '619' => ['code' => '619', 'contents' => 'その他の無店舗小売業'],
        '620' => ['code' => '620', 'contents' => '管理，補助的経済活動を行う事業所（62銀行業）'],
        '621' => ['code' => '621', 'contents' => '中央銀行'],
        '622' => ['code' => '622', 'contents' => '銀行（中央銀行を除く）'],
        '630' => ['code' => '630', 'contents' => '管理，補助的経済活動を行う事業所（63協同組織金融業）'],
        '631' => ['code' => '631', 'contents' => '中小企業等金融業'],
        '632' => ['code' => '632', 'contents' => '農林水産金融業'],
        '640' => ['code' => '640', 'contents' => '管理，補助的経済活動を行う事業所（64貸金業，クレジットカード業等非預金信用機関）'],
        '641' => ['code' => '641', 'contents' => '貸金業'],
        '642' => ['code' => '642', 'contents' => '質屋'],
        '643' => ['code' => '643', 'contents' => 'クレジットカード業，割賦金融業'],
        '649' => ['code' => '649', 'contents' => 'その他の非預金信用機関'],
        '650' => ['code' => '650', 'contents' => '管理，補助的経済活動を行う事業所（65金融商品取引業，商品先物取引業）'],
        '651' => ['code' => '651', 'contents' => '金融商品取引業'],
        '652' => ['code' => '652', 'contents' => '商品先物取引業，商品投資業'],
        '660' => ['code' => '660', 'contents' => '管理，補助的経済活動を行う事業所（66補助的金融業等）'],
        '661' => ['code' => '661', 'contents' => '補助的金融業，金融附帯業'],
        '662' => ['code' => '662', 'contents' => '信託業'],
        '663' => ['code' => '663', 'contents' => '金融代理業'],
        '670' => ['code' => '670', 'contents' => '管理，補助的経済活動を行う事業所（67保険業）'],
        '671' => ['code' => '671', 'contents' => '生命保険業'],
        '672' => ['code' => '672', 'contents' => '損害保険業'],
        '673' => ['code' => '673', 'contents' => '共済事業・少額短期保険業'],
        '674' => ['code' => '674', 'contents' => '保険媒介代理業'],
        '675' => ['code' => '675', 'contents' => '保険サービス業'],
        '680' => ['code' => '680', 'contents' => '管理，補助的経済活動を行う事業所（68不動産取引業）'],
        '681' => ['code' => '681', 'contents' => '建物売買業，土地売買業'],
        '682' => ['code' => '682', 'contents' => '不動産代理業・仲介業'],
        '690' => ['code' => '690', 'contents' => '管理，補助的経済活動を行う事業所（69不動産賃貸業・管理業）'],
        '691' => ['code' => '691', 'contents' => '不動産賃貸業（貸家業，貸間業を除く）'],
        '692' => ['code' => '692', 'contents' => '貸家業，貸間業'],
        '693' => ['code' => '693', 'contents' => '駐車場業'],
        '694' => ['code' => '694', 'contents' => '不動産管理業'],
        '700' => ['code' => '700', 'contents' => '管理，補助的経済活動を行う事業所（70物品賃貸業）'],
        '701' => ['code' => '701', 'contents' => '各種物品賃貸業'],
        '702' => ['code' => '702', 'contents' => '産業用機械器具賃貸業'],
        '703' => ['code' => '703', 'contents' => '事務用機械器具賃貸業'],
        '704' => ['code' => '704', 'contents' => '自動車賃貸業'],
        '705' => ['code' => '705', 'contents' => 'スポーツ・娯楽用品賃貸業'],
        '709' => ['code' => '709', 'contents' => 'その他の物品賃貸業'],
        '710' => ['code' => '710', 'contents' => '管理，補助的経済活動を行う事業所（71学術・開発研究機関）'],
        '711' => ['code' => '711', 'contents' => '自然科学研究所'],
        '712' => ['code' => '712', 'contents' => '人文・社会科学研究所'],
        '720' => ['code' => '720', 'contents' => '管理，補助的経済活動を行う事業所（72専門サービス業）'],
        '721' => ['code' => '721', 'contents' => '法律事務所，特許事務所'],
        '722' => ['code' => '722', 'contents' => '公証人役場，司法書士事務所，土地家屋調査士事務所'],
        '723' => ['code' => '723', 'contents' => '行政書士事務所'],
        '724' => ['code' => '724', 'contents' => '公認会計士事務所，税理士事務所'],
        '725' => ['code' => '725', 'contents' => '社会保険労務士事務所'],
        '726' => ['code' => '726', 'contents' => 'デザイン業'],
        '727' => ['code' => '727', 'contents' => '著述・芸術家業'],
        '728' => ['code' => '728', 'contents' => '経営コンサルタント業，純粋持株会社'],
        '729' => ['code' => '729', 'contents' => 'その他の専門サービス業'],
        '730' => ['code' => '730', 'contents' => '管理，補助的経済活動を行う事業所（73広告業）'],
        '731' => ['code' => '731', 'contents' => '広告業'],
        '740' => ['code' => '740', 'contents' => '管理，補助的経済活動を行う事業所（74技術サービス業）'],
        '741' => ['code' => '741', 'contents' => '獣医業'],
        '742' => ['code' => '742', 'contents' => '土木建築サービス業'],
        '743' => ['code' => '743', 'contents' => '機械設計業'],
        '744' => ['code' => '744', 'contents' => '商品・非破壊検査業'],
        '745' => ['code' => '745', 'contents' => '計量証明業'],
        '746' => ['code' => '746', 'contents' => '写真業'],
        '749' => ['code' => '749', 'contents' => 'その他の技術サービス業'],
        '750' => ['code' => '750', 'contents' => '管理，補助的経済活動を行う事業所（75宿泊業）'],
        '751' => ['code' => '751', 'contents' => '旅館，ホテル'],
        '752' => ['code' => '752', 'contents' => '簡易宿所'],
        '753' => ['code' => '753', 'contents' => '下宿業'],
        '759' => ['code' => '759', 'contents' => 'その他の宿泊業'],
        '760' => ['code' => '760', 'contents' => '管理，補助的経済活動を行う事業所（76飲食店）'],
        '761' => ['code' => '761', 'contents' => '食堂，レストラン（専門料理店を除く）'],
        '762' => ['code' => '762', 'contents' => '専門料理店'],
        '763' => ['code' => '763', 'contents' => 'そば・うどん店'],
        '764' => ['code' => '764', 'contents' => 'すし店'],
        '765' => ['code' => '765', 'contents' => '酒場，ビヤホール'],
        '766' => ['code' => '766', 'contents' => 'バー，キャバレー，ナイトクラブ'],
        '767' => ['code' => '767', 'contents' => '喫茶店'],
        '769' => ['code' => '769', 'contents' => 'その他の飲食店'],
        '770' => ['code' => '770', 'contents' => '管理，補助的経済活動を行う事業所（77持ち帰り・配達飲食サービス業）'],
        '771' => ['code' => '771', 'contents' => '持ち帰り飲食サービス業'],
        '772' => ['code' => '772', 'contents' => '配達飲食サービス業'],
        '780' => ['code' => '780', 'contents' => '管理，補助的経済活動を行う事業所（78洗濯・理容・美容・浴場業）'],
        '781' => ['code' => '781', 'contents' => '洗濯業'],
        '782' => ['code' => '782', 'contents' => '理容業'],
        '783' => ['code' => '783', 'contents' => '美容業'],
        '784' => ['code' => '784', 'contents' => '一般公衆浴場業'],
        '785' => ['code' => '785', 'contents' => 'その他の公衆浴場業'],
        '789' => ['code' => '789', 'contents' => 'その他の洗濯・理容・美容・浴場業'],
        '790' => ['code' => '790', 'contents' => '管理，補助的経済活動を行う事業所（79その他の生活関連サービス業）'],
        '791' => ['code' => '791', 'contents' => '旅行業'],
        '792' => ['code' => '792', 'contents' => '家事サービス業'],
        '793' => ['code' => '793', 'contents' => '衣服裁縫修理業'],
        '794' => ['code' => '794', 'contents' => '物品預り業'],
        '795' => ['code' => '795', 'contents' => '火葬・墓地管理業'],
        '796' => ['code' => '796', 'contents' => '冠婚葬祭業'],
        '799' => ['code' => '799', 'contents' => '他に分類されない生活関連サービス業'],
        '800' => ['code' => '800', 'contents' => '管理，補助的経済活動を行う事業所（80娯楽業）'],
        '801' => ['code' => '801', 'contents' => '映画館'],
        '802' => ['code' => '802', 'contents' => '興行場（別掲を除く），興行団'],
        '803' => ['code' => '803', 'contents' => '競輪・競馬等の競走場，競技団'],
        '804' => ['code' => '804', 'contents' => 'スポーツ施設提供業'],
        '805' => ['code' => '805', 'contents' => '公園，遊園地'],
        '806' => ['code' => '806', 'contents' => '遊戯場'],
        '809' => ['code' => '809', 'contents' => 'その他の娯楽業'],
        '810' => ['code' => '810', 'contents' => '管理，補助的経済活動を行う事業所（81学校教育）'],
        '811' => ['code' => '811', 'contents' => '幼稚園'],
        '812' => ['code' => '812', 'contents' => '小学校'],
        '813' => ['code' => '813', 'contents' => '中学校'],
        '814' => ['code' => '814', 'contents' => '高等学校，中等教育学校'],
        '815' => ['code' => '815', 'contents' => '特別支援学校'],
        '816' => ['code' => '816', 'contents' => '高等教育機関'],
        '817' => ['code' => '817', 'contents' => '専修学校，各種学校'],
        '818' => ['code' => '818', 'contents' => '学校教育支援機関'],
        '820' => ['code' => '820', 'contents' => '管理，補助的経済活動を行う事業所（82その他の教育，学習支援業）'],
        '821' => ['code' => '821', 'contents' => '社会教育'],
        '822' => ['code' => '822', 'contents' => '職業・教育支援施設'],
        '823' => ['code' => '823', 'contents' => '学習塾'],
        '824' => ['code' => '824', 'contents' => '教養・技能教授業'],
        '829' => ['code' => '829', 'contents' => '他に分類されない教育，学習支援業'],
        '830' => ['code' => '830', 'contents' => '管理，補助的経済活動を行う事業所（83医療業）'],
        '831' => ['code' => '831', 'contents' => '病院'],
        '832' => ['code' => '832', 'contents' => '一般診療所'],
        '833' => ['code' => '833', 'contents' => '歯科診療所'],
        '834' => ['code' => '834', 'contents' => '助産・看護業'],
        '835' => ['code' => '835', 'contents' => '療術業'],
        '836' => ['code' => '836', 'contents' => '医療に附帯するサービス業'],
        '840' => ['code' => '840', 'contents' => '管理，補助的経済活動を行う事業所（84保健衛生）'],
        '841' => ['code' => '841', 'contents' => '保健所'],
        '842' => ['code' => '842', 'contents' => '健康相談施設'],
        '849' => ['code' => '849', 'contents' => 'その他の保健衛生'],
        '850' => ['code' => '850', 'contents' => '管理，補助的経済活動を行う事業所（85社会保険・社会福祉・介護事業）'],
        '851' => ['code' => '851', 'contents' => '社会保険事業団体'],
        '852' => ['code' => '852', 'contents' => '福祉事務所'],
        '853' => ['code' => '853', 'contents' => '児童福祉事業'],
        '854' => ['code' => '854', 'contents' => '老人福祉・介護事業'],
        '855' => ['code' => '855', 'contents' => '障害者福祉事業'],
        '859' => ['code' => '859', 'contents' => 'その他の社会保険・社会福祉・介護事業'],
        '860' => ['code' => '860', 'contents' => '管理，補助的経済活動を行う事業所（86郵便局）'],
        '861' => ['code' => '861', 'contents' => '郵便局'],
        '862' => ['code' => '862', 'contents' => '郵便局受託業'],
        '870' => ['code' => '870', 'contents' => '管理，補助的経済活動を行う事業所（87協同組合）'],
        '871' => ['code' => '871', 'contents' => '農林水産業協同組合（他に分類されないもの）'],
        '872' => ['code' => '872', 'contents' => '事業協同組合（他に分類されないもの）'],
        '880' => ['code' => '880', 'contents' => '管理，補助的経済活動を行う事業所（88廃棄物処理業）'],
        '881' => ['code' => '881', 'contents' => '一般廃棄物処理業'],
        '882' => ['code' => '882', 'contents' => '産業廃棄物処理業'],
        '889' => ['code' => '889', 'contents' => 'その他の廃棄物処理業'],
        '890' => ['code' => '890', 'contents' => '管理，補助的経済活動を行う事業所（89自動車整備業）'],
        '891' => ['code' => '891', 'contents' => '自動車整備業'],
        '900' => ['code' => '900', 'contents' => '管理，補助的経済活動を行う事業所（90機械等修理業）'],
        '901' => ['code' => '901', 'contents' => '機械修理業（電気機械器具を除く）'],
        '902' => ['code' => '902', 'contents' => '電気機械器具修理業'],
        '903' => ['code' => '903', 'contents' => '表具業'],
        '909' => ['code' => '909', 'contents' => 'その他の修理業'],
        '910' => ['code' => '910', 'contents' => '管理，補助的経済活動を行う事業所（91職業紹介・労働者派遣業）'],
        '911' => ['code' => '911', 'contents' => '職業紹介業'],
        '912' => ['code' => '912', 'contents' => '労働者派遣業'],
        '920' => ['code' => '920', 'contents' => '管理，補助的経済活動を行う事業所（92その他の事業サービス業）'],
        '921' => ['code' => '921', 'contents' => '速記・ワープロ入力・複写業'],
        '922' => ['code' => '922', 'contents' => '建物サービス業'],
        '923' => ['code' => '923', 'contents' => '警備業'],
        '929' => ['code' => '929', 'contents' => '他に分類されない事業サービス業'],
        '931' => ['code' => '931', 'contents' => '経済団体'],
        '932' => ['code' => '932', 'contents' => '労働団体'],
        '933' => ['code' => '933', 'contents' => '学術・文化団体'],
        '934' => ['code' => '934', 'contents' => '政治団体'],
        '939' => ['code' => '939', 'contents' => '他に分類されない非営利的団体'],
        '941' => ['code' => '941', 'contents' => '神道系宗教'],
        '942' => ['code' => '942', 'contents' => '仏教系宗教'],
        '943' => ['code' => '943', 'contents' => 'キリスト教系宗教'],
        '949' => ['code' => '949', 'contents' => 'その他の宗教'],
        '950' => ['code' => '950', 'contents' => '管理，補助的経済活動を行う事業所（95その他のサービス業）'],
        '951' => ['code' => '951', 'contents' => '集会場'],
        '952' => ['code' => '952', 'contents' => 'と畜場'],
        '959' => ['code' => '959', 'contents' => '他に分類されないサービス業'],
        '961' => ['code' => '961', 'contents' => '外国公館'],
        '969' => ['code' => '969', 'contents' => 'その他の外国公務'],
        '971' => ['code' => '971', 'contents' => '立法機関'],
        '972' => ['code' => '972', 'contents' => '司法機関'],
        '973' => ['code' => '973', 'contents' => '行政機関'],
        '981' => ['code' => '981', 'contents' => '都道府県機関'],
        '982' => ['code' => '982', 'contents' => '市町村機関'],
        '999' => ['code' => '999', 'contents' => '分類不能の産業'],
    ];
}
