document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.docodoco-cf7-extension .copy-button').forEach(function(el) {
        console.log("copy click event added");

        el.addEventListener('click', function() {
            const text = el.parentElement.innerText;
            navigator.clipboard.writeText(text).then(function() {
                let toast = document.createElement('div');
                toast.className = 'toast';
                toast.innerText = 'クリップボードにコピーしました';
                document.getElementById('toast-area').appendChild(toast);

                setTimeout(function() {
                    toast.remove();
                }, 3000);
            });
        });
    });
});