document.addEventListener('DOMContentLoaded', function() {
    let errMsgArea = document.getElementById('errorMessageArea');
    let form = document.getElementById('formDocodocoCF7ExtensionCommonSettings');
    let beforeScript = null;

    // update が true の場合、APIキーが有効ならフォームを送信する
    // false の場合はチェックのみ行う
    function checkAPIKey(update = false) {
        let apiKey = document.getElementById('inputDocodocoJPAPIKey').value;
        let script = document.createElement('script');
        script.referrerPolicy = "no-referrer-when-downgrade";
        script.src = `//api.docodoco.jp/v6/docodoco?key=${apiKey}`;

        let checkDoneCount = 0;
        let checkDomainSearchResult;

        callCheckDomainSearch(apiKey);

        // JS版のチェックが終わったら実行されるコード
        script.addEventListener('load', () => {
            checkDoneCount++;
            if (checkDoneCount === 2) {
                // JS版のチェックが後に終わったらこっちで check() を実行
                check();
            }
        });

        // ドメイン検索のチェックが終わったら実行されるコード
        document.addEventListener('docodoco_cf7_extension_check_domain_search', (e) => {
            checkDoneCount++;
            checkDomainSearchResult = e.detail;
            if (checkDoneCount === 2) {
                // ドメイン検索のチェックが後に終わったらこっちで check() を実行
                check();
            }
        });

        let check = () => {
            errMsgArea.innerHTML = '';
            let msg = '';

            if (SURFPOINT === undefined) {
                msg += '<div class="notice notice-error is-dismissible"><p>不明なエラーが発生しました。</p></div>';
                errMsgArea.innerHTML = msg;
                return;
            }

            if (SURFPOINT.getIP() === '') {
                msg += '<div class="notice notice-error is-dismissible"><p>有効なAPIキーではありません。正しいAPIキーが入力されているか、APIキーが停止されていないか確認してください。</p></div>';
                errMsgArea.innerHTML = msg;
                return;
            }

            if (SURFPOINT.HoujinBangou_3 === undefined) {
                msg += '<div class="notice notice-info is-dismissible"><p>オプションデータ「法人番号関連データ」が有効ではないため、メールタグ <code>[docomail_houjin_bangou]</code> は利用できません。</p></div>';
            }

            let disabledDomainSearchOptionsMsg = '';
            if (checkDomainSearchResult.freemail === false) {
                disabledDomainSearchOptionsMsg += '「フリーメール属性データ」';
            }
            if (checkDomainSearchResult.ispmail === false) {
                disabledDomainSearchOptionsMsg += '「ISPメール属性データ」';
            }
            if (checkDomainSearchResult.domainorg === false) {
                disabledDomainSearchOptionsMsg += '「ドメイン所有組織データ」';
            }

            if (disabledDomainSearchOptionsMsg !== '') {
                msg += `<div class="notice notice-info is-dismissible"><p>オプションデータ${disabledDomainSearchOptionsMsg}が有効ではないため、ドメイン検索機能 <code>docoform:use_domain_search</code> は利用できません。</p></div>`;
            }

            msg += '<div class="notice notice-success is-dismissible"><p>有効なAPIキーです。</p></div>';

            if (update) {
                // フォーム送信する場合はメッセージを出さない
                form.submit();
                return
            }

            errMsgArea.innerHTML = msg;
        }

        if (beforeScript !== null) {
            // 同じページ内で何度もチェックした場合は <script> が溜まるので削除する
            document.body.removeChild(beforeScript);
        }
        document.body.appendChild(script);
        beforeScript = script;
    }

    document.getElementById('checkDocodocoJPAPIKey').addEventListener('click', (e) => {
        checkAPIKey();
    });

    document.getElementById('updateDocodocoJPAPIKey').addEventListener('click', (e) => {
        checkAPIKey(true);
    });

    // ドメイン検索が使えるかAPIを叩く。結果は docodoco_cf7_extension_check_domain_search イベントで取得する
    function callCheckDomainSearch(apiKey) {
        const req = new XMLHttpRequest();
        req.onreadystatechange = function() {
            if (req.readyState !== 4) {
                return;
            }

            if (req.status !== 200) {
                // フリーメール・ISPメール・ドメイン情報が取れない場合（オプション未加入かAPIキーが無効などのエラーの場合）
                const event = new CustomEvent('docodoco_cf7_extension_check_domain_search', { detail: {freemail: false, ispmail: false, domainorg: false } });
                document.dispatchEvent(event);
                return;
            }

            let data = JSON.parse(req.responseText);

            if (data.status !== undefined) {
                // フリーメール・ISPメール・ドメイン情報が取れない場合（オプション未加入かAPIキーが無効などのエラーの場合）
                const event = new CustomEvent('docodoco_cf7_extension_check_domain_search', { detail: {freemail: false, ispmail: false, domainorg: false } });
                document.dispatchEvent(event);
                return;
            }

            const event = new CustomEvent('docodoco_cf7_extension_check_domain_search', {
                detail: {
                    freemail: data.FreeMail_6 !== undefined,
                    ispmail: data.ISPMail_7 !== undefined,
                    domainorg: data.DomainOrg_8 !== undefined
                }
            });
            document.dispatchEvent(event);
        };
        req.open('GET', `https://api.docodoco.jp/v6/docodoco_domain?key=${apiKey}&format=json&domain=geolocation.co.jp`);
        req.send(null);
    }
});