<?php if (!defined('ABSPATH')) exit; ?>

<div class="wrap docodoco-cf7-extension">
    <div id="toast-area"></div>

    <h1>使い方</h1>

    <h2>フォームの自動入力機能</h2>
    <p>
        お問い合わせフォームに企業情報を入力する際に、郵便番号や住所などの情報を自動で入力できます。<br>
        Contact Form 7 のフォームテンプレート編集画面で、フォームタグに <code>docoform:org_name</code> のようなオプションを追加することで有効にできます。
    </p>

    <h4>自動入力のオプション一覧</h4>
    <p>フォームの自動入力に使用できるオプション名の一覧です。</p>

    <table class="wp-list-table widefat fixed striped table-view-list pages">
        <thead>
            <tr>
                <th>オプション</th>
                <th>説明</th>
                <th>使用例</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>docoform:bcflag<span class="dashicons dashicons-clipboard copy-button"></span></td>
                <td>
                    企業判定 ※1
                </td>
                <td>[radio your-borc <span class="underline">docoform:bcflag</span> "法人" "個人"]</td>
            </tr>
            <tr>
                <td>docoform:org_name<span class="dashicons dashicons-clipboard copy-button"></span></td>
                <td>企業名</td>
                <td>[text your-org-name <span class="underline">docoform:org_name</span>]</td>
            </tr>
            <tr>
                <td>docoform:org_zip_code<span class="dashicons dashicons-clipboard copy-button"></span></td>
                <td>郵便番号</td>
                <td>[text your-zip <span class="underline">docoform:org_zip_code</span>]</td>
            </tr>
            <tr>
                <td>docoform:org_address<span class="dashicons dashicons-clipboard copy-button"></span></td>
                <td>住所</td>
                <td>[text your-address <span class="underline">docoform:org_address</span>]</td>
            </tr>
            <tr>
                <td>docoform:org_tel<span class="dashicons dashicons-clipboard copy-button"></span></td>
                <td>電話番号</td>
                <td>[tel your-tel <span class="underline">docoform:org_tel</span>]</td>
            </tr>
            <tr>
                <td>docoform:org_fax<span class="dashicons dashicons-clipboard copy-button"></span></td>
                <td>FAX番号</td>
                <td>[tel your-fax <span class="underline">docoform:org_fax</span>]</td>
            </tr>
            <tr>
                <td>docoform:org_url<span class="dashicons dashicons-clipboard copy-button"></span></td>
                <td>Webサイトアドレス</td>
                <td>[url your-url <span class="underline">docoform:org_url</span>]</td>
            </tr>
        </tbody>
    </table>

    <p>
        ※1. <code>docoform:bcflag</code> はラジオボタンにのみ対応。法人の場合は1番目、個人の場合は2番目の項目が選択されます。
    </p>

    <h2>ドメイン検索を使ってメールアドレスから企業情報を自動入力する</h2>
    <p>
        メールアドレスを入力することで、お問い合わせフォームに企業情報を自動で入力する機能です。<br>
        メールアドレスを入力した際にメールアドレスのドメイン部分を利用して、企業情報を自動で入力します。<br>
        メールアドレスのフォームタグに <code>docoform:use_domain_search</code> を追加すると有効になります。<br>
        ※ ドメイン検索のご利用には、<a href="https://www.docodoco.jp/api/searchdomain/" target="_blank">「フリーメール属性データ」「ISPメール属性データ」「ドメイン所有組織データ」</a>のご契約が必要です。
    </p>

    <hr>

    <h2>お問合せメールにどこどこJPの判定結果を付与する</h2>
    <p>
        お問い合わせフォームのメール本文に <code>[docomail_org_name]</code> のようなメールタグを追加することで、判定結果をメールに付加できます。<br>
        ※ この機能は、フォームの自動入力機能でドメイン検索を有効にしていてもどこどこJP JS版の判定結果のみを利用します。
    </p>

    <h4>メールタグの一覧</h4>
    <p>お問い合わせメールに付加できるどこどこJP判定結果のメールタグ一覧です。</p>

    <table class="wp-list-table widefat fixed striped table-view-list pages">
        <thead>
            <tr>
                <th>メールタグ</th>
                <th>説明</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>[docomail_org_name]<span class="dashicons dashicons-clipboard copy-button"></span></td>
                <td>企業名</td>
            </tr>
            <tr>
                <td>[docomail_org_zip_code]<span class="dashicons dashicons-clipboard copy-button"></td>
                <td>郵便番号</td>
            </tr>
            <tr>
                <td>[docomail_org_address]<span class="dashicons dashicons-clipboard copy-button"></td>
                <td>住所</td>
            </tr>
            <tr>
                <td>[docomail_org_tel]<span class="dashicons dashicons-clipboard copy-button"></td>
                <td>電話番号</td>
            </tr>
            <tr>
                <td>[docomail_org_fax]<span class="dashicons dashicons-clipboard copy-button"></td>
                <td>FAX番号</td>
            </tr>
            <tr>
                <td>[docomail_org_ipo_type]<span class="dashicons dashicons-clipboard copy-button"></td>
                <td>上場区分</td>
            </tr>
            <tr>
                <td>[docomail_stock_ticker_number]<span class="dashicons dashicons-clipboard copy-button"></td>
                <td>証券コード</td>
            </tr>
            <tr>
                <td>[docomail_org_capital]<span class="dashicons dashicons-clipboard copy-button"></td>
                <td>資本金</td>
            </tr>
            <tr>
                <td>[docomail_org_employees]<span class="dashicons dashicons-clipboard copy-button"></td>
                <td>従業員数</td>
            </tr>
            <tr>
                <td>[docomail_org_gross]<span class="dashicons dashicons-clipboard copy-button"></td>
                <td>売上高</td>
            </tr>
            <tr>
                <td>[docomail_org_industrial_category_l]<span class="dashicons dashicons-clipboard copy-button"></td>
                <td>業種大分類</td>
            </tr>
            <tr>
                <td>[docomail_org_industrial_category_m]<span class="dashicons dashicons-clipboard copy-button"></td>
                <td>業種中分類</td>
            </tr>
            <tr>
                <td>[docomail_org_industrial_category_s]<span class="dashicons dashicons-clipboard copy-button"></td>
                <td>業種小分類</td>
            </tr>
            <tr>
                <td>[docomail_org_url]<span class="dashicons dashicons-clipboard copy-button"></td>
                <td>Webサイトアドレス</td>
            </tr>
            <tr>
                <td>[docomail_houjin_bangou]<span class="dashicons dashicons-clipboard copy-button"></td>
                <td>法人番号 ※1</td>
            </tr>
        </tbody>
    </table>

    <p>
        ※1. <a href="https://www.docodoco.jp/data/marketplace/corporate-number/" target="_blank">「法人番号関連データ」</a>のご契約が必要です。
    </p>

    <hr>

    <h2>詳細な使い方・FAQ</h2>
    <p>
        <a href="https://knowledge.docodoco.jp/m_wp_plugin4/" target=_blank>ヘルプページ</a> をご覧ください。
    </p>
</div>
