<?php

if (!defined('ABSPATH')) exit;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['_wpnonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['_wpnonce'])), 'docodoco-cf7-extension-common-settings')) {
        wp_die('不正なリクエストです');
    }

    if (isset($_POST['docodocojp_apikey'])) {
        $post_data = [
            'docodocojp_apikey' => sanitize_text_field(wp_unslash($_POST['docodocojp_apikey'])),
            'add_script_tag' => isset($_POST['add_script_tag']) ? '1' : '',
        ];

        $validation_ok = true;

        if ($post_data['docodocojp_apikey'] === null) {
            echo '<div class="notice notice-error is-dismissible"><p>設定の保存に失敗しました。どこどこJP APIキーが入力されていません。</p></div>';
            $validation_ok = false;
        }
        if (preg_match('/\A[0-9a-zA-Z]{64}\z/', $post_data['docodocojp_apikey']) !== 1) {
            echo '<div class="notice notice-error is-dismissible"><p>設定の保存に失敗しました。どこどこJP APIキーが正しくありません。APIキーは 64 文字の文字列です。</p></div>';
            $validation_ok = false;
        }

        if ($validation_ok) {
            update_option('docodoco_cf7_extension_common_settings', $post_data, 'no');
            echo '<div class="notice notice-success is-dismissible"><p>設定を保存しました。</p></div>';
        }
    }
}

$common_settings = get_option('docodoco_cf7_extension_common_settings');
if ($common_settings !== false) {
    $docodocojp_apikey = isset($common_settings['docodocojp_apikey']) ? $common_settings['docodocojp_apikey'] : '';
    $add_script_tag = isset($common_settings['add_script_tag']) ? $common_settings['add_script_tag'] : '1'; // 既定の動作ではスクリプトタグを追加する
} else {
    $docodocojp_apikey = '';
    $add_script_tag = '1';  // 既定の動作ではスクリプトタグを追加する
}

?>
<div class="wrap">
    <h1>基本設定</h1>
    <p>プラグインの基本設定を行います。</p>

    <form method="post" action="" id="formDocodocoCF7ExtensionCommonSettings">
        <?php wp_nonce_field('docodoco-cf7-extension-common-settings'); ?>
        <table class="form-table">
            <tr>
                <th scope="row">
                    <label for="inputDocodocoJP_APIKey">どこどこJP APIキー</label>
                </th>
                <td>
                    <input id="inputDocodocoJPAPIKey" class="large-text" type="text" name="docodocojp_apikey" value="<?php echo esc_attr($docodocojp_apikey); ?>">
                    <p class="description">
                        ※ どこどこJPの詳細は <a href="https://www.docodoco.jp/" target="_blank">こちら</a> をご覧ください。<br>
                    </p>
                </td>
            </tr>
            <tr>
                <th scope="row">
                    <label for="add_script_tag">どこどこJPタグを追加する</label>
                </th>
                <td>
                    <input id="add_script_tag" type="checkbox" name="add_script_tag" value="1" <?php if($add_script_tag == 1) echo 'checked'; ?>> どこどこJPタグをページに追加する（既定値：有効）
                    <p class="description">
                        ※テーマファイルや他プラグインでどこどこJPスクリプトタグを設置する場合は、この設定を無効にしてください。<br>
                        ※詳細は <a href="https://knowledge.docodoco.jp/m_wp_plugin4/" target="_blank">ヘルプページ</a> をご覧ください。
                    </p>
                </td>
            </tr>
        </table>
        <div class="tablenav top">
            <span id="updateDocodocoJPAPIKey" class="button button-primary">変更を保存</span>
            <span id="checkDocodocoJPAPIKey" class="button">APIキーの有効性をチェック</span>
        </div>
        <div id="errorMessageArea"></div>
    </form>

    <p>基本的な利用方法は <a href="<?php echo esc_url(admin_url('admin.php?page=docodoco-cf7-extension-how-to-use')); ?>">使い方ページ</a> をご覧ください。</p>
</div>
