document.addEventListener("DOMContentLoaded", function() {
    let devToolsOpen = false;

    // 右クリック禁止
    document.addEventListener("contextmenu", function(e) {
        alert("このコンテンツはコピーできません。");
        e.preventDefault();
    });

    // テキスト選択禁止
    document.addEventListener("selectstart", function(e) {
        alert("このコンテンツはコピーできません。");
        e.preventDefault();
    });

    // コピーキー（Ctrl+C、Ctrl+X、Ctrl+U）を無効化
    document.addEventListener("keydown", function(e) {
        if (e.ctrlKey && (e.key === 'c' || e.key === 'x' || e.key === 'u')) {
            alert("このコンテンツはコピーできません。");
            e.preventDefault();
        }
    });

    // デベロッパーツール対策（F12やCtrl+Shift+Iのブロック）
    document.addEventListener("keydown", function(e) {
        if (e.keyCode === 123 || (e.ctrlKey && e.shiftKey && e.key === 'I')) {
            alert("開発者ツールは無効化されています。");
            e.preventDefault();
        }
    });

    // デベロッパーツールの監視
    setInterval(function() {
        if (!devToolsOpen && (window.outerHeight - window.innerHeight > 100 || window.outerWidth - window.innerWidth > 100)) {
            devToolsOpen = true;
            alert("開発者ツールが開かれました！");
        }
    }, 1000);

    // --- ここから追加：ドラッグ＆ドロップ禁止 ---
    document.addEventListener("dragstart", function(e) {
        alert("ドラッグ操作は禁止されています。");
        e.preventDefault();
    });

    document.addEventListener("drop", function(e) {
        alert("ドロップ操作は禁止されています。");
        e.preventDefault();
    });

    // すべての画像のドラッグを禁止
    document.querySelectorAll("img").forEach(function(img) {
        img.setAttribute("draggable", "false");
    });
});

