<?php

namespace App\Support;

class BrandsPlugin
{
    /**
     * Add support for perfect brands plugin
     *
     * @var bool
     */
    public $enable = false;

    public function __construct() {
        $this->enable = defined('PWB_PLUGIN_VERSION');
    }

    /**
     * Ensure brands response has missing fileds
     *
     * @param  array $brands
     * @return array
     */
    public function ensureBrandsResponse($brands) {
        foreach($brands as &$brand) {
            $brand["id"] = $brand["term_id"];
            $brand["image"] = null;
        }

        return $brands;
    }
}