<?php

namespace App\Repository;
use Automattic\WooCommerce\Utilities\RestApiUtil;

abstract class WoocommerceRepository
{
    public function __construct()
    {

    }

    /**
     * Ensure that data returns an array
     *
     * @param  array|\WP_Error $data
     * @return array
     */
    protected function ensureResponse($data) {
        if ( is_wp_error( $data ) ) {
            return [];
        }

        return $data;
    }

    /**
     * Get api for resources
     *
     * @return \WC_API
     */
    protected function getApi() {
        return wc_get_container()->get( RestApiUtil::class );
    }

    /**
     * Get api version
     *
     * @return string
     */
    protected function getApiVersion() {
        return "v3";
    }
}
