<?php
namespace App;

use WC_Post;
use WC_Product;
use WC_Product_Variation;

/**
 * Frontend Pages Handler
 */
class Frontend {

    public function __construct() {
        // add_filter( 'woocommerce_sale_flash', array($this, 'replaceSaleTagText'), 10, 3);
    }

    /**
     * Replace sale tag text
     * @see https://gist.github.com/ashokmhrj/9c1c26a450adb3c3b22f0ebd73a5f598
     *
     * @param  string $text
     * @param  WC_Post $post
     * @param  WC_Product $_product
     * @return string
     */
    public function replaceSaleTagText($text, $post, $product){

        if ( $product->get_type() == 'variable' ) {
            $available_variations = $product->get_available_variations();
            $maximumper = 0;
            for ($i = 0; $i < count($available_variations); ++$i) {
                $variation = $available_variations[$i];
                $regular_price = floatval($variation["display_regular_price"]);
                $sales_price = floatval($variation["display_price"]);

                if( $sales_price && $regular_price ) {
                    $percentage= round( ( ( $regular_price - $sales_price ) / $regular_price ) * 100 );
                    if ($percentage > $maximumper) {
                        $maximumper = $percentage;
                    }
                }

            }
            $text = '<span class="onsale">' . $maximumper  . '%</span>';
        } elseif ( $product->get_type() == 'simple' ) {
            $regular_price = floatval($product->get_regular_price());
            $sales_price = floatval($product->get_sale_price());

            if($regular_price && $sales_price) {
                $percentage = round( ( ( $regular_price - $sales_price ) / $regular_price ) * 100 );
                $text = '<span class="onsale">' . $percentage . '%</span>';
            }
        }

        return $text;
    }

}
