<?php
namespace App\Events;

use WP_Error;
use App\Models\DiscountRule;
use App\Models\DiscountStatus;
use App\Adapter\DiscountRuleAdapter;
use App\Repository\DiscountRulesRepository;

class Schedule {

    /**
     * Handle start_time schedule
     *
     * @param  int $discountRuleId
     * @return void
     */
    public function start_time($discountRuleId) {

        $discountRulesRepo = new DiscountRulesRepository();
        $discountRuleAdapter = new DiscountRuleAdapter();

        $item = $discountRulesRepo->getById($discountRuleId);

        if($item === null) {
            return new WP_Error( "schedule_discount_rule_end_time_failed", __( 'Cannot retrieve discount rule' ), array( 'status' => 500 ) );
        }

        $discountRule = $discountRuleAdapter->fromObject($item);
        $discountRule->setStatus(DiscountStatus::Active);

        $result = $discountRulesRepo->update($discountRule);
        if(!$result) {
            return new WP_Error( "schedule_discount_rule_start_time_failed", __( 'Cannot update existing discount rule.' ), array( 'status' => 500 ) );
        }

        $discountRule->updatePrice();
    }

    /**
     * Handle start_time schedule
     *
     * @param  int $discountRuleId
     * @return void
     */
    public function end_time($discountRuleId) {

        $discountRulesRepo = new DiscountRulesRepository();
        $discountRuleAdapter = new DiscountRuleAdapter();

        $item = $discountRulesRepo->getById($discountRuleId);
        if($item === null) {
            return new WP_Error( "schedule_discount_rule_end_time_failed", __( 'Cannot retrieve discount rule' ), array( 'status' => 500 ) );
        }

        $discountRule = $discountRuleAdapter->fromObject($item);
        $discountRule->setStatus(DiscountStatus::Inactive);

        $result = $discountRulesRepo->update($discountRule);
        if(!$result) {
            return new WP_Error( "schedule_discount_rule_end_time_failed", __( 'Cannot update existing discount rule.' ), array( 'status' => 500 ) );
        }

        // Status inactive, it will remove sale prices
        $discountRule->updatePrice();
    }
}
