<?php
namespace App\Events;

use App\Events\Schedule;
use App\Events\UpdatePrice;

class Jobs {

    /**
     * @var UpdatePrice
     */
    private $updatePriceJob;

    /**
     * @var UpdatePrice
     */
    private $scheduleJob;

    public const UPDATE_PRICE_ON_PRODUCTS = 'napps_discount_update_price';
    public const START_TIME_SCHEDULE = 'napps_discount_start_time_schedule';
    public const END_TIME_SCHEDULE = 'napps_discount_end_time_schedule';

    public function __construct()
    {
        $this->updatePriceJob = new UpdatePrice();
        $this->scheduleJob = new Schedule();
        
        add_action( Jobs::UPDATE_PRICE_ON_PRODUCTS, array($this->updatePriceJob, 'handle'), 10, 3 );
        add_action( Jobs::START_TIME_SCHEDULE, array($this->scheduleJob, 'start_time'), 10, 1 );
        add_action( Jobs::END_TIME_SCHEDULE, array($this->scheduleJob, 'end_time'), 10, 1 );

    }

}
