<?php
namespace App;

/**
 * Scripts and Styles Class
 */
class Assets {

    function __construct() {

        if ( is_admin() ) {
            add_action( 'admin_enqueue_scripts', [ $this, 'register' ], 5 );
        }
    }

    /**
     * Register our app scripts and styles
     *
     * @return void
     */
    public function register() {
        $this->register_scripts( $this->get_scripts() );
        $this->register_styles( $this->get_styles() );
    }

    /**
     * Register scripts
     *
     * @param  array $scripts
     *
     * @return void
     */
    private function register_scripts( $scripts ) {
        foreach ( $scripts as $handle => $script ) {
            $deps      = isset( $script['deps'] ) ? $script['deps'] : false;
            $in_footer = isset( $script['in_footer'] ) ? $script['in_footer'] : false;
            $version   = isset( $script['version'] ) ? $script['version'] : NAPPS_DISCOUNTRULES_VERSION;

            wp_register_script( $handle, $script['src'], $deps, $version, $in_footer );
        }
    }

    /**
     * Register styles
     *
     * @param  array $styles
     *
     * @return void
     */
    public function register_styles( $styles ) {
        foreach ( $styles as $handle => $style ) {
            $deps = isset( $style['deps'] ) ? $style['deps'] : false;

            wp_register_style( $handle, $style['src'], $deps, NAPPS_DISCOUNTRULES_VERSION );
        }
    }

    /**
     * Get all registered scripts
     *
     * @return array<string, array>
     */
    public function get_scripts() {

        $scripts = [
            'napps-discount-rules-runtime' => [
                'src'       => NAPPS_DISCOUNTRULES_ASSETS . '/js/runtime.js',
                'version'   => filemtime( NAPPS_DISCOUNTRULES_PATH . '/assets/js/runtime.js' ),
                'in_footer' => true
            ],
            'napps-discount-rules-vendor' => [
                'src'       => NAPPS_DISCOUNTRULES_ASSETS . '/js/vendors.js',
                'version'   => filemtime( NAPPS_DISCOUNTRULES_PATH . '/assets/js/vendors.js' ),
                'in_footer' => true
            ],
            'napps-discount-rules-admin' => [
                'src'       => NAPPS_DISCOUNTRULES_ASSETS . '/js/admin.js',
                'deps'      => [ 'jquery', 'napps-discount-rules-vendor', 'napps-discount-rules-runtime' ],
                'version'   => filemtime( NAPPS_DISCOUNTRULES_PATH . '/assets/js/admin.js' ),
                'in_footer' => true
            ]
        ];

        return $scripts;
    }

    /**
     * Get registered styles
     *
     * @return array<string, array>
     */
    public function get_styles() {

        $styles = [
            'napps-discount-rules-admin' => [
                'src' =>  NAPPS_DISCOUNTRULES_ASSETS . '/css/admin.css',
            ],
            'napps-discount-rules-vendors' => [
                'src' =>  NAPPS_DISCOUNTRULES_ASSETS . '/css/vendors.css'
            ],
        ];

        return $styles;
    }

}
