<?php
namespace App;

use App\Api\CategoryController;
use WP_REST_Controller;
use App\Api\ProductController;
use App\Api\DiscountRulesController;
use App\Repository\CategoryRepository;
use App\Repository\ProductRepository;
use App\Repository\DiscountRulesRepository;

/**
 * REST_API Handler
 */
class Api extends WP_REST_Controller {

    public function __construct() {
        add_action( 'rest_api_init', [ $this, 'register_routes' ] );
    }


    /**
     * Register the API routes
     *
     * @return void
     */
    public function register_routes() {

        $discountRulesRepo = new DiscountRulesRepository();
        $productRepo = new ProductRepository();
        $categoryRepo = new CategoryRepository();

        (new DiscountRulesController($discountRulesRepo))->register_routes();
        (new ProductController($productRepo))->register_routes();
        (new CategoryController($categoryRepo))->register_routes();
    }

}
