<?php
namespace App;

/**
 * Admin Pages Handler
 */
class Admin {

    public function __construct() {
        add_action( 'admin_menu', [ $this, 'admin_menu' ] );
    }

    protected function get_svg()
    {
        $svg = @'<svg width="150" height="150" viewBox="0 0 1080 1080" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M705.178 36C616.199 36.3484 530.989 71.9446 468.225 134.987C405.461 198.03 370.266 283.375 370.354 372.313H705.178V1044.94H1040V36H705.178Z" fill="#9BA1A8"/>
        <path d="M370.361 375.293H40V1044.94H370.361V375.293Z" fill="#9BA1A8"/>
        </svg>';
        $svg = "data:image/svg+xml;base64," . base64_encode($svg);
        return $svg;
    }

    /**
     * Register our menu page
     *
     * @return void
     */
    public function admin_menu() {

        $capability = 'manage_woocommerce';

        $slug       = sanitize_key('napps-discount-rules');
        $hook = null;

        if ( !is_plugin_active("napps/napps.php") ) {
            $hook = add_menu_page('NAPPS', __( 'Discount Rules', 'discount-rules-by-napps' ), $capability, $slug, array($this, 'plugin_page'), $this->get_svg(), 59);
        } else if ( current_user_can( $capability ) ) {
            $hook = add_submenu_page(sanitize_key('napps-home'), __( 'Discount Rules', 'discount-rules-by-napps' ), __( 'Discount Rules', 'discount-rules-by-napps' ), $capability, $slug , array($this, 'plugin_page') );
        }

        if($hook) {
            add_action( 'load-' . $hook, [ $this, 'init_hooks'] );
        }
    }

    /**
     * Initialize our hooks for the admin page
     *
     * @return void
     */
    public function init_hooks() {
        add_action( 'admin_enqueue_scripts', [ $this, 'enqueue_scripts' ] );
    }

    /**
     * Load scripts and styles for the app
     *
     * @return void
     */
    public function enqueue_scripts() {
        wp_enqueue_style( 'napps-discount-rules-admin' );
        wp_enqueue_style( 'napps-discount-rules-vendors' );
        wp_enqueue_script( 'napps-discount-rules-admin' );
    }

    /**
     * Render our admin page
     *
     * @return void
     */
    public function plugin_page() {
        ?>
        <script type="text/javascript">
            window.napps_discount_rules = {
                api: "<?php echo esc_url(get_rest_url()) ?>",
                nounce: "<?php echo esc_js(wp_create_nonce( 'wp_rest' )) ?>"
            }
        </script>
        <?php
        echo '
            <div id="vue-admin-app">
            </div>
        ';
    }
}
