<?php
namespace App\Adapter;

use App\Models\DiscountRule;

class DiscountRuleAdapter {

    /**
     * Parse a database object to discount rule object
     *
     * @param  mixed $item
     * @return DiscountRule
     */
    public function fromObject($item) {

        $discount = new DiscountRule($item->id);
        $discount->setAmount($item->amount)
            ->setDiscountType($item->discount_type)
            ->setName($item->name)
            ->setCreatedAt($item->created_at)
            ->setUpdatedAt($item->updated_at)
            ->setStatus($item->status)
            ->setStartDate($item->start_date);
            
        if($item->end_date) {
            $discount->setEndDate($item->end_date);
        }

        if(property_exists($item, 'products')) {
            $discount->setProductIds($item->products);
        }

        if(property_exists($item, 'collections')) {
            $discount->setCollectionIds($item->collections);
        }

        return $discount;
    }
}
