<?php
/*
Plugin Name: Disable Ozh's Admin Dropdown Menu.
Description: Disables Ozh's Admin Dropdown Menu for selected users. Zaantar does not like it.
Version: 1.2
Author: Zaantar
Author URI: http://zaantar.eu
License: GPL2
*/

/*
    Copyright 2012 Zaantar (email: zaantar@gmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as 
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/


/*****************************************************************************\
		I18N
\*****************************************************************************/

define( 'DOM_TEXTDOMAIN', 'disable-ozh-admin-dropdown-menu' );

add_action( 'init', 'dom_load_textdomain' );

function dom_load_textdomain() {
	$plugin_dir = basename(dirname(__FILE__));
	load_plugin_textdomain( DOM_TEXTDOMAIN, false, $plugin_dir.'/languages' );
}


/*****************************************************************************\
		OPTIONS
\*****************************************************************************/

define( 'DOM_PLUGNAME', 'Disable Ozh\'s Admin Dropodown Menu' );

add_action( 'admin_menu','dom_add_admin_menu' );

function dom_add_admin_menu() {
	if( !is_multisite() ) {
		add_options_page( __( DOM_PLUGNAME, DOM_TEXTDOMAIN ), __( DOM_PLUGNAME, DOM_TEXTDOMAIN ), 'manage_options', __FILE__, 'dom_options_page' );    
	}
}


add_action( 'network_admin_menu', 'dom_add_network_admin_menu' );

function dom_add_network_admin_menu() {
	add_submenu_page( 'settings.php', __( DOM_PLUGNAME, DOM_TEXTDOMAIN ), __( DOM_PLUGNAME, DOM_TEXTDOMAIN ), 'manage_network_options', __FILE__, 'dom_options_page' );    
}


define( 'DOM_OPTIONS', 'dom_options' );


function dom_get_options() {
	return get_site_option( DOM_OPTIONS );
}


function dom_options_page() {
	if( isset($_REQUEST['action']) ) {
        $action = $_REQUEST['action'];
    } else {
        $action = 'default';
    }
    if( $action == 'update-options') {
    	update_site_option( DOM_OPTIONS, $_REQUEST['dom_options'] );
    }
    $options = dom_get_options();
	?>
	<div id="wrap">
		<h2><?php _e( DOM_PLUGNAME, DOM_TEXTDOMAIN ); ?></h2>
		<form method="post">
			<input type="hidden" name="action" value="update-options" />
			<table class="form-table">
                <tr valign="top">
                	<th><label><?php _e( 'Disable dropdown menu for following users:' , DOM_TEXTDOMAIN ); ?></label></th>
                	<td><input name="<?php echo DOM_OPTIONS; ?>[dom_user_list]" type="text" value="<?php echo $options['dom_user_list']; ?>" /></td>
                </tr>
            </table>
            <p><?php _e( 'Enter user IDs separated by commas or <code>*</code> to disable for all users.', DOM_TEXTDOMAIN ); ?></p>
			<p><?php printf( __( 'Your user ID is %s.', DOM_TEXTDOMAIN ), '<code>'.get_current_user_id().'</code>' ); ?></p>
			<p class="submit">
				<input type="submit" value="<?php _e( 'Save', DOM_TEXTDOMAIN ); ?>" />
			</p>
		</form>
	</div>
	<?php
}


/*add_action( 'admin_init', 'dom_register_setting' );


function dom_register_setting() {
//TODO
	add_settings_section( DOM_OPTIONS, __( 'Main settings', DOM_TEXTDOMAIN ), 'dom_main_section_text', DOM_OPTIONS );
	add_settings_field( 'dom_user_list', __( 'Disable dropdown menu for following users:' , DOM_TEXTDOMAIN ), 'dom_field_user_list', DOM_OPTIONS, DOM_OPTIONS );
	/*add_settings_field( 'atd_cap_dir', __( 'Directory for users with the special capability' , ATD_TEXTDOMAIN ), 
		'atd_field_cap_dir', ATD_OPTIONS, ATD_OPTIONS );
	add_settings_field( 'atd_common_dir', __( 'Directory for common users' , ATD_TEXTDOMAIN ), 'atd_field_common_dir', ATD_OPTIONS, ATD_OPTIONS ); 
	add_settings_field( 'menu_title', __( 'ATD menu title' , ATD_TEXTDOMAIN ), 'atd_field_menu_title', ATD_OPTIONS, ATD_OPTIONS ); 
	add_settings_field( 'cap_dir_title', __( '\'Capability directory\' title' , ATD_TEXTDOMAIN ), 'atd_field_cap_dir_title', ATD_OPTIONS, ATD_OPTIONS ); 
	add_settings_field( 'cap_dir_cap', __( 'Special capability' , ATD_TEXTDOMAIN ), 'atd_field_cap_dir_cap', ATD_OPTIONS, ATD_OPTIONS ); 
	register_setting( DOM_OPTIONS, DOM_OPTIONS );
}


function dom_main_section_text() {
	echo '<p>'.__( 'Enter user IDs separated by commas or <code>*</code> to disable for all users.', DOM_TEXTDOMAIN ).'</p>';
}


function dom_field_user_list() {
	$options = get_option( DOM_OPTIONS );
	?>
	<input id="dom_user_list" name="<?php echo DOM_OPTIONS; ?>[dom_user_list]" type="text" value="<?php echo $options['dom_user_list']; ?>" />
	<?php
}*/




/*****************************************************************************\
		REMOVE HOOKS
\*****************************************************************************/

add_action( 'admin_init', 'dom_init', -10000 );

function dom_init() {
	$options = dom_get_options();
	$user_list = explode( ',', $options['dom_user_list'] );
	
	//$userdata = get_userdata( get_current_user_id() );
	//if( $userdata->user_login == 'zaantar' ) {
	if( in_array( '*', $user_list ) or in_array( get_current_user_id(), $user_list ) ) {
		//remove_action('admin_init', 'wp_ozh_adminmenu_init', -1000);	// Init plugin defaults or read options
		//remove_action('admin_menu', 'wp_ozh_adminmenu_add_page', -999); // Add option page
		remove_action('admin_head', 'wp_ozh_adminmenu_head', 999); // Insert CSS & JS in <head>
		remove_action('in_admin_footer', 'wp_ozh_adminmenu_footer'); // Add unobstrusive credits in footer
		//remove_filter('plugin_action_links_'.plugin_basename(__FILE__), 'wp_ozh_adminmenu_plugin_actions', -10); // Add Config link to plugin list
		remove_filter('ozh_adminmenu_icon_ozh_admin_menu', 'wp_ozh_adminmenu_customicon'); // This plugin will have its own icon of course
		remove_filter('in_admin_header', 'wp_ozh_adminmenu', -9999); // Add the new admin menu right after the header area. Make sure we're first.
	}
}

?>
