# Disable Comments Selectively

Contributors:      keith_wp  
Author Link:       https://drakard.com/  
Requires at least: 4.2 or higher  
Tested up to:      6.7.2  
Requires PHP:      8.3  
Stable tag:        0.16  
License:           BSD-3-Clause  
License URI:       https://directory.fsf.org/wiki/License:BSD-3-Clause  
Tags:              comments, disable comments, disable, remove comments, disable media comments  

Choose which post types, taxonomies and/or terms will have comments disabled.


## Description

If you'd like to have some comments on your site, but don't want them on every kind of post, then this plugin is for you.

Go to the Discussion Settings of your site and select which post types, taxonomies and/or terms will automatically disable commenting, regardless of the individual post setting.


## Installation

1. Upload the plugin files to the **/wp-content/plugins/disable-comments-selectively/** directory, or install the plugin through the WordPress plugins screen directly.
2. Activate the plugin through the 'Plugins' screen in WordPress
3. Go to the Settings -> Discussion page to configure the plugin, selecting which types, taxonomies and terms should be affected.


## Frequently Asked Questions

**Comments are still in the admin area**

This plugin only affects the front end by design, so it will look like nothing has changed in the admin; eg. you'll still see old comments, the number of previous comments on a post in the little comment bubble, the "allow comments" checkbox, and even add comments from the post screen.

But when looking at that same post from the front end, nobody will be able to view its comments nor make new ones.

**I want to disable all the comments!**

Better to install a plugin like [Disable Comments](https://wordpress.org/plugins/disable-comments/) which will remove them across the site, and hide them in the admin area too.

**Nothing happens**

Then the odds are that the theme you're using isn't following [the usual WP methods for comments](https://www.rayofsolaris.net/blog/2012/how-to-check-if-comments-are-allowed-in-wordpress/). This plugin has been tested with all the default WP themes (from 2010 to 2023) and works as intended.

**The RSS feeds still show old comments**

It's probably because it's been cached, either by your browser or by WP itself. You can quickly [force refresh](https://www.wikihow.com/Force-Refresh-in-Your-Internet-Browser) your browser to check that, but if it's been cached by WP then you'll need to clear that or wait for it to expire.

**Comment Widgets**

I've tested this with the default WP Recent Comments widget and it works fine, but I can't guarantee what happens with any of the hundred other comment widgets out there.

If it uses the normal WP function calls for comments, it should be okay - if it's making custom database calls directly, then no.



## Screenshots

1. Simple settings, at the end of your normal Discussion Settings page.


## Changelog

### 0.16
* Fix: Stopped creating deprecated dynamic properties for PHP 8.3
* Tested with WP 6.7.2

### 0.15
* Tested with WP 6.5, 6.4, 6.3.2 and the 2021, 2022 and 2023 themes

### 0.12
* Tested with WP 5.3 and the new twentytwenty theme

### 0.11
* Remembered to use wp_sprintf instead of concatenating multiple strings...

### 0.1
* Initial release.


