<?php
    if ( ! defined( 'ABSPATH' ) ) {
        exit;
    }

    $urlLogo = esc_url( DINO_PLUGIN_URL . 'assets/img/logo-dino-2.svg' );
    $time_post = microtime(true);
?>
<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Publicações Dino</title>
</head>

<body>
    <div class="wrap">
        <img src="<?php echo esc_html($urlLogo) ?>" alt="Dino">
        <hr>
        <div class="container-post">
            <div class="row-dino">
                <p style="width: 100%; float: left; font-size: 28px; color:#0045a8">Instruções de uso Dino</p>
            </div>
            <br>

            <p><strong>Instru&ccedil;&otilde;es</strong></p>
            <ol>
                <li aria-level="1">O plugin &eacute; compat&iacute;vel com as vers&otilde;es Wordpress e PHP 5.6 ou
                    superior. Para verificar o status da vers&atilde;o instalada, acesse: Ferramentas &gt;
                    Diagn&oacute;sticos &gt; Informa&ccedil;&otilde;es</li>
                <li aria-level="1">O uso do plugin &eacute; bem simples e consiste em dois passos principais</li>
                <ol>
                    <li aria-level="2">A cria&ccedil;&atilde;o do usu&aacute;rio parceiro. A conex&atilde;o &eacute;
                        feita uma &uacute;nica vez e "conecta" o site parceiro ao servidor de publica&ccedil;&atilde;o
                        Dino</li>
                    <li aria-level="2">O passo seguinte &eacute; incluir as vitrines no site. Para isso criamos diversos
                        modelos de exibi&ccedil;&atilde;o das not&iacute;cias atrav&eacute;s de [shortcodes]*</li>
                </ol>
            </ol>
            <p>*Shortcode &eacute; um tipo de elemento do WordPress que permite que o usu&aacute;rio insira desde
                pequenas informa&ccedil;&otilde;es personalizadas at&eacute; controlar a exibi&ccedil;&atilde;o de parte
                do conte&uacute;do com um simples <em>[shortcode]</em>. Um pequeno c&oacute;digo que quando inserido em
                um elemento texto do Wordpress, monta dinamicamente um conjunto de elementos visuais.</p>
            <ol>
                <li aria-level="1">Preparamos alguns tipos vitrines para aumentar aos op&ccedil;&otilde;es de
                    visibilidade das not&iacute;cias Dino nos sites parceiros.</li>
                <ol>
                    <li aria-level="2">Para isso, acesse o menu do plugin e escolha a vitrine que mais encaixe no layout
                        do site. N&atilde;o se preocupe com a formata&ccedil;&atilde;o, nossas vitrines seguem a folha
                        de estilo do site. <br /></li>
                    <li aria-level="2">Depois de escolhia a vitrine voc&ecirc; deve definir a quantidade de
                        not&iacute;cias que deseja exibir no local e copiar o shortcode que vem logo abaixo.</li>
                    <li aria-level="2">Abra o componente, post ou p&aacute;gina do Wordpress em que deseja exibir e a
                        not&iacute;cia e cole o shortcode copiado no aba "texto" do componente. Se estiver usando o
                        editor Gutemberg, &eacute; necess&aacute;rio abrir um bloco HTML. Cole o shortcode e salve a
                        p&aacute;gina ou post normalmente.<br /><br /><br />Em algumas vers&otilde;es de Wordpress
                        &eacute; poss&iacute;vel que o sistema retorne um erro de Json no topo da p&aacute;gina. Em
                        todos os testes a solu&ccedil;&atilde;o funcionou normalmente, desconsidere o erro.&nbsp;</li>
                </ol>
            </ol>


            <br>
        </div>
        <div class="container">

        </div>
    </div>
</body>

</html>