<?php
if (!defined('ABSPATH')) {
    exit;
}

$url = site_url();
$urlLogo = esc_url(DINO_PLUGIN_URL . 'assets/img/logo-dino-2.svg');
$cadastro = false;
$cadastroCategoria = false;
$envioemail = false;

$urlauth = esc_url($url . "/wp-json/dino-divulgador-de-noticias/v1/auth");
$urlpublish = esc_url($url . "/wp-json/dino-divulgador-de-noticias/v1/publish");
$urldelete = esc_url($url . "/wp-json/dino-divulgador-de-noticias/v1/delete-news");
$urlversion = esc_url($url . "/wp-json/dino-divulgador-de-noticias/v1/version");
$urllog = esc_url($url . "/wp-json/dino-divulgador-de-noticias/v1/logs");

global $wpdb;

$envioemail = false;
try {
    $results = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}dino_users LIMIT 1");
    //echo json_encode($results);
    if (!empty($results)) {
        $cadastro = true;
        foreach ($results as $rowtitle) {
            $nome = $rowtitle->nome;
            $email = $rowtitle->login;
            $senha = $rowtitle->password;
        }
    }

    $resultsCategoria = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}dino_categoria LIMIT 1");
    //echo json_encode($results);
    if (!empty($resultsCategoria)) {
        $cadastroCategoria = true;
        foreach ($resultsCategoria as $rowtitle) {
            $nomeCategoria = $rowtitle->nome;
        }
    }
} catch (Exception $e) {

}

$categories = get_categories(array(
        'orderby' => 'name',
        'parent' => 0
));

?>
<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Publicações Dino</title>
</head>

<body>
<div class="wrap">
    <img src="<?php echo esc_html($urlLogo) ?>" alt="Dino">
    <hr>
    <div class="row">
        <div class="col-lg-12">
            <p style="width: 100%; float: left; font-size: 28px; color:#0045a8">Cadastre seu usuário</p>
        </div>
    </div>
    <?php
    if (esc_html($cadastro) == true) {
        ?>
        <div class="row">
            <div class="col-lg-12 form-group">
                <div class="alert alert-primary text-center" role="alert">
                    Seu cadastro está ativo!
                </div>
                <div class="alert alert-primary text-center" role="alert">
                    Copie os dados abaixo e envie para o administrador do Dino, no email: tecnologia@dino.com.br
                </div>
            </div>
            <div class="col-lg-12 form-group">
                <table style="width: 100%">
                    <tbody>
                    <tr>
                        <td style="width: 100%;">
                            <?php
                            if (esc_html($envioemail) == true) {
                                ?>
                                <div class="alert alert-warning text-center" role="alert">
                                    O seu portal não tem configuração SMTP. A plataforma DINO não irá receber os dados
                                    de autenticação. Para que a integração comece a funcionar, envie ao adminstrador do
                                    DINO as credenciais a baixo:
                                </div>
                                <?php
                            }
                            ?>
                        </td>
                    </tr>
                    <tr>
                        <td style="width: 100%;">
                            <br>
                        </td>
                    </tr>

                    <tr>
                        <td style="width: 100%; text-align: left;">
                            Nome: <?php echo esc_html($nome) ?>
                        </td>
                    </tr>
                    <tr>
                        <td style="width: 100%; text-align: left;">
                            Site: <?php echo esc_html($url) ?>
                        </td>
                    </tr>
                    <tr>
                        <td style="width: 100%; text-align: left;">
                            E-mail: <?php echo esc_html($email) ?>
                        </td>
                    </tr>
                    <tr>
                        <td style="width: 100%; text-align: left;">
                            Senha: <?php echo esc_html($senha) ?>
                        </td>
                    </tr>
                    <tr>
                        <td style="width: 100%; text-align: left;">
                            URL Autenticação: <?php echo esc_html($urlauth) ?>
                        </td>
                    </tr>
                    <tr>
                        <td style="width: 100%; text-align: left;">
                            URL Publicar: <?php echo esc_html($urlpublish) ?>
                        </td>
                    </tr>
                    <tr>
                        <td style="width: 100%; text-align: left;">
                            URL Apagar Notícia: <?php echo esc_html($urldelete) ?>
                        </td>
                    </tr>
                    <tr>
                        <td style="width: 100%; text-align: left;">
                            URL Versão do Plugin: <?php echo esc_html($urlversion) ?>
                        </td>
                    </tr>
                    <tr>
                        <td style="width: 100%; text-align: left;">
                            URL Log: <?php echo esc_html($urllog) ?>
                        </td>
                    </tr>
                    <tr>
                        <td style="width: 100%; text-align: left; display: none;">
                            <form action="#" method="POST">
                                <input type="submit" class="btn btn-primary" name="submit" value="Alterar"/>
                            </form>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="col-lg-12 form-group">
                <?php
                if (esc_html($cadastroCategoria) == true) {
                    ?>
                    <div class="alert alert-primary text-center" role="alert"
                         style="margin-top: 24px; padding-bottom: 15px">
                        Categorias sincronizadas com Dino
                    </div>
                    <?php
                } else {
                    ?>
                    <div class="alert alert-primary text-center" role="alert">
                        Selecione a categoria que deseja sincronizar as notícias do Dino
                    </div>
                    <?php
                }
                ?>

            </div>
            <div class="col-lg-12 form-group" style="margin-top: 24px">
                <b>Categoria padrão do Dino: Notícias Corporativas</b><br>
            </div>
            <?php
            if (esc_html($cadastroCategoria) == false) {
                ?>
                <form method="POST" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
                    <?php wp_nonce_field( 'dino_user_action', 'dino_nonce' ); ?>
                    <input type="hidden" name="action" value="dino_categoria_ajax" />

                    <table style="width: 100%; margin-top: 24px">
                        <tbody>
                        <tr>
                            <td style="width: 100%;">
                                <label>Categoria</label>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 100%;">
                                <select name="categoria" class="form-control" required>
                                    <option value="">Selecione sua categoria</option>
                                    <?php foreach ( $categories as $category ) : ?>
                                        <option value="<?php echo esc_attr( $category->name ); ?>">
                                            <?php echo esc_html( $category->name ); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 100%; text-align: left;">
                                <br>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 100%; text-align: left;">
                                <button type="submit" class="btn btn-primary">Salvar Categoria</button>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </form>
                <?php
            } else {
                ?>
                <div class="col-lg-12 form-group">
                    <b>Sua categoria selecionada: <?php echo esc_html($nomeCategoria) ?></b><br>
                </div>
                <div class="col-lg-12 form-group">
                    <form method="POST" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
                        <?php wp_nonce_field( 'dino_user_action', 'dino_nonce' ); ?>
                        <input type="hidden" name="action" value="dino_remover_categoria_ajax" />

                        <button type="submit" name="submit" value="Remover Categoria" class="btn btn-danger">
                            Remover Categoria
                        </button>
                    </form>
                </div>
                <?php
            }
            ?>
        </div>
        <?php
    } else {
        ?>
        <div class="row">
            <div class="col-lg-12 form-group">
                <div class="alert alert-secondary text-center" role="alert">
                    Bem vindo ao Dino, precisamos que ralize seu cadastro para podermos divulgar as melhores notícias
                    corporativas
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-4 form-group">

            </div>
            <div class="col-lg-4 form-group">
                <div class="card">
                    <div class="card-body">
                        <form method="POST" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
                            <?php wp_nonce_field( 'dino_user_action', 'dino_nonce' ); ?>
                            <input type="hidden" name="action" value="dino_user_ajax" />

                            <table style="width: 100%">
                                <tbody>
                                <tr>
                                    <td style="width: 100%;">
                                        <label>Nome</label>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="width: 100%;">
                                        <input type="text" id="nome" name="nome" class="form-control" required style="width: 100%" />
                                    </td>
                                </tr>

                                <tr>
                                    <td style="width: 100%; text-align: left;">
                                        <label>Email</label>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="width: 100%; text-align: left;">
                                        <input type="email" id="email" name="email" class="form-control" required style="width: 100%" />
                                    </td>
                                </tr>
                                <tr>
                                    <td style="width: 100%; text-align: left;">
                                        <label>Senha</label>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="width: 100%; text-align: left;">
                                        <input type="password" id="senha" name="senha" class="form-control" required style="width: 100%" />
                                    </td>
                                </tr>
                                <tr>
                                    <td style="width: 100%; text-align: left;">
                                        <br>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="width: 100%; text-align: left;">
                                        <button type="submit" class="btn btn-primary" style="width: 100%">Salvar</button>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 form-group">

            </div>
        </div>
        <?php
    }
    ?>
</div>
</body>

</html>