<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

use Firebase\JWT\JWT;

//require_once plugin_dir_path(__FILE__) . 'dinoDAO/logDAO.php';

class Dino_Auth {

    private $jwt_secret = "e02c91bf03ea8a306eb2f3ba6b383024a96a59f7b1bec7ad8887acf620e9c4c5%";
    private $jwt_issuer = "dino-divulgador-de-noticias";
    private $jwt_role = "DINO_NOTICIAS_CORPORATIVAS";

    public function __construct() {
        add_action('rest_api_init', [$this, 'register_routes']);
    }

    public function register_routes() {
        register_rest_route('dino-divulgador-de-noticias/v1', '/auth', [
            'methods'  => 'POST',
            'callback' => [$this, 'authenticate_user'],
            'permission_callback' => '__return_true',
        ]);
    }

    public function authenticate_user(WP_REST_Request $request) {
        global $wpdb;

        $dados = $request->get_json_params();

        if ( ! isset($dados['login'], $dados['password']) ) {
            $this->salvarLog('AUTENTICACAO', 'ERRO', 'USUÁRIO E SENHA NÃO INFORMADOS');
            http_response_code(400);
            return json_encode(['message' => 'Dados inválidos']);
        }

        $usuario = $wpdb->get_row(
            $wpdb->prepare(
                "SELECT id, login, password_hash FROM {$wpdb->prefix}dino_users WHERE login = %s LIMIT 1",
                sanitize_text_field($dados['login'])
            )
        );

        if ( $usuario && password_verify($dados['password'], $usuario->password_hash) ) {
            $expire = time() + intval(get_option('api_dino_jwt_expire', 60));

            $payload = [
                'iss'   => $this->jwt_issuer,
                'iat'   => time(),
                'exp'   => $expire,
                'sub'   => $usuario->id,
                'login' => $usuario->login,
                'role'  => $this->jwt_role,
            ];

            $jwt = JWT::encode($payload, $this->jwt_secret, 'HS256');

            $this->salvarLog('AUTENTICACAO', 'SUCESSO', 'USUÁRIO AUTENTICADO');
            return ['access_token' => $jwt];
        }

        $this->salvarLog('AUTENTICACAO', 'ERRO', 'USUÁRIO OU SENHA INVÁLIDO');
        return new WP_Error('unauthorized', 'Usuário ou senha inválido', ['status' => 401]);
    }

    private function salvarLog($tipo, $status, $mensagem) {
        global $wpdb;
        $table = $wpdb->prefix . 'dino_logs';

        $dataAtual = current_time('mysql');

        $wpdb->insert(
            $table,
            array(
                'dataLog' => $dataAtual,
                'statusLog' => $status ?? ' ',
                'tipoLog' => $tipo ?? ' ',
                'mensagemLog' => $mensagem ?? ' '
            ),
            array('%s', '%s', '%s')
        );
        error_log("[$tipo][$status] $mensagem");
    }
}