<?php
/**
 * Contributors: dinoknewin
 * Plugin Name: Dino Divulgador de Notícias
 * Description: Conquiste autoridade por meio de notícias corporativas.
 * Plugin URI: https://dino.com.br/planos
 * Version: 3.4
 * Author: Dino Divulgador de Notícias
 * Author URI: https://www.dino.com.br
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: dino-divulgador-de-noticias
 * Domain Path: /languages
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$base = dirname(__FILE__);

if ( ! defined( 'DINO_PLUGIN_FILE' ) ) {
    define( 'DINO_PLUGIN_FILE', __FILE__ );
}
if ( ! defined( 'DINO_PLUGIN_DIR' ) ) {
    define( 'DINO_PLUGIN_DIR', plugin_dir_path( DINO_PLUGIN_FILE ) );
}
if ( ! defined( 'DINO_PLUGIN_URL' ) ) {
    define( 'DINO_PLUGIN_URL', plugin_dir_url( DINO_PLUGIN_FILE ) );
}

require_once plugin_dir_path(__FILE__) . 'vendor/autoload.php';

require_once plugin_dir_path(__FILE__) . 'includes/class-dino-auth.php';
require_once plugin_dir_path(__FILE__) . 'includes/class-dino-publish.php';
require_once plugin_dir_path(__FILE__) . 'includes/class-dino-logs.php';
require_once plugin_dir_path(__FILE__) . 'includes/class-dino-delete.php';
require_once plugin_dir_path(__FILE__) . 'includes/class-dino-version.php';
require_once plugin_dir_path(__FILE__) . 'includes/functions.php';

new Dino_Auth();
new Dino_Publish();
new Dino_Logs();
new Dino_Delete();
new Dino_Version();