<?php
/**
 * Plugin Name: DigitalME Join Button for Discord
 * Plugin URI:  https://www.DigitalME.cc/digitalme-join-button-for-discord
 * Description: Adds a simple shortcode and settings page to display a fixed "Join our Discord!" button. Button text and colors are fixed.
 * Version:     1.2.0
 * Author:      DigitalME
 * Author URI:  https://www.DigitalME.cc
 * License:     GPLv2 or later
 * Text Domain: digitalme-join-button-for-discord
 * Domain Path: /languages
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Register settings page
function digitalme_discord_register_settings_page() {
    add_options_page(
        'Discord Button Settings',
        'Discord Button',
        'manage_options',
        'digitalme_discord_settings',
        'digitalme_discord_render_settings_page'
    );
}
add_action('admin_menu', 'digitalme_discord_register_settings_page');

// Register settings
function digitalme_discord_register_settings() {
    register_setting('digitalme_discord_settings_group', 'digitalme_discord_url', array(
        'type' => 'string',
        'sanitize_callback' => 'esc_url_raw',
        'default' => ''
    ));
}
add_action('admin_init', 'digitalme_discord_register_settings');

// Render settings page
function digitalme_discord_render_settings_page() {
    ?>
    <div class="wrap">
        <h1>Discord Button Settings</h1>
        <form method="post" action="options.php">
            <?php
            settings_fields('digitalme_discord_settings_group');
            do_settings_sections('digitalme_discord_settings_group');
            ?>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">Discord Invite URL</th>
                    <td>
                        <input type="url" name="digitalme_discord_url" value="<?php echo esc_attr(get_option('digitalme_discord_url')); ?>" size="50" placeholder="https://discord.gg/your-invite" />
                        <p class="description">Enter your Discord invite URL. This will be used by the shortcode [digitalme_discord_button].</p>
                    </td>
                </tr>
            </table>
            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}

// Shortcode function
function digitalme_discord_shortcode() {
    $discord_url = get_option('digitalme_discord_url');
    if (!$discord_url) return '';

    $style = 'display:inline-block;padding:10px 16px;border-radius:4px;text-decoration:none;font-weight:600;line-height:1.2;background:#7289DA;color:#ffffff;';
    return '<a href="' . esc_url($discord_url) . '" target="_blank" rel="noopener noreferrer" style="' . esc_attr($style) . '">Join our Discord!</a>';
}
add_shortcode('digitalme_discord_button', 'digitalme_discord_shortcode');

// End of file