<?php

if (!defined("ABSPATH"))
      exit;


/*
 * Add Link (Tab) to My Account menu
 */
add_filter ( 'woocommerce_account_menu_items', 'dwwsunarc_wallet_link', 40 );
function dwwsunarc_wallet_link( $menu_links ){
 
	$menu_links = array_slice( $menu_links, 0, 5, true ) 
	+ array( 'dwwsunarc_wallet' => 'Wallet' )
	+ array_slice( $menu_links, 5, NULL, true );
 
	return $menu_links;
 
}

/*
 * Register Permalink Endpoint
 */
add_action( 'init', 'dwwsunarc_wallet_endpoint' );
function dwwsunarc_wallet_endpoint() {
 
	add_rewrite_endpoint( 'dwwsunarc_wallet', EP_PAGES );
 
}

/*
 * Content for the new page in My Account, woocommerce_account_{ENDPOINT NAME}_endpoint
 */
add_action( 'woocommerce_account_dwwsunarc_wallet_endpoint', 'dwwsunarc_wallet_endpoint_content' );
function dwwsunarc_wallet_endpoint_content() {
	$user_id 			= get_current_user_id();
	$user_transactions 	= dwwsunarc_get_user_transactions( $user_id );
	$balance    		= get_user_meta( $user_id, 'dwwsunarc_wallet_balance', '' );
	if ( empty( $balance ) ) {
			$balance = 0;
		} else {
			$balance = number_format((float)$balance[0], 2, '.', '');
		}

	$wallet_setting 	= get_option('dwwsunarc_settings_sunarc');
	?>
	<form method="post" id="wallet_recharage">
 	<table class="shop_table shop_table_responsive my_account_orders">
 		<th colspan="2"><p><?php esc_html_e("Wallet Balance", "digital-wallet-for-woocommerce"); ?><span style="float: right;"><?php _e(get_woocommerce_currency_symbol().''.$balance); ?></span></p></th>
 		<tr>
 			<td><input id="wallet_amt" placeholder="50" type="number" name="wallet_amt" step="0.01" required><span class="amterr"></span></td>
 			<td><input type="submit" name="recharage" id="recharage" value="Recharage"></td>
 		</tr>
 	</table>
 	</form>


 	<table id="mwb_wcb_all_trans_table">
 		<caption><?php esc_html_e( 'All Transactions', 'digital-wallet-for-woocommerce' ); ?></caption>
 		<thead>
 			<tr>
 				<th><?php esc_html_e( 'S.No.', 'digital-wallet-for-woocommerce' ); ?></th>
 				<th><?php esc_html_e( 'Credit', 'digital-wallet-for-woocommerce' ); ?></th>
 				<th><?php esc_html_e( 'Debit', 'digital-wallet-for-woocommerce' ); ?></th>
 				<th><?php esc_html_e( 'Details', 'digital-wallet-for-woocommerce' ); ?></th>
 				<th><?php esc_html_e( 'Date', 'digital-wallet-for-woocommerce' ); ?></th>
 			</tr>
 		</thead>
 		<tbody>
 		<?php
 		if ( isset( $user_transactions ) && ! empty( $user_transactions ) ) { $i=1;
 			foreach ( $user_transactions as $key => $value ) {
 				$tran_id = $value->transaction_id;
 				$credit  = ( 0 != $value->credit ) ? $value->credit : '-';
 				$debit   = ( 0 != $value->debit ) ? $value->debit : '-';
 				$details = ! empty( $value->details ) ? $value->details : '-';
 				$date    = date( 'M j, Y h:i:s', strtotime( $value->date ) );
 				?>
 				<tr>
 					<td><?php echo esc_html( $i ); ?></td>
 					<td><?php echo esc_html( $credit ); ?></td>
 					<td><?php echo esc_html( $debit ); ?></td>
 					<td><?php echo esc_html( $details ); ?></td>
 					<td><?php echo esc_html( $date ); ?></td>
 				</tr>
 			<?php $i++; } ?>
 		<?php } else { ?>
 			<tr>
 				<td colspan="5"><?php esc_html_e( 'No Transactions Found', 'digital-wallet-for-woocommerce' ); ?></td>
 			</tr>
 		<?php } ?>
 		</tbody>
 		<tfoot>
 			<tr>
 				<th><?php esc_html_e( 'Id', 'digital-wallet-for-woocommerce' ); ?></th>
 				<th><?php esc_html_e( 'Credit', 'digital-wallet-for-woocommerce' ); ?></th>
 				<th><?php esc_html_e( 'Debit', 'digital-wallet-for-woocommerce' ); ?></th>
 				<th><?php esc_html_e( 'Details', 'digital-wallet-for-woocommerce' ); ?></th>
 				<th><?php esc_html_e( 'Date', 'digital-wallet-for-woocommerce' ); ?></th>
 			</tr>
 		</tfoot>
 	</table>

	<?php
 
}
/*
 * Step 4
 */
// Go to Settings > Permalinks and just push "Save Changes" button.