<?php


function dwwsunarc_cerate_wallet_product()
{
	#Create a wallet recharage product
	$post_title = 'Wallet Recharage';
   	$new_post = array(
       'post_title' => $post_title,
       'post_content' => '',
       'post_status' => 'publish',
       'post_date' => date('Y-m-d H:i:s'),
       'post_author' => '',
       'post_type' => 'product',
       'post_category' => array(0)
   	);

   	$wallet_exists = post_exists( $post_title,'','','product' );
   	if (empty($wallet_exists)) {
   		$post_id = wp_insert_post( $new_post );
   		update_option('dwwsunarc_wallet_id',$post_id);
   		update_post_meta( $post_id, '_regular_price', 50 );
   		update_post_meta( $post_id, '_price', 50 );
   		update_post_meta( $post_id, '_virtual', 'yes' );
   		update_post_meta( $post_id, '_sold_individually', 'yes' );
   		
   		$wallet_product = wc_get_product($post_id);
   		// Change the product visibility
   		$wallet_product->set_catalog_visibility('hidden');
   		// Change the product tax status
   		$wallet_product->set_tax_status('none');
   		// Save and sync the product visibility
   		$wallet_product->save();
   	}
   	else{
   		update_option('dwwsunarc_wallet_id',$wallet_exists);
   	}
   	return true;
}


function dwwsunarc_wallet_transactions_table()
{
	global $wpdb;
	$collate = $wpdb->get_charset_collate();
	$tables = "CREATE TABLE IF NOT EXISTS {$wpdb->base_prefix}dwwsunarc_wallet_transactions (
        transaction_id BIGINT UNSIGNED NOT NULL auto_increment,
        user_id BIGINT UNSIGNED NOT NULL DEFAULT 0,
        user_login varchar( 200 ) NOT NULL,
        user_email varchar( 200 ) NOT NULL,
        type varchar( 200 ) NOT NULL,
        amount DECIMAL( 10,2 ) NOT NULL,
        credit DECIMAL( 10,2 ) NOT NULL,
        debit DECIMAL( 10,2 ) NOT NULL,
        balance DECIMAL( 10,2 ) NOT NULL,
        currency varchar( 20 ) NOT NULL,
        details longtext NULL,
        deleted tinyint(1 ) NOT NULL DEFAULT 0,
        date timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY  (transaction_id ),
        KEY user_id (user_id )
    ) $collate";
	require_once ABSPATH . 'wp-admin/includes/upgrade.php';
	dbDelta( $tables );
}

/**
 * Credit Amount in wallet
 *
 * @param int    $user_id   id of the user.
 * @param float  $amount    amount in wallet.
 * @param string $details  details of transaction.
 * @param string $method  method of transaction.
 * @return int transaction id
 */
function dwwsunarc_wallet_transaction( $user_id, $amount = 0, $details = '', $method ) {
	global $wpdb;
	if ( $amount < 0 ) {
		$amount = 0;
	}
	$balance    = get_user_meta( $user_id, 'dwwsunarc_wallet_balance', '' );
	$userdata   = get_userdata( $user_id );
	$user_email = ! empty( $userdata->user_email ) ? $userdata->user_email : '';
	$user_login = ! empty( $userdata->user_login ) ? $userdata->user_login : '';
	if ( empty( $balance ) ) {
		$balance = 0;
	} else {
		$balance = $balance[0];
	}
	$credit = 0;
	$debit  = 0;
	$type   = $method;
	if ( 'credit' == $type ) {
		$credit   = $amount;
		$balance += $amount;
	} else {
		$debit    = $amount;
		$balance -= $amount;
	}

	if ( $wpdb->insert(
		"{$wpdb->base_prefix}dwwsunarc_wallet_transactions",
		apply_filters(
			'dwwsunarc_wallet_transactions_args',
			array(
				'user_id'    => $user_id,
				'user_login' => $user_login,
				'user_email' => $user_email,
				'type'       => $type,
				'amount'     => $amount,
				'credit'     => $credit,
				'debit'      => $debit,
				'balance'    => $balance,
				'currency'   => get_woocommerce_currency(),
				'details'    => $details,
				'date'       => current_time( 'mysql' ),
			),
			array( '%d', '%d', '%s', '%f', '%f', '%s', '%s', '%s' )
		)
	) ) {
		$transaction_id = $wpdb->insert_id;
		update_user_meta( $user_id, 'dwwsunarc_wallet_balance', $balance );
		return $transaction_id;
	}
}

/**
 * Get the user transactions.
 *
 * @param string $user_id id of the user whose transactions are displayed.
 */
function dwwsunarc_get_user_transactions( $user_id ) {
	global $wpdb;
	$user_transactions = $wpdb->get_results( $wpdb->prepare( 'SELECT * FROM wp_dwwsunarc_wallet_transactions WHERE user_id = %d ORDER BY transaction_id DESC;', $user_id ) );
	return $user_transactions;
}