<?php
/*
 * Plugin Name: Digital wallet for woocommerce
 * Plugin URI: https://sunarctechnologies.com/
 * Description: "Digital wallet for woocommerce" plugin will allow the user to purchase the product through the wallet system.
 * Author: SunArc
 * Author URI: https://sunarctechnologies.com/
 * Text Domain: digital-wallet-for-woocommerce 
 * Version: 1.0.4
 *
*/

if (!defined("ABSPATH"))
      exit;

if (!defined("DWWSUNARC_PLUGIN_URL"))
  define("DWWSUNARC_PLUGIN_URL", plugins_url('/', __FILE__));

 if (!defined("DWWSUNARC_PLUGIN_DIR_PATH"))
  define("DWWSUNARC_PLUGIN_DIR_PATH", plugin_dir_path(__FILE__));



register_activation_hook(__FILE__, "dwwsunarc_activation_hook");
function dwwsunarc_activation_hook() {
	if(!class_exists( 'WooCommerce' )){
	    deactivate_plugins(basename(__FILE__));
	    wp_die(__("WooCommerce is not installed/actived. it is required for this plugin to work properly. Please activate WooCommerce.", "digital-wallet-for-woocommerce"), "", array('back_link' => 1));
	}
  	else{

  		#Create table for wallet transactoins
  		dwwsunarc_wallet_transactions_table();
		#Create a wallet recharage product
    	dwwsunarc_cerate_wallet_product();

  	}
}


function dwwsunarc_include_assets() {
    wp_enqueue_style('dwwstyle', DWWSUNARC_PLUGIN_URL . '/assets/css/style.css');
    wp_enqueue_script('dwwscript', DWWSUNARC_PLUGIN_URL . '/assets/js/script.js', '', true, true);
    wp_localize_script("dwwscript","dwwsunarc_objects",array( 'ajaxurl' => admin_url("admin-ajax.php"), 'checkouturl' => wc_get_checkout_url() ));
}
add_action("wp_enqueue_scripts", "dwwsunarc_include_assets");


function dwwsunarc_check_active_first() {
    if (get_option('dwwsunarc_active_first',true) !== 1) {
    	global $wp_rewrite; 
	   //Flush the rules and tell it to write htaccess
	   $wp_rewrite->flush_rules( true );
	   update_option('dwwsunarc_active_first',1);
    }
}
add_action("init", "dwwsunarc_check_active_first");




function dwwsunarc_register_settings() {
    // Creates settings in the options table
    register_setting('dwwsunarc_settings_group', 'dwwsunarc_settings_sunarc');
}
add_action('admin_init', 'dwwsunarc_register_settings');



function dwwsunarc_plugin_menus() {
    add_menu_page("Wallet", "Wallet", "manage_options", "dwwsunarc_wallet", "dwwsunarc_wallet_callback", "dashicons-book-alt", 30);
    add_submenu_page("dwwsunarc_wallet", "Wallet Transactions", "Wallet Transactions", "manage_options", "dwwsunarc_wallet", "dwwsunarc_wallet_callback");
}
add_action("admin_menu", "dwwsunarc_plugin_menus");
  
//callback functions to menus and submenus
function dwwsunarc_wallet_callback() {
 	include_once DWWSUNARC_PLUGIN_DIR_PATH . "/admin/wallet-transactions.php";
}


# Functions for update wallet transaction and get details from DB
require_once DWWSUNARC_PLUGIN_DIR_PATH.'/functions.php';
# Wallet ttransaction option in my account
require_once DWWSUNARC_PLUGIN_DIR_PATH.'/public/wallet_transactions.php';
# Create custom payment gateway (Wallet) and processing for payment
require_once DWWSUNARC_PLUGIN_DIR_PATH.'/custom_payment_gateway.php';



#Wallet recharage from my account page via ajax
add_action("wp_ajax_dwwsunarc_wallet_ajax","dwwsunarc_wallet_ajax_handler");
function dwwsunarc_wallet_ajax_handler(){
  if($_REQUEST['param']=="dwwsunarc_wallet_recharage"){
     $wallet_id = get_option('dwwsunarc_wallet_id');
    update_post_meta( $wallet_id, '_price', sanitize_text_field($_POST['wallet_amt']) );
    global $woocommerce;
    WC()->cart->empty_cart();
    $added = WC()->cart->add_to_cart( $wallet_id );
    if ($added) {
    	echo json_encode(array("status"=>1));
    }
    else{
    	echo json_encode(array("status"=>0));
    }
  }
  wp_die();
}



#Check wallet item is in cart or not
function dwwsunarc_wallet_validate_add_cart_item( $args,$product ) {
	$in_cart = 0;
	$wallet_id = get_option('dwwsunarc_wallet_id');
	   	if ($product !== (int) $wallet_id) {
	   		foreach( WC()->cart->get_cart() as $cart_item ) {
		      $product_in_cart = $cart_item['product_id'];
		      if ( $product_in_cart == $wallet_id ){
		      	$in_cart = 1;
		      }
		   	}
	   	}
	  
	   if ( $in_cart==1 ) {
	    wc_add_notice(__('Wallet is in the Cart, please recharge or remove it first.','digital-wallet-for-woocommerce'),'error');
	    exit(wp_redirect( get_permalink($product) ));
	   }
}
add_filter( 'woocommerce_add_to_cart', 'dwwsunarc_wallet_validate_add_cart_item', 10, 5 );






function dwwsunarc_filter_woocommerce_available_payment_gateways( $available_gateways ) { 
	//Remove COD and wallet payment gateway If wallet recharge

	if (is_admin()) {
		return;
	}
	$in_cart = 0;
	$wallet_id = get_option('dwwsunarc_wallet_id');
	$cart_total = WC()->cart->total;
	$user_id = get_current_user_id();
	$balance    = get_user_meta( $user_id, 'dwwsunarc_wallet_balance', '' );
	if ( empty( $balance ) ) {
			$balance = 0;
		} else {
			$balance = $balance[0];
		}


   	foreach( WC()->cart->get_cart() as $cart_item ) {
	      $product_in_cart = $cart_item['product_id'];
	      if ( $product_in_cart == $wallet_id ){
	      	$in_cart = 1;
	      }
	   }

	if ( isset( $available_gateways['cod'] ) && $in_cart==1 )  {
		//unset( $available_gateways['cod'] );
		unset( $available_gateways['dwwsunarc_wallet_payment'] );
	}
	elseif ( !$in_cart==1 && ($cart_total > $balance) ) {
		unset( $available_gateways['dwwsunarc_wallet_payment'] );
	}

	//For checkbox ajax
	if ( isset( $_POST['post_data'] ) ) {
        parse_str( sanitize_text_field($_POST['post_data']), $post_data );
    }

    if (isset($post_data['use_wallet_balance'])) {
    	unset( $available_gateways['dwwsunarc_wallet_payment'] );
    }

    return $available_gateways; 
}; 
add_filter( 'woocommerce_available_payment_gateways', 'dwwsunarc_filter_woocommerce_available_payment_gateways', 10, 1 ); 





// Define the woocommerce_order_status_changed callback 
function dwwsunarc_action_woocommerce_order_status_changed( $order_id, $old_status, $new_status ) {
	$wallet_id 	= get_option('dwwsunarc_wallet_id');
    $order  	= wc_get_order( $order_id );
	$userid 	= $order->user_id;
	$items  	= $order->get_items();
	foreach ( $items as $item ) {
		$product_id = $item->get_product_id();
		$prod_amu   = $item->get_total();

	}

	//IF checkbox checked for wallet use
	if ( isset( $_POST['post_data'] ) ) {
	    parse_str( sanitize_text_field($_POST['post_data']), $post_data );
	}

	if (isset($post_data['use_wallet_balance'])) {
		global $woocommerce;
		$user_id = get_current_user_id();
		$balance    = get_user_meta( $user_id, 'dwwsunarc_wallet_balance', '' );
		if ( empty( $balance ) ) {
				$balance = 0;
			} else {
				$balance = $balance[0];
			}
		$description    = esc_html__( 'Wallet debited for purchase #', 'digital-wallet-for-woocommerce' ) . $order_id;
		$method         = 'debit';
		$transaction_id = dwwsunarc_wallet_transaction( $userid, $balance, $description, $method );
		if ( ! $transaction_id ) {
			wc_add_notice( __( 'Something went wrong. Please try again.', 'digital-wallet-for-woocommerce' ), 'error' );
			return false;
		}
	}


	if ( isset( $product_id ) && ! empty( $product_id ) && $product_id==$wallet_id ) {
		$statuses = array( 'processing', 'on-hold', 'pending' );
		if ( in_array( $old_status, $statuses ) && 'completed' === $new_status && $userid > 0 ) {
			$description    = esc_html__( 'Wallet credited through purchase #', 'digital-wallet-for-woocommerce' ) . $order_id;
			$method         = 'credit';
			$transaction_id = dwwsunarc_wallet_transaction( $userid, $prod_amu, $description, $method );
			if ( ! $transaction_id ) {
				wc_add_notice( __( 'Something went wrong. Please try again.', 'digital-wallet-for-woocommerce' ), 'error' );
				return false;
			}
		}

		//Change by admin (completed to other)
		if ( ($old_status== 'completed') && ('completed' !== $new_status) && $userid > 0 ) {
			$description    = esc_html__( 'Wallet debited by admin for purchase #', 'digital-wallet-for-woocommerce' ) . $order_id;
			$method         = 'debit';
			$transaction_id = dwwsunarc_wallet_transaction( $userid, $prod_amu, $description, $method );
			if ( ! $transaction_id ) {
				wc_add_notice( __( 'Something went wrong. Please try again.', 'digital-wallet-for-woocommerce' ), 'error' );
				return false;
			}
		}
	}
};
add_action( 'woocommerce_order_status_changed', 'dwwsunarc_action_woocommerce_order_status_changed', 10, 3 ); 





function dwwsunarc_payment_complete_any_payment_gateway($order_id){

	$the_order = wc_get_order( $order_id );

	// Iterating through order fee items ONLY
	foreach( $the_order->get_items('fee') as $item_id => $item_fee ){

	    // The fee name
	    $fee_name = $item_fee->get_name();

	    if ($fee_name == 'Wallet Balance:') {
	    	// The fee total amount
	    	$fee_total = $item_fee->get_total();
	    }

	    
	}

	if (isset($fee_total) && !empty($fee_total)) {
		$wallet_id 	= get_option('dwwsunarc_wallet_id');
	    $order  	= wc_get_order( $order_id );
		$userid 	= $order->user_id;
		$balance	= abs($fee_total);
		$description    = esc_html__( 'Wallet debited for purchase #', 'digital-wallet-for-woocommerce' ) . $order_id;
		$method         = 'debit';
		$transaction_id = dwwsunarc_wallet_transaction( $userid, $balance, $description, $method );
	}
	
}
add_action( 'woocommerce_payment_complete', 'dwwsunarc_payment_complete_any_payment_gateway' ); 







# Add checkbox to use wallet amount on checkout

// add_action( 'woocommerce_after_checkout_billing_form', 'dwwsunarc_wallet_checkbox_option_to_checkout' );
add_action( 'woocommerce_review_order_before_payment', 'dwwsunarc_wallet_checkbox_option_to_checkout' );
function dwwsunarc_wallet_checkbox_option_to_checkout( $checkout ) {
	
	//If wallet payment gateway is disabled
	$wallet_enable = get_option('woocommerce_dwwsunarc_wallet_payment_settings');
	if (isset($wallet_enable['enabled']) && $wallet_enable['enabled'] !=='yes') {
		return;
	}

	$wallet_id 	= get_option('dwwsunarc_wallet_id');
	$in_cart = 0;
   	foreach( WC()->cart->get_cart() as $cart_item ) {
	      $product_in_cart = $cart_item['product_id'];
	      if ( $product_in_cart == $wallet_id ){
	      	$in_cart = 1;
	      }
	}
	if ($in_cart==1) {
		return;
	}

	$user_id 	= get_current_user_id();
	$balance    = get_user_meta( $user_id, 'dwwsunarc_wallet_balance', '' );
	if ( empty( $balance ) ) {
			$balance = 0;
		} else {
			$balance = number_format((float)$balance[0], 2, '.', '');
		}

	if ($balance < 1) {
		return;
	}

	global $woocommerce;
 	$order_total = $woocommerce->cart->cart_contents_total + $woocommerce->cart->shipping_total;

 	if ($order_total < $balance) {
		return;
	}

    echo '<div id="message_fields">';
    woocommerce_form_field( 'use_wallet_balance', array(
        'type'          => 'checkbox',
        'class'         => array('use_wallet_balance form-row-wide'),

        'label'         => __('Use wallet balance('.get_woocommerce_currency_symbol().$balance.')'),
        'placeholder'   => __(''),
        )/*, $checkout->get_value( 'use_wallet_balance' )*/);
        echo '</div>';
}

//On click jquery is in script.js

add_action( 'woocommerce_cart_calculate_fees', 'dwwsunarc_adjust_wallet_amount' , 25, 1);
function dwwsunarc_adjust_wallet_amount( $cart ){
        if ( ! $_POST || ( is_admin() && ! is_ajax() ) ) {
        return;
    }

    if ( isset( $_POST['post_data'] ) ) {
        parse_str( sanitize_text_field($_POST['post_data']), $post_data );
    }

    if (isset($post_data['use_wallet_balance'])) {
    	global $woocommerce;
    	$user_id = get_current_user_id();
    	$balance    = get_user_meta( $user_id, 'dwwsunarc_wallet_balance', '' );
    	if ( empty( $balance ) ) {
    			$balance = 0;
    		} else {
    			$balance = $balance[0];
    		}
    	$total = $woocommerce->cart->cart_contents_total + $woocommerce->cart->shipping_total;
    	if ($balance < $total) {
    		$woocommerce->cart->add_fee( 'Wallet Balance:', -$balance, false );
    	}
    }

}

 


add_action( 'woocommerce_order_refunded', 'dwwsunarc_action_woocommerce_order_refunded', 10, 2 ); 
function dwwsunarc_action_woocommerce_order_refunded( $order_id, $refund_id ) 
{
  $order 		= wc_get_order($order_id);
  $order 		= $order->data;
  $userid 		= $order['customer_id'];

  $refund 		= new WC_Order_Refund( $refund_id );
  $refund_data 	= $refund->data;
  $amount 		= $refund_data['amount'];
  $reason 		= $refund_data['reason'];
  $reason 		= (!empty($reason)) ? $reason : 'Refund by Admin';

  $method       = 'credit';

  $transaction  = dwwsunarc_wallet_transaction( $userid, $amount, esc_html__($reason.' (through purchase #'.$order_id.')'), $method );
  if ( ! $transaction ) {
  	echo esc_html__('Wallet Error');exit();
  }
}



function dwwsunarc_delete_refund( $delete, $post, $force_delete ) {
	if($post->post_type=='shop_order_refund'){
		
		$order_id 	= $post->post_parent;
		$order 		= wc_get_order($order_id);
		$order 		= $order->data;
		$userid 		= $order['customer_id'];

		$refund_id 	= $post->ID;
		$refund 		= new WC_Order_Refund( $refund_id );
		$refund_data 	= $refund->data;
		$amount 		= $refund_data['amount'];
		$reason 		= 'Refund canceled by Admin';
		$method       = 'debit';
		$transaction  = dwwsunarc_wallet_transaction( $userid, $amount, esc_html__($reason.' (through purchase #'.$order_id.')'), $method );
		if ( ! $transaction ) {
			echo esc_html__('Wallet Error');exit();
		}
	}
  return $delete;  
}
add_filter('pre_delete_post', 'dwwsunarc_delete_refund', 10, 3);