<?php
/*
 * This action hook registers our PHP class as a WooCommerce payment gateway
 */
add_filter( 'woocommerce_payment_gateways', 'dwwsunarc_add_gateway_class' );
function dwwsunarc_add_gateway_class( $gateways ) {
	$gateways[] = 'Dwwsunarc_Wallet_Payment_Gateway';
	return $gateways;
}


add_action( 'plugins_loaded', 'dwwsunarc_init_gateway_class' );
function dwwsunarc_init_gateway_class() {
 
	class Dwwsunarc_Wallet_Payment_Gateway extends WC_Payment_Gateway {
 
 		/**
 		 * Class constructor, more about it in Step 3
 		 */
 		public function __construct() {
 
			$this->id = 'dwwsunarc_wallet_payment'; // payment gateway plugin ID
			$this->icon = ''; // URL of the icon that will be displayed on checkout page near your gateway name
			$this->has_fields = true; // in case you need a custom credit card form
			$this->method_title = 'Wallet';
			$this->method_description = 'Payment with wallet gateway.'; // will be displayed on the options page
		 
			// gateways can support subscriptions, refunds, saved payment methods,
			// but in this tutorial we begin with simple payments
			$this->supports = array(
				'products'
			);
		 
			// Method with all the options fields
			$this->init_form_fields();
		 
			// Load the settings.
			$this->init_settings();
			$this->title = $this->get_option( 'title' );
			$this->description = $this->get_option( 'description' );
			$this->enabled = $this->get_option( 'enabled' );
			//$this->testmode = 'yes' === $this->get_option( 'testmode' );
			//$this->private_key = $this->testmode ? $this->get_option( 'test_private_key' ) : $this->get_option( 'private_key' );
			//$this->publishable_key = $this->testmode ? $this->get_option( 'test_publishable_key' ) : $this->get_option( 'publishable_key' );
		 
			// This action hook saves the settings
			add_action( 'woocommerce_update_options_payment_gateways_' . $this->id, array( $this, 'process_admin_options' ) );
		 
			// We need custom JavaScript to obtain a token
			//add_action( 'wp_enqueue_scripts', array( $this, 'payment_scripts' ) );
		 
			// You can also register a webhook here
			// add_action( 'woocommerce_api_{webhook name}', array( $this, 'webhook' ) );
 
 		}
 
		/**
 		 * Plugin options, we deal with it in Step 3 too
 		 */
 		public function init_form_fields(){
 
			$this->form_fields = array(
					'enabled' => array(
						'title'       => 'Enable/Disable',
						'label'       => 'Enable Wallet',
						'type'        => 'checkbox',
						'description' => '',
						'default'     => 'yes'
					),
					'title' => array(
						'title'       => 'Title',
						'type'        => 'text',
						'description' => 'This controls the title which the user sees during checkout.',
						'default'     => 'Wallet',
						'desc_tip'    => true,
					),
					'description' => array(
						'title'       => 'Description',
						'type'        => 'textarea',
						'description' => 'This controls the description which the user sees during checkout.',
						'default'     => 'Pay with your wallet via our super-cool payment gateway.',
					),
					/*'testmode' => array(
						'title'       => 'Test mode',
						'label'       => 'Enable Test Mode',
						'type'        => 'checkbox',
						'description' => 'Place the payment gateway in test mode using test API keys.',
						'default'     => 'yes',
						'desc_tip'    => true,
					),
					'test_publishable_key' => array(
						'title'       => 'Test Publishable Key',
						'type'        => 'text'
					),
					'test_private_key' => array(
						'title'       => 'Test Private Key',
						'type'        => 'password',
					),
					'publishable_key' => array(
						'title'       => 'Live Publishable Key',
						'type'        => 'text'
					),
					'private_key' => array(
						'title'       => 'Live Private Key',
						'type'        => 'password'
					)*/
				);
 
	 	}


		/**
		 * Current Wallet Balance.
		 */
		public function get_icon() {
			$user_id = get_current_user_id();
			if ( $user_id > 0 ) {
				//$walletamount = get_user_meta( $customer_id, 'mwb_all_in_one_wallet', true );
				//return '<b>' . __( '[Your Amount :', 'digital-wallet-for-woocommerce' ) . ' ' . wc_price( $walletamount ) . ']</b>';
				$balance    = get_user_meta( $user_id, 'dwwsunarc_wallet_balance', '' );
				if ( empty( $balance ) ) {
						$balance = 0;
					} else {
						$balance = number_format((float)$balance[0], 2, '.', '');
					}
				return '<b>('.get_woocommerce_currency_symbol().$balance.') </b>';
			}
		}
 
		
 
		/*
		 * We're processing the payments here, everything about it is in Step 5
		 */
		public function process_payment( $order_id ) {

			global $woocommerce;
		 	
		 	$order 			= wc_get_order( $order_id );
		 	$order_total 	= $order->get_total();
		 	$user_id 		= get_current_user_id();
		 	$balance    	= get_user_meta( $user_id, 'dwwsunarc_wallet_balance', '' );
		 	if ( empty( $balance ) ) {
		 			$balance = 0;
		 		} else {
		 			$balance = $balance[0];
		 		}
			
			if ($order_total <= $balance) {
				// we need it to get any order detailes
				$order = wc_get_order( $order_id );

				$order->payment_complete();
				//$order->update_status( 'completed' );
				$order->reduce_order_stock();
				
				// some notes to customer (replace true with false to make it private)
				$order->add_order_note( 'Hey, your order is paid via wallet! Thank you!', true );
				
				// Empty cart
				$woocommerce->cart->empty_cart();

				$method         = 'debit';
				$description    = esc_html__( 'Debited through purchasing #', 'digital-wallet-for-woocommerce' ) . $order_id;
				$transaction_id = dwwsunarc_wallet_transaction( $user_id, $order_total, $description, $method );
				if ( ! $transaction_id ) {
					wc_add_notice( __( 'Something went wrong please try again.', 'digital-wallet-for-woocommerce' ), 'error' );
					wp_safe_redirect( wc_get_page_permalink( 'checkout' ) );
					exit;
				}
				
				// Redirect to the thank you page
				return array(
					'result' => 'success',
					'redirect' => $this->get_return_url( $order )
				);
			}
			else{
				wc_add_notice(__('Wallet amount is in not sufficient.','digital-wallet-for-woocommerce'),'error');
				exit(wp_redirect( wc_get_checkout_url() ));
			}
		 	
		 
			
	 	}

 	}
}