<?php

add_filter('pre_option_link_manager_enabled', '__return_true');

if (!class_exists('WP_List_Table')) {
    require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}

if (!class_exists('Dwwsunarc_Wallet_Transaction_List_Table')) {
    class Dwwsunarc_Wallet_Transaction_List_Table extends WP_List_Table {

        function __construct() {
            global $status, $page;

            //Set parent defaults
            parent::__construct(array(
                'singular'  => 'Digital wallet for woocommerce', //singular name of the listed records
                'plural'    => 'Digital wallet for woocommerce', //plural name of the listed records
                'ajax'      => false                             //does this table support ajax?
            ));
        }

        function column_default($item, $column_name) {
            switch ($column_name) {
                case 'transaction_id':
                    return  $item['transaction_id'];
                case 'details':
                    return $item['details'];
                /*case 'user_id':
                    return $item['user_id'];*/
                /*case 'user_login':
                    return $item['user_login'];*/
                case 'user_email':
                    return $item['user_email'];
                case 'amount':
                    return get_woocommerce_currency_symbol().$item['amount'];
                case 'type':
                    return ucfirst($item['type']);
                case 'date':
                    return $item['date'];
                //default:
                    //return "col name = $column_name , " . print_r($item, true); //Show the whole array for troubleshooting purposes
            }
        }

        function get_columns() {
            return $columns = array(
                'transaction_id' => __('Transaction ID'),
                'details'        => __('Reference'),
                //'user_id'      => __('User ID'),
                //'user_login'   => __('User Login'),
                'user_email'     => __('Customer'),
                'amount'         => __('Amount'),
                'type'           => __('Transaction Type'),
                'date'           => __('Date')
            );
        }

        protected function get_sortable_columns() {
            /*
             * actual sorting still needs to be done by prepare_items.
             * specify which columns should have the sort icon. 
             */
            $sortable_columns = array (
                    'transaction_id' => array( 'transaction_id', true ),
                    'user_email'     => array( 'user_email', true ),
                    'amount'         => array( 'amount', true ),
                    'type'           => array( 'type', true ),
                );
            return $sortable_columns;
        }   
      
        function prepare_items() {
            global $wpdb; //This is used only if making any database queries

               /* -- Preparing your query -- */
            $query = "SELECT * FROM {$wpdb->base_prefix}dwwsunarc_wallet_transactions";
            if (!isset($_GET["orderby"]) || !isset($_GET["order"])) {
                $query.= " ORDER BY transaction_id DESC";
            }

            /* -- Ordering parameters -- */
            //Parameters that are going to be used to order the result
            //print_r($_GET["orderby"]);die;
            $orderby = !empty($_GET["orderby"]) ? wc_clean($_GET["orderby"]) : 'ASC';
            $order = !empty($_GET["order"]) ? wc_clean($_GET["order"]) : '';
            if (!empty($orderby) & !empty($order)) {
                $query.=' ORDER BY ' . $orderby . ' ' . $order;
            }

            $totalitems = $wpdb->query($query);

            /**
             * First, lets decide how many records per page to show
             */
            $perpage = 10;

            //Which page is this?
            $paged = !empty($_GET["paged"]) ? wc_clean($_GET["paged"]) : '';
            //Page Number
            if (empty($paged) || !is_numeric($paged) || $paged <= 0) {
                $paged = 1;
            }


            //How many pages do we have in total?
            $totalpages = ceil($totalitems / $perpage);
            //adjust the query to take pagination into account
            if (!empty($paged) && !empty($perpage)) {
                $offset = ($paged - 1) * $perpage;
                $query.=' LIMIT ' . (int) $offset . ',' . (int) $perpage;
            }

            /* -- Register the pagination -- */
            $this->set_pagination_args(array(
                "total_items" => $totalitems,
                "total_pages" => $totalpages,
                "per_page"    => $perpage,
            ));

            $columns  = $this->get_columns();
            $sortable = $this->get_sortable_columns();
            $hidden   = array();

            $this->_column_headers = array($columns, $hidden, $sortable);
            $this->items = $wpdb->get_results($query, ARRAY_A);
        }

    }
}


//Create an instance of our package class...
$testListTable = new Dwwsunarc_Wallet_Transaction_List_Table();
//Fetch, prepare, sort, and filter our data...
$testListTable->prepare_items();
?>
<div class="wrap">

    <div id="icon-users" class="icon32"><br/></div>
    <h2><?php _e('Wallet Transactions', 'digital-wallet-for-woocommerce'); ?></h2>       

    <!-- Forms are NOT created automatically, so you need to wrap the table in one to use features like bulk actions -->
    <form id="movies-filter" method="get">
        <!-- For plugins, we also need to ensure that the form posts back to our current page -->
        <input type="hidden" name="page" value="<?php echo esc_html($_REQUEST['page']); ?>" />
        <!-- Now we can render the completed list table -->
        <?php $testListTable->display() ?>
    </form>

</div>
