jQuery(document).ready(function () {
    jQuery('.as-signature-canvas').each(function () {
        const canvas = jQuery(this);
        const wrapper = canvas.closest('.as-signature-wrapper');
        const input = wrapper.find('input[type="hidden"]');
        const clearBtn = wrapper.find('.as-signature-clear');

        const bg = canvas.attr('data-backcolor') || '#ffffff';
        const penColor = canvas.attr('data-color') || '#000000';
        canvas.css('background-color', bg);

        const canvasElement = this;
        const signaturePad = new SignaturePad(canvasElement, {
            penColor: penColor,
            backgroundColor: bg
        });

        const updateInput = function () {
            if (!signaturePad.isEmpty()) {
                input.val(signaturePad.toDataURL('image/png'));
            }
        };

        jQuery(canvasElement).on('mouseup touchend', updateInput);

        clearBtn.on('click', function () {
            signaturePad.clear();
            input.val('');
        });
    });
});
