<?php
namespace DigitalProductPassport;

if (!defined('ABSPATH')) { exit; }

class Privacy {
    public static function init() {
        add_action('admin_init', [__CLASS__, 'add_privacy_policy_content']);
    }

    /**
     * Registers Privacy Policy guidance so site owners can include
     * accurate information via Tools > Privacy.
     */
    public static function add_privacy_policy_content() {
        if (!function_exists('wp_add_privacy_policy_content')) {
            return;
        }

        $content = wp_kses_post(
            __('<p><strong>Digital Product Passport</strong> stores Digital Product Passport (DPP) JSON as post meta and renders it on the front end. The plugin itself:</p><ul><li>does not set cookies;</li><li>does not log or track visitors;</li><li>does not send data to external services;</li><li>does not create user profiles.</li></ul><p>Any personal data included in the DPP JSON (for example, a contact person name or email in manufacturer details) is authored and controlled by the site owner. Ensure you have a lawful basis to publish such data and avoid including personal data where not necessary.</p><p>DPP JSON is stored as post meta and retained until the related content is edited or deleted. The JSON is displayed publicly wherever the viewer is embedded or the post is publicly accessible.</p><p>Developers can filter or redact fields before display using the <code>digital_product_passport_viewer_data</code> filter.</p>',
               'digital-product-passport')
        );

        wp_add_privacy_policy_content(
            __('Digital Product Passport', 'digital-product-passport'),
            $content
        );
    }
}
