<?php
namespace DigitalProductPassport;

if (!defined('ABSPATH')) { exit; }

class Plugin {
    public static function init() {
        // Register asset handles early so other components can reference them
        add_action('init', [__CLASS__, 'register_assets']);
    }

    public static function register_assets() {
        // Base paths
        $base_url = plugin_dir_url(DIGITAL_PRODUCT_PASSPORT_PLUGIN_FILE) . 'assets/';
        // Note: PHP translations are loaded just-in-time (WP 4.6+). Script translations are registered below.

        // CSS
        wp_register_style(
            'dpp-viewer',
            $base_url . 'css/viewer.css',
            [],
            '0.1.0'
        );
        // Admin (meta box) CSS
        wp_register_style(
            'dpp-admin',
            $base_url . 'css/admin.css',
            [],
            '0.1.0'
        );
        // Classic editor admin CSS (placeholder styling)
        wp_register_style(
            'dpp-classic',
            $base_url . 'css/classic.css',
            [],
            '0.1.0'
        );

        // Viewer JS (defer for non-blocking load)
        wp_register_script(
            'dpp-viewer',
            $base_url . 'js/viewer.js',
            ['wp-i18n'],
            '0.1.0',
            [
                'in_footer' => true,
                'strategy'  => 'defer',
            ]
        );
        if (function_exists('wp_set_script_translations')) {
            wp_set_script_translations('dpp-viewer', 'digital-product-passport');
        }

        // Editor block JS (defer; WP will adjust strategy if needed)
        wp_register_script(
            'dpp-block',
            $base_url . 'js/block.js',
            // Include modern block editor handle for useBlockProps support
            ['wp-blocks','wp-element','wp-i18n','wp-components','wp-block-editor'],
            '0.1.0',
            [
                'in_footer' => true,
                'strategy'  => 'defer',
            ]
        );
        if (function_exists('wp_set_script_translations')) {
            wp_set_script_translations('dpp-block', 'digital-product-passport');
        }

        // Admin (meta box) JS (defer)
        wp_register_script(
            'dpp-admin',
            $base_url . 'js/admin.js',
            // Load after Code Editor when available
            ['code-editor','wp-i18n'],
            '0.1.0',
            [
                'in_footer' => true,
                'strategy'  => 'defer',
            ]
        );
        if (function_exists('wp_set_script_translations')) {
            wp_set_script_translations('dpp-admin', 'digital-product-passport');
        }

        // Classic editor: shortcode view placeholder (defer)
        wp_register_script(
            'dpp-classic-view',
            $base_url . 'js/mce-view-dpp.js',
            // No hard dependency on 'mce-view'; script polls for wp.mce.views
            ['jquery','wp-i18n'],
            '0.1.0',
            [
                'in_footer' => true,
                'strategy'  => 'defer',
            ]
        );
        if (function_exists('wp_set_script_translations')) {
            wp_set_script_translations('dpp-classic-view', 'digital-product-passport');
        }
    }
}
