<?php
namespace DigitalProductPassport;

if (!defined('ABSPATH')) { exit; }

class Classic_Editor {
    public static function init() {
        // Add TinyMCE button for classic editor
        add_action('admin_init', [__CLASS__, 'register_mce_button']);
        // Enqueue ThickBox and render modal only on post editor screens
        add_action('admin_enqueue_scripts', [__CLASS__, 'enqueue_assets']);
        add_action('admin_footer', [__CLASS__, 'render_modal']);
    }

    public static function register_mce_button() {
        if (!current_user_can('edit_posts') && !current_user_can('edit_pages')) {
            return;
        }
        if (get_user_option('rich_editing') !== 'true') {
            return;
        }

        add_filter('mce_external_plugins', [__CLASS__, 'mce_plugin']);
        add_filter('mce_buttons', [__CLASS__, 'mce_button']);
    }

    public static function mce_plugin($plugins) {
        $plugins['dpp_viewer'] = plugins_url('../assets/js/tinymce-dpp.js', __FILE__);
        return $plugins;
    }

    public static function mce_button($buttons) {
        $buttons[] = 'dpp_viewer';
        return $buttons;
    }

    public static function enqueue_assets($hook) {
        // Only on post edit screens
        if (!in_array($hook, ['post.php', 'post-new.php'], true)) {
            return;
        }
        // Core ThickBox modal
        add_thickbox();
        // Ensure i18n library is available for TinyMCE plugin strings
        if (function_exists('wp_enqueue_script')) { wp_enqueue_script('wp-i18n'); }
        // Ensure Dashicons are available for the placeholder icon
        wp_enqueue_style('dashicons');
        // Revert to plain shortcode text in the Visual tab: do not enqueue the wp.mce view script
        // wp_enqueue_style('dpp-classic'); // not needed when rendering as text
        // wp_enqueue_script('dpp-classic-view'); // disable placeholder view
    }

    public static function render_modal() {
        $screen = function_exists('get_current_screen') ? get_current_screen() : null;
        if (!$screen || !in_array($screen->base, ['post', 'post-new'], true)) {
            return;
        }
        ?>
        <div id="dpp-tb-modal" style="display:none" class="dpp-tb-modal" data-title="<?php echo esc_attr__('Insert Digital Product Passport', 'digital-product-passport'); ?>">
            <div class="dpp-modal-wrap">
                <h2 style="margin-top:0;"><?php echo esc_html__('Insert Digital Product Passport', 'digital-product-passport'); ?></h2>
                <p class="description" style="margin-bottom:12px;">
                    <?php echo esc_html__('Configure the viewer. It will use the JSON saved in the Digital Product Passport meta box on this screen.', 'digital-product-passport'); ?>
                </p>

                <table class="form-table" role="presentation" style="margin-top:0;">
                    <tbody>
                        <tr>
                            <th scope="row"><label for="dpp-modal-title"><?php echo esc_html__('Title', 'digital-product-passport'); ?></label></th>
                            <td>
                                <input type="text" class="regular-text" id="dpp-modal-title" placeholder="<?php echo esc_attr__('Optional heading', 'digital-product-passport'); ?>">
                            </td>
                        </tr>
                        <tr>
                            <th scope="row"><?php echo esc_html__('Start View', 'digital-product-passport'); ?></th>
                            <td>
                                <fieldset>
                                    <label><input type="radio" name="dpp-modal-view" value="html" checked> <?php echo esc_html__('HTML', 'digital-product-passport'); ?></label>
                                    &nbsp;&nbsp;
                                    <label><input type="radio" name="dpp-modal-view" value="json"> <?php echo esc_html__('JSON', 'digital-product-passport'); ?></label>
                                    <p class="description" style="margin-top:6px;"><?php echo esc_html__('Choose which tab is active by default.', 'digital-product-passport'); ?></p>
                                </fieldset>
                            </td>
                        </tr>
                        
                    </tbody>
                </table>

                <p class="submit">
                    <button type="button" class="button button-primary" id="dpp-modal-insert"><?php echo esc_html__('Save & Insert', 'digital-product-passport'); ?></button>
                    <button type="button" class="button" id="dpp-modal-cancel"><?php echo esc_html__('Cancel', 'digital-product-passport'); ?></button>
                </p>
            </div>
        </div>
        <?php
    }
}
