<?php
namespace DigitalProductPassport;

if (!defined('ABSPATH')) { exit; }

class Block {
    public static function init() {
        add_action('init', [__CLASS__, 'register_block']);
        add_action('enqueue_block_editor_assets', [__CLASS__, 'enqueue_editor_assets']);
    }

    public static function register_block() {
        register_block_type('dpp/viewer', [
            'api_version' => 2,
            'attributes' => [
                'json' => [ 'type' => 'string', 'default' => '' ],
                'title' => [ 'type' => 'string', 'default' => '' ],
                'show_raw' => [ 'type' => 'boolean', 'default' => false ], // deprecated
                'view' => [ 'type' => 'string', 'default' => 'html' ],
                // Viewer configuration
                'limit' => [ 'type' => 'string', 'default' => '0' ],
                'include' => [ 'type' => 'string', 'default' => '' ],
                // Not a WP_Query arg; used only for front-end filtering
                'exclude' => [ 'type' => 'string', 'default' => '' ], // phpcs:ignore WordPressVIPMinimum.Performance.WPQueryParams.PostNotIn_exclude
                'order' => [ 'type' => 'string', 'default' => '' ],
                'more_label' => [ 'type' => 'string', 'default' => '' ],
                'less_label' => [ 'type' => 'string', 'default' => '' ],
            ],
            'render_callback' => function ($attributes, $content, $block) {
                // Reuse shortcode rendering logic to keep output consistent
                $view = isset($attributes['view']) ? $attributes['view'] : 'html';
                // Back-compat: show_raw=true forces raw view
                if (!empty($attributes['show_raw'])) { $view = 'raw'; }
                return Shortcode::render([
                    'json' => isset($attributes['json']) ? $attributes['json'] : '',
                    'view' => $view,
                    'title' => isset($attributes['title']) ? $attributes['title'] : '',
                    'limit' => isset($attributes['limit']) ? $attributes['limit'] : '0',
                    'include' => isset($attributes['include']) ? $attributes['include'] : '',
                    // Not a WP_Query arg; forwarded to front-end as data-exclude
                    'exclude' => isset($attributes['exclude']) ? $attributes['exclude'] : '', // phpcs:ignore WordPressVIPMinimum.Performance.WPQueryParams.PostNotIn_exclude
                    'order' => isset($attributes['order']) ? $attributes['order'] : '',
                    'more_label' => isset($attributes['more_label']) ? $attributes['more_label'] : '',
                    'less_label' => isset($attributes['less_label']) ? $attributes['less_label'] : '',
                ]);
            },
            'style' => 'dpp-viewer',
            'editor_script' => 'dpp-block',
        ]);
    }

    public static function enqueue_editor_assets() {
        wp_enqueue_style('dpp-viewer');
    }
}
