<?php
/**
 * Plugin Name: Digital Product Passport
 * Description: Display a Digital Product Passport (JSON or human-readable) via shortcode or block. Paste JSON on posts, pages, or products and render anywhere.
 * Version: 0.1.0
 * Author: PluginWave
 * Text Domain: digital-product-passport
 * Domain Path: /languages
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

if (!defined('ABSPATH')) {
    exit;
}

define('DIGITAL_PRODUCT_PASSPORT_PLUGIN_FILE', __FILE__);
define('DIGITAL_PRODUCT_PASSPORT_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('DIGITAL_PRODUCT_PASSPORT_PLUGIN_URL', plugin_dir_url(__FILE__));

// Autoload simple include files
require_once DIGITAL_PRODUCT_PASSPORT_PLUGIN_DIR . 'includes/class-dpp-plugin.php';
require_once DIGITAL_PRODUCT_PASSPORT_PLUGIN_DIR . 'includes/class-dpp-metabox.php';
require_once DIGITAL_PRODUCT_PASSPORT_PLUGIN_DIR . 'includes/class-dpp-shortcode.php';
require_once DIGITAL_PRODUCT_PASSPORT_PLUGIN_DIR . 'includes/class-dpp-block.php';
require_once DIGITAL_PRODUCT_PASSPORT_PLUGIN_DIR . 'includes/class-dpp-classic-editor.php';
require_once DIGITAL_PRODUCT_PASSPORT_PLUGIN_DIR . 'includes/class-dpp-privacy.php';

add_action('plugins_loaded', function () {
    // Core boot
    \DigitalProductPassport\Plugin::init();
    \DigitalProductPassport\MetaBox::init();
    \DigitalProductPassport\Shortcode::init();
    \DigitalProductPassport\Block::init();
    \DigitalProductPassport\Classic_Editor::init();
    \DigitalProductPassport\Privacy::init();
});
