/* TinyMCE plugin: DPP Viewer button for Classic Editor
   - Avoids embedding JSON in content
   - Saves JSON to the meta box (#dpp_json)
   - Exposes a global opener for the MCE view placeholder
*/
(function(){
  function t(s){
    try { return (window.wp && wp.i18n && typeof wp.i18n.__ === 'function') ? wp.i18n.__(s, 'digital-product-passport') : s; }
    catch(e){ return s; }
  }
  function $(sel, ctx){ return (ctx||document).querySelector(sel); }
  function $all(sel, ctx){ return Array.prototype.slice.call((ctx||document).querySelectorAll(sel)); }

  function escAttr(str){
    return String(str).replace(/["&<>]/g, function(s){ return ({'"':'&quot;','&':'&amp;','<':'&lt;','>':'&gt;'}[s]); });
  }

  function setFields(values){
    if (!values) values = {};
    var t = $('#dpp-modal-title'); if (t) t.value = values.title || '';
    var view = values.view || 'html';
    var vHtml = $('input[name="dpp-modal-view"][value="html"]');
    var vJson = $('input[name="dpp-modal-view"][value="json"]');
    if (vHtml && vJson) {
      if (view === 'json') { vJson.checked = true; vHtml.checked = false; }
      else { vHtml.checked = true; vJson.checked = false; }
    }
  }

  function collectValues(){
    var title = ($('#dpp-modal-title') || {}).value || '';
    var viewSel = $('input[name="dpp-modal-view"]:checked');
    var view = viewSel ? viewSel.value : 'html';
    return { title: title.trim(), view: (view || 'html') };
  }

  function openModalWithThickbox(editor, prefill){
    var modal = document.getElementById('dpp-tb-modal');
    var title = (modal && modal.getAttribute('data-title')) || t('Insert Digital Product Passport');
    if (typeof window.tb_show === 'function') {
      window.tb_show(title, '#TB_inline?inlineId=dpp-tb-modal&width=720&height=360');
      // Pre-fill fields shortly after open
      setTimeout(function(){
        try {
          setFields(prefill || {});
        } catch(e){}
      }, 0);
    }
  }

  // Only ever insert the shortcode wrapper; never embed JSON in content
  function buildShortcodeNoContent(values){
    var attrs = [];
    if (values.title) attrs.push('title="' + escAttr(values.title) + '"');
    if (values.view) attrs.push('view="' + escAttr(values.view) + '"');
    var open = '[digital_product_passport' + (attrs.length ? ' ' + attrs.join(' ') : '') + ']';
    return open;
  }

  // Bind modal buttons only once
  function bindModalButtons(editor){
    if (bindModalButtons._bound) return; bindModalButtons._bound = true;
    document.addEventListener('click', function(e){
      var t = e.target;
      if (!t) return;
      if (t.id === 'dpp-modal-insert') {
        e.preventDefault();
        var values = collectValues();

        var editing = !!(window.DPPClassicEditor && window.DPPClassicEditor._editing);
        if (window.DPPClassicEditor) { window.DPPClassicEditor._editing = false; }
        if (!editing) {
          var sc = buildShortcodeNoContent(values);
          if (editor && typeof editor.insertContent === 'function') {
            editor.insertContent(sc);
          } else if (typeof window.send_to_editor === 'function') {
            window.send_to_editor(sc);
          }
        }
        if (typeof window.tb_remove === 'function') window.tb_remove();
      } else if (t.id === 'dpp-modal-cancel') {
        e.preventDefault();
        if (typeof window.tb_remove === 'function') window.tb_remove();
      }
    });
  }

  // Public API for the placeholder view
  window.DPPClassicEditor = {
    open: function(prefill){
      var editorId = (window.wpActiveEditor || (document.activeElement && document.activeElement.id)) || '';
      var ed = (window.tinymce && window.tinymce.get) ? window.tinymce.get(editorId) : null;
      bindModalButtons(ed);
      openModalWithThickbox(ed, prefill || {});
    }
  };

  if (typeof window.tinymce !== 'undefined') {
    window.tinymce.PluginManager.add('dpp_viewer', function(editor /*, url*/){
      // Toolbar button
      editor.addButton('dpp_viewer', {
        text: t('DPP Viewer'),
        tooltip: t('Insert Digital Product Passport'),
        onclick: function(){
          bindModalButtons(editor);
          openModalWithThickbox(editor, {});
        }
      });
      // Menu item (for TinyMCE menu bar)
      editor.addMenuItem('dpp_viewer', {
        text: t('DPP Viewer'),
        context: 'insert',
        onclick: function(){
          bindModalButtons(editor);
          openModalWithThickbox(editor, {});
        }
      });
      return {
        getMetadata: function(){ return { name: t('DPP Viewer'), url: '' }; }
      };
    });
  }
})();
