(function(){
  function t(s){
    try { return (window.wp && wp.i18n && typeof wp.i18n.__ === 'function') ? wp.i18n.__(s, 'digital-product-passport') : s; }
    catch(e){ return s; }
  }
  function esc(s){
    return String(s).replace(/[&<>"']/g, function(c){
      switch (c) {
        case '&': return '&amp;';
        case '<': return '&lt;';
        case '>': return '&gt;';
        case '"': return '&quot;';
        case "'": return '&#39;';
        default: return c;
      }
    });
  }

  function openModal(prefill){
    try {
      if (window.DPPClassicEditor) { window.DPPClassicEditor._editing = true; }
      if (window.DPPClassicEditor && typeof window.DPPClassicEditor.open === 'function') {
        window.DPPClassicEditor.open(prefill || {});
      }
    } catch(e){}
  }

  function bindIframeClicks(){
    if (!window.tinymce || !tinymce.editors) return;
    (tinymce.editors || []).forEach(function(ed){
      try {
        if (!ed || typeof ed.getDoc !== 'function') return;
        if (ed._dppClicksBound) return; // bind once per editor instance
        var doc = ed.getDoc();
        if (!doc) return;
        doc.addEventListener('click', function(e){
          var t = e.target;
          if (!t) return;
          var el = t.closest ? t.closest('.dpp-shortcode-placeholder') : null;
          if (!el) return;
          e.preventDefault();
          var prefill = {};
          var raw = el.getAttribute('data-prefill');
          if (raw) { try { prefill = JSON.parse(raw); } catch(_){} }
          openModal(prefill);
        });
        ed._dppClicksBound = true;
      } catch(_){}
    });
  }

  function register(){
    if (!window.wp || !wp.mce || !wp.mce.views) return false;
    function registerTag(tag){
      wp.mce.views.register(tag, {
      initialize: function(){ this.render(); },
      getHtml: function(){
        var attrs = (this.shortcode && this.shortcode.attrs && this.shortcode.attrs.named) || {};
        var prefill = { title: attrs.title || '', view: attrs.view || 'html' };
        var label = t('Digital Product Passport');
        var hint = t('Click to edit');
        var data = esc(JSON.stringify(prefill));
        // Block-level wrapper sized for reliable layout inside wpview
        var outer = 'display:block;width:100%;min-height:120px;height:120px;box-sizing:border-box;';
        var box = 'display:flex;flex-direction:column;align-items:center;justify-content:center;width:100%;height:100%;border:1px solid #cbd5e1;background:#e5e7eb;color:#0f172a;border-radius:6px;box-sizing:border-box;cursor:pointer;overflow:hidden;text-align:center;padding:8px 12px;';
        var iconWrap = 'margin:0 0 6px;line-height:0;';
        var titleStyle = 'font-weight:600;margin:0 0 2px;';
        var hintStyle = 'font-size:12px;color:#475569;margin:0;';
        var iconSvg = '' +
          '<svg width="28" height="28" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">' +
            '<rect x="3" y="3" width="18" height="18" rx="2" ry="2" stroke="#334155" stroke-width="1.5" fill="#f1f5f9"/>' +
            '<path d="M7 8h10M7 12h10M7 16h6" stroke="#334155" stroke-width="1.5" stroke-linecap="round"/>' +
          '</svg>';
        return ''+
          '<div class="dpp-shortcode-placeholder" data-prefill="' + data + '" tabindex="0" role="button" aria-label="' + esc(label + ' (' + hint + ')') + '" style="' + outer + '">' +
            '<div class="dpp-shortcode-inner" style="' + box + '">' +
              '<div class="dpp-shortcode-icon" style="' + iconWrap + '">' + iconSvg + '</div>' +
              '<div class="dpp-shortcode-title" style="' + titleStyle + '">' + esc(label) + '</div>' +
              '<div class="dpp-shortcode-hint" style="' + hintStyle + '">' + esc(hint) + '</div>' +
            '</div>' +
          '</div>';
      },
      edit: function(text, update){
        var attrs = (this.shortcode && this.shortcode.attrs && this.shortcode.attrs.named) || {};
        openModal({ title: attrs.title || '', view: attrs.view || 'html' });
      },
      render: function(){ this.setContent(this.getHtml()); }
      });
    }

    // Register views for both tags (new and legacy)
    registerTag('digital_product_passport');
    registerTag('dpp');

    // Parent document click (non-iframe locations)
    if (!register._boundParent) {
      register._boundParent = true;
      document.addEventListener('click', function(e){
        var t = e.target;
        if (!t) return;
        var box = t.closest ? t.closest('.dpp-shortcode-placeholder') : null;
        if (!box) return;
        e.preventDefault();
        try {
          var prefill = {};
          var raw = box.getAttribute('data-prefill');
          if (raw) prefill = JSON.parse(raw);
          openModal(prefill);
        } catch(err){}
      });
    }

    // Proactively bind clicks inside TinyMCE iframes (no jQuery dependency)
    bindIframeClicks();
    var attempts = 0;
    var iv = setInterval(function(){
      attempts++;
      bindIframeClicks();
      if (attempts > 40) clearInterval(iv);
    }, 250);

    try { if (wp.mce && wp.mce.views && typeof wp.mce.views.refresh === 'function') { wp.mce.views.refresh(); } } catch(e){}
    return true;
  }

  // Wait until wp.mce.views is available
  (function wait(){
    if (register()) return;
    var tries = 0;
    var iv = setInterval(function(){
      tries++;
      if (register() || tries > 40) { clearInterval(iv); }
    }, 125);
  })();
})();
