/* global wp */
(function(wp){
  const { registerBlockType } = wp.blocks;
  const { __ } = wp.i18n;
  const { TextareaControl, TextControl, ToggleControl, PanelBody, SelectControl } = wp.components;
  const { InspectorControls, useBlockProps } = (wp.blockEditor || wp.editor);
  const el = wp.element.createElement;

  registerBlockType('dpp/viewer', {
    title: __('Digital Product Passport', 'digital-product-passport'),
    icon: 'feedback',
    category: 'widgets',
    supports: { html: false },
    attributes: {
      json: { type: 'string', default: '' },
      title: { type: 'string', default: '' },
      show_raw: { type: 'boolean', default: false }, // deprecated
      view: { type: 'string', default: 'html' },
    },
    edit: function(props){
      const { attributes, setAttributes } = props;
      // Ensure proper block wrapper for selection/move/delete
      const blockProps = useBlockProps ? useBlockProps({ className: 'dpp-editor' }) : { className: 'dpp-editor' };
      // Dynamic JSON validation help text
      var helpText;
      if ((attributes.json || '').trim()) {
        try { JSON.parse(attributes.json); helpText = __('Valid JSON', 'digital-product-passport'); }
        catch(e) { helpText = __('Invalid JSON', 'digital-product-passport'); }
      } else {
        helpText = __('Paste valid JSON. Leave empty to use the post\'s stored DPP JSON.', 'digital-product-passport');
      }
      return el('div', blockProps, [
        el(InspectorControls, {}, [
          el(PanelBody, { title: __('Settings', 'digital-product-passport'), initialOpen: true }, [
            el(TextControl, {
              label: __('Title (optional)', 'digital-product-passport'),
              value: attributes.title,
              onChange: (v) => setAttributes({ title: v })
            }),
            el(SelectControl, {
              label: __('Default View', 'digital-product-passport'),
              value: (attributes.view === 'raw' ? 'json' : attributes.view), // map legacy 'raw' to 'json' in UI
              options: [
                { label: __('HTML (Accordion)', 'digital-product-passport'), value: 'html' },
                { label: __('JSON', 'digital-product-passport'), value: 'json' },
              ],
              onChange: (v) => setAttributes({ view: v })
            }),
            el(ToggleControl, {
              label: __('Back-compat: Force Raw (overrides Default View)', 'digital-product-passport'),
              checked: !!attributes.show_raw,
              onChange: (v) => setAttributes({ show_raw: v })
            }),
          ])
        ]),
        el('p', {}, __('If JSON is empty, this block will display the post\'s saved Digital Product Passport JSON (from the meta box).', 'digital-product-passport')),
        el(TextareaControl, {
          label: __('JSON (optional, overrides meta)', 'digital-product-passport'),
          help: helpText,
          value: attributes.json,
          onChange: (v) => setAttributes({ json: v })
        }),
        el('div', { className: 'dpp-viewer' }, [
          el('div', { className: 'dpp-toolbar dpp-tabs', role: 'tablist', 'aria-label': __('Digital Product Passport view', 'digital-product-passport') }, [
            el('button', { type: 'button', className: 'dpp-tab dpp-tab-html', role: 'tab', 'aria-selected': 'true' }, __('HTML', 'digital-product-passport')),
            el('button', { type: 'button', className: 'dpp-tab dpp-tab-raw', role: 'tab', 'aria-selected': 'false' }, __('JSON', 'digital-product-passport')),
          ]),
          el('div', { className: 'dpp-html' }, __('Preview appears on the front end.', 'digital-product-passport')),
        ])
      ]);
    },
    save: function(){
      // Dynamic render via PHP
      return null;
    }
  });
})(window.wp);

