// JSON CodeMirror + formatting + validation for the DPP meta box
(function(){
  function t(s){
    try { return (window.wp && wp.i18n && typeof wp.i18n.__ === 'function') ? wp.i18n.__(s, 'digital-product-passport') : s; }
    catch(e){ return s; }
  }
  function $(sel, ctx){ return (ctx||document).querySelector(sel); }
  function create(tag, props){ var el=document.createElement(tag); if(props){ Object.keys(props).forEach(function(k){ el[k]=props[k]; }); } return el; }
  function setText(el, text){ if(el) el.textContent = text; }

  function init(){
    var textarea = $('#dpp_json');
    if (!textarea) return;

    // Initialize WordPress Code Editor (CodeMirror) if available
    var cm = null;
    try {
      if (window.wp && wp.codeEditor && typeof wp.codeEditor.initialize === 'function') {
        var settings = (window.dppAdminCodeEditorSettings || { codemirror: { mode: 'application/json', indentUnit: 2, tabSize: 2, lineNumbers: true, autoCloseBrackets: true, matchBrackets: true } });
        var ed = wp.codeEditor.initialize('dpp_json', settings);
        if (ed && ed.codemirror) {
          cm = ed.codemirror;
        }
      }
    } catch(e) { /* noop */ }

    // Validation note element (prefer markup-provided span inside actions)
    var note = document.querySelector('.dpp-metabox .dpp-json-validation-note');
    var actions = document.querySelector('.dpp-metabox .dpp-actions');
    if (!note) {
      note = create('span');
      note.className = 'dpp-json-validation-note';
      if (actions) {
        actions.insertAdjacentElement('afterbegin', note);
      } else {
        textarea.insertAdjacentElement('afterend', note);
      }
    }

    function getValue(){ return cm ? cm.getValue() : (textarea.value || ''); }
    function setValue(v){ if (cm) { cm.setValue(v); cm.refresh(); } else { textarea.value = v; } }

    function update(){
      var v = (getValue() || '').trim();
      if (!v){ setText(note, ''); note.style.display='none'; note.classList.remove('ok','err'); return; }
      note.style.display='block';
      try {
        JSON.parse(v);
        setText(note, t('Valid JSON'));
        note.classList.remove('err');
        note.classList.add('ok');
      } catch(e){
        setText(note, t('Invalid JSON'));
        note.classList.remove('ok');
        note.classList.add('err');
      }
    }

    // Wire up change listeners
    if (cm) { cm.on('change', update); } else { textarea.addEventListener('input', update); }

    // Add Format button
    var formatBtn = $('#dpp_json_format_btn');
    if (!formatBtn) {
      // Back-compat: insert a button, prefer inside actions wrapper if present
      formatBtn = create('button', { type: 'button' });
      formatBtn.className = 'button button-secondary';
      formatBtn.id = 'dpp_json_format_btn';
      setText(formatBtn, t('Format JSON'));
      if (actions) {
        actions.insertAdjacentElement('beforeend', formatBtn);
      } else {
        note.insertAdjacentElement('afterend', formatBtn);
      }
    }

    formatBtn.addEventListener('click', function(){
      var raw = getValue();
      if (!raw || !raw.trim()) return;
      try {
        var obj = JSON.parse(raw);
        var pretty = JSON.stringify(obj, null, 2);
        setValue(pretty);
        update();
      } catch(e) {
        // keep current value; show invalid message
        setText(note, t('Invalid JSON'));
        note.classList.remove('ok');
        note.classList.add('err');
        note.style.display = 'block';
      }
    });

    // Initial state
    update();
  }

  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', init);
  } else { init(); }
})();
