<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://wordpress.org/plugins/dh-rename-uploaded-files/
 * @since      1.0.0
 *
 * @package    dh-rename-uploaded-files
 * @subpackage dh-rename-uploaded-files/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    dh-rename-uploaded-files
 * @subpackage dh-rename-uploaded-files/public
 * @author     Your Name <email@example.com>
 */
class DH_Rename_Uploaded_Files_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $DH_Rename_Uploaded_Files    The ID of this plugin.
	 */
	private $DH_Rename_Uploaded_Files;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $DH_Rename_Uploaded_Files       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $DH_Rename_Uploaded_Files, $version ) {

		$this->DH_Rename_Uploaded_Files = $DH_Rename_Uploaded_Files;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in DH_Rename_Uploaded_Files_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The DH_Rename_Uploaded_Files_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->DH_Rename_Uploaded_Files, plugin_dir_url( __FILE__ ) . 'css/dh-rename-uploaded-files-public.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in DH_Rename_Uploaded_Files_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The DH_Rename_Uploaded_Files_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->DH_Rename_Uploaded_Files, plugin_dir_url( __FILE__ ) . 'js/dh-rename-uploaded-files-public.js', array( 'jquery' ), $this->version, false );

	}

}
