<?php

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       https://wordpress.org/plugins/dh-rename-uploaded-files/
 * @since      1.0.0
 *
 * @package    dh-rename-uploaded-files
 * @subpackage dh-rename-uploaded-files/includes
 */

/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.0.0
 * @package    dh-rename-uploaded-files
 * @subpackage dh-rename-uploaded-files/includes
 * @author     Your Name <email@example.com>
 */
class DH_Rename_Uploaded_Files {

	/**
	 * The loader that's responsible for maintaining and registering all hooks that power
	 * the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      DH_Rename_Uploaded_Files_Loader    $loader    Maintains and registers all hooks for the plugin.
	 */
	protected $loader;

	/**
	 * The unique identifier of this plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $DH_Rename_Uploaded_Files    The string used to uniquely identify this plugin.
	 */
	protected $DH_Rename_Uploaded_Files;

	/**
	 * The current version of the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $version    The current version of the plugin.
	 */
	protected $version;

	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function __construct() {
		if ( defined( 'DH_Rename_Uploaded_Files_VERSION' ) ) {
			$this->version = DH_Rename_Uploaded_Files_VERSION;
		} else {
			$this->version = '1.0.0';
		}
		$this->DH_Rename_Uploaded_Files = 'dh-rename-uploaded-files';

		$this->load_dependencies();
		$this->set_locale();
		$this->define_admin_hooks();
		$this->define_public_hooks();

	}

	/**
	 * Load the required dependencies for this plugin.
	 *
	 * Include the following files that make up the plugin:
	 *
	 * - DH_Rename_Uploaded_Files_Loader. Orchestrates the hooks of the plugin.
	 * - DH_Rename_Uploaded_Files_i18n. Defines internationalization functionality.
	 * - DH_Rename_Uploaded_Files_Admin. Defines all hooks for the admin area.
	 * - DH_Rename_Uploaded_Files_Public. Defines all hooks for the public side of the site.
	 *
	 * Create an instance of the loader which will be used to register the hooks
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function load_dependencies() {

		/**
		 * The class responsible for orchestrating the actions and filters of the
		 * core plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-dh-rename-uploaded-files-loader.php';

		/**
		 * The class responsible for defining internationalization functionality
		 * of the plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-dh-rename-uploaded-files-i18n.php';

		/**
		 * The class responsible for defining all actions that occur in the admin area.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-dh-rename-uploaded-files-admin.php';

		/**
		 * The class responsible for defining all actions that occur in the public-facing
		 * side of the site.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/class-dh-rename-uploaded-files-public.php';
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/partials/dh-rename-uploaded-files-public-display.php';

		$this->loader = new DH_Rename_Uploaded_Files_Loader();

	}

	/**
	 * Define the locale for this plugin for internationalization.
	 *
	 * Uses the DH_Rename_Uploaded_Files_i18n class in order to set the domain and to register the hook
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function set_locale() {

		$plugin_i18n = new DH_Rename_Uploaded_Files_i18n();

		$this->loader->add_action( 'plugins_loaded', $plugin_i18n, 'load_plugin_textdomain' );

	}

	/**
	 * Register all of the hooks related to the admin area functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_admin_hooks() {

		$plugin_admin = new DH_Rename_Uploaded_Files_Admin( $this->get_DH_Rename_Uploaded_Files(), $this->get_version() );

		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts' );

		// Add menu item
		$this->loader->add_action( 'admin_menu', $plugin_admin, 'add_plugin_admin_menu' );

		// Add Settings link to the plugin
		$plugin_basename = plugin_basename( plugin_dir_path( __DIR__ ) . $this->DH_Rename_Uploaded_Files . '.php' );
		$this->loader->add_filter( 'plugin_action_links_' . $plugin_basename, $plugin_admin, 'add_action_links' );

	}

	/**
	 * Register all of the hooks related to the public-facing functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_public_hooks() {

		$plugin_public = new DH_Rename_Uploaded_Files_Public( $this->get_DH_Rename_Uploaded_Files(), $this->get_version() );

		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_styles' );
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_scripts' );

	}

	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since    1.0.0
	 */
	public function run() {
		$this->loader->run();
	}

	/**
	 * The name of the plugin used to uniquely identify it within the context of
	 * WordPress and to define internationalization functionality.
	 *
	 * @since     1.0.0
	 * @return    string    The name of the plugin.
	 */
	public function get_DH_Rename_Uploaded_Files() {
		return $this->DH_Rename_Uploaded_Files;
	}

	/**
	 * The reference to the class that orchestrates the hooks with the plugin.
	 *
	 * @since     1.0.0
	 * @return    DH_Rename_Uploaded_Files_Loader    Orchestrates the hooks of the plugin.
	 */
	public function get_loader() {
		return $this->loader;
	}

	/**
	 * Retrieve the version number of the plugin.
	 *
	 * @since     1.0.0
	 * @return    string    The version number of the plugin.
	 */
	public function get_version() {
		return $this->version;
	}

	private function dh__ruf($filename) {

		global $options;
		$options = get_option('dh_renameuploadedfiles');

		if ($options['dhruf_renametype'] == 'norename') {

			$info		= pathinfo($filename);
			$ext		= (isset($info['extension']) && !empty($info['extension'])) ? '.'. $info['extension'] : '';
			$name		= basename($filename, $ext);

			return $name . $ext;	// hello-world.jpg

		} else
		if ($options['dhruf_renametype'] == 'filename') {

			$namefile	= pathinfo($filename, PATHINFO_FILENAME);
			$random		= substr(str_shuffle($namefile), 0);

			$append 	= apply_filters('dh__ruf', true, $filename, $random);

		if (!$append) return $filename;

			$info		= pathinfo($filename);
			$ext		= (isset($info['extension']) && !empty($info['extension'])) ? '.'. $info['extension'] : '';
			$name		= basename($random, $ext);

			return $name . $ext;	// orlold-whel.jpg
	
		} else
		if ($options['dhruf_renametype'] == 'filenamerename') {

			$namefile	= pathinfo($filename, PATHINFO_FILENAME);
			$random 	= substr(str_shuffle($namefile), 0);

			$append		= apply_filters('dh__ruf', true, $filename, $random);

			if (!$append) return $filename;

			$info		= pathinfo($filename);
			$ext		= (isset($info['extension']) && !empty($info['extension'])) ? '.'. $info['extension'] : '';
			$name		= basename($filename, $ext) .'_'. $random;

			return $name . $ext;	// hello-world_orlold-whel.jpg

		} else
		if ($options['dhruf_renametype'] == 'allrename') {

			$namefile	= pathinfo($filename, PATHINFO_FILENAME);
			$namefiles	= str_replace(array('[',']','(',')','{','}','-','_','.',',','/','|','+','^','&','%','#','$'),'',$namefile);

			$alphabet	= 'abcdefghijklmnopqrstuvwxyz';
			$numeric	= '1234567890';
			$random		= substr(str_shuffle($namefiles.$alphabet.$numeric), 0, 30);

			$append		= apply_filters('dh__ruf', true, $filename, $random);

			if (!$append) return $filename;

			$info		= pathinfo($filename);
			$ext		= (isset($info['extension']) && !empty($info['extension'])) ? '.'. $info['extension'] : '';
			$name		= basename($random, $ext);

			return $name . $ext;	// qk76eopxz04132ryclvn.jpg

		} else {

			$info		= pathinfo($filename);
			$ext		= (isset($info['extension']) && !empty($info['extension'])) ? '.'. $info['extension'] : '';
			$name		= basename($filename, $ext);

			return $name . $ext;	// hello-world.jpg

		}

	}

}