<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       https://wordpress.org/plugins/dh-rename-uploaded-files/
 * @since      1.0.0
 *
 * @package    dh-rename-uploaded-files
 * @subpackage dh-rename-uploaded-files/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    dh-rename-uploaded-files
 * @subpackage dh-rename-uploaded-files/includes
 * @author     Your Name <email@example.com>
 */
class DH_Rename_Uploaded_Files_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'dh-rename-uploaded-files',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
