<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://wordpress.org/plugins/dh-rename-uploaded-files/
 * @since             1.0.0
 * @package           dh-rename-uploaded-files
 *
 * @wordpress-plugin
 * Plugin Name:       DH - Rename Uploaded Files
 * Plugin URI:        https://wordpress.org/plugins/dh-rename-uploaded-files/
 * Description:       Enables you to rename WordPress media uploads on the fly. This only work for new uploaded files only.
 * Version:           4
 * Requires at least: 6.0
 * Tested up to:      6.6.1
 * Requires PHP:      7.4
 * Author:            Dannie Herdyawan
 * Author URI:        https://www.askomba.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       dh-rename-uploaded-files
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define('DH_Rename_Uploaded_Files_VERSION', '4');

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-dh-rename-uploaded-files-activator.php
 */
function activate_DH_Rename_Uploaded_Files()
{
	require_once plugin_dir_path(__FILE__) . 'includes/class-dh-rename-uploaded-files-activator.php';
	DH_Rename_Uploaded_Files_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-dh-rename-uploaded-files-deactivator.php
 */
function deactivate_DH_Rename_Uploaded_Files()
{
	require_once plugin_dir_path(__FILE__) . 'includes/class-dh-rename-uploaded-files-deactivator.php';
	DH_Rename_Uploaded_Files_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'activate_DH_Rename_Uploaded_Files');
register_deactivation_hook(__FILE__, 'deactivate_DH_Rename_Uploaded_Files');

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path(__FILE__) . 'includes/class-dh-rename-uploaded-files.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_DH_Rename_Uploaded_Files()
{

	$plugin = new DH_Rename_Uploaded_Files();
	$plugin->run();

}
run_DH_Rename_Uploaded_Files();