<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://wordpress.org/plugins/dh-rename-uploaded-files/
 * @since      1.0.0
 *
 * @package    dh-rename-uploaded-files
 * @subpackage dh-rename-uploaded-files/admin/partials
 */

?>
<!-- This file should primarily consist of HTML with a little bit of PHP. -->
<section class="section">
	<div class="container">
		<?php
		if (isset($_POST['DH_RenameUploadedFiles']) && wp_verify_nonce($_POST['DH_RenameUploadedFiles'], 'submit')) {

			if (isset($_POST['dhruf_enable'])) {
				$options['dhruf_enable'] = sanitize_text_field($_POST['dhruf_enable']);
			} else {
				$options['dhruf_enable'] = null;
			}

			$options['dhruf_renametype'] = sanitize_text_field($_POST['dhruf_renametype']);

			update_option('dh_renameuploadedfiles', $options);
			// Show a message to say we've done something
			echo "<div class='block notification is-success'>
					<button class='delete'></button>
					" . esc_html__('Settings saved.', 'dh-rename-uploaded-files') . "
				</div>";
		} else {
			$options = get_option('dh_renameuploadedfiles');
		}
		?>

		<form method="post" name="dh_rename_uploaded_files_form" action="">
			<?php wp_nonce_field('submit', 'DH_RenameUploadedFiles'); ?>
			<table class="table is-hoverable is-fullwidth is-bordered is-striped">
				<thead>
					<tr>
						<th colspan="2">
							<abbr title="DH - Rename Uploaded Files">DH - Rename Uploaded Files</abbr>
							<span style="font-size:x-small!important;font-weight:lighter!important;">
								&nbsp;&nbsp;&nbsp;Automatically renames WordPress media uploads with customizable naming patterns for better organization and security.
							</span>
						</th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td style="width:15%!important;"><?php esc_html_e('Enable', 'dh-rename-uploaded-files'); ?></td>
						<td style="width:85%!important;">
							<label class="checkbox">
								<input name="dhruf_enable" class="dhruf_enable" type="checkbox" <?php if (isset($options['dhruf_enable'])) { ?>checked<?php } ?>>
								<small><?php esc_html_e('Tick to enable', 'dh-rename-uploaded-files'); ?></small>
							</label>
						</td>
					</tr>
					<tr class="dhruf_options <?php if (empty($options['dhruf_enable'])) { ?>sembunyikan<?php } ?>">
						<td><?php esc_html_e('Rename Type', 'dh-rename-uploaded-files'); ?></td>
						<td>
							<div class="control">
								<label class="radio">
									<input type="radio" name="dhruf_renametype" value="norename" <?php if ($options['dhruf_renametype'] == 'norename' || $options['dhruf_renametype'] == '') { ?>checked<?php } ?>>
									<small><?php echo esc_html_x('hello-world.jpg', 'Example filename', 'dh-rename-uploaded-files'); ?></small>
								</label>
								<label class="radio">
									<input type="radio" name="dhruf_renametype" value="filename" <?php if ($options['dhruf_renametype'] == 'filename') { ?>checked<?php } ?>>
									<small><?php echo esc_html_x('rlold-whel.jpg', 'Example hashed filename', 'dh-rename-uploaded-files'); ?></small>
								</label>
								<label class="radio">
									<input type="radio" name="dhruf_renametype" value="filenamerename" <?php if ($options['dhruf_renametype'] == 'filenamerename') { ?>checked<?php } ?>>
									<small><?php echo esc_html_x('hello-world_orlold-whel.jpg', 'Example combined filename', 'dh-rename-uploaded-files'); ?></small>
								</label>
								<label class="radio">
									<input type="radio" name="dhruf_renametype" value="allrename" <?php if ($options['dhruf_renametype'] == 'allrename') { ?>checked<?php } ?>>
									<small><?php echo esc_html_x('d6sf8z7mlo5ey4h90nkqcbixgr3wvj.jpg', 'Example hashed filename', 'dh-rename-uploaded-files'); ?></small>
								</label>
							</div>
						</td>
					</tr>
				</tbody>
			</table>

			<div class="buttons">
				<input type="hidden" name="action" value="update" />
				<input type="hidden" name="page_options" value="<?php echo esc_attr(get_option('dh_renameuploadedfiles')); ?>" />
				<input type="submit" name="save" id="submit" class="button is-active is-danger is-outlined"
					value="<?php esc_attr_e('Save Changes', 'dh-rename-uploaded-files'); ?>" />
				<a class="button is-danger-light is-inverted" href="https://www.paypal.com/paypalme/DannieHerdyawan"
					target="_blank">
					<i class="fab fa-paypal"></i> <?php esc_attr_e('Donate with PayPal', 'dh-rename-uploaded-files'); ?>
				</a>
			</div>

		</form>
	</div>
</section>