<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://wordpress.org/plugins/dh-rename-uploaded-files/
 * @since      1.0.0
 *
 * @package    dh-rename-uploaded-files
 * @subpackage dh-rename-uploaded-files/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    dh-rename-uploaded-files
 * @subpackage dh-rename-uploaded-files/admin
 * @author     Your Name <email@example.com>
 */
class DH_Rename_Uploaded_Files_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $DH_Rename_Uploaded_Files    The ID of this plugin.
	 */
	private $DH_Rename_Uploaded_Files;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $DH_Rename_Uploaded_Files       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $DH_Rename_Uploaded_Files, $version ) {

		$this->DH_Rename_Uploaded_Files = $DH_Rename_Uploaded_Files;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles($hook) {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in DH_Rename_Uploaded_Files_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The DH_Rename_Uploaded_Files_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		global $dhruf_page_hook_suffix;
		if( $hook != $dhruf_page_hook_suffix )
        	return; 

		wp_enqueue_style( $this->DH_Rename_Uploaded_Files, plugin_dir_url( __FILE__ ) . 'css/dh-rename-uploaded-files-admin.css', array(), $this->version, 'all' );
		wp_enqueue_style( 'fontawesome.min', plugin_dir_url( __FILE__ ) . 'css/fontawesome.min.css', array(), $this->version, 'all' );
		wp_enqueue_style( 'fontawesome.brands.min', plugin_dir_url( __FILE__ ) . 'css/fontawesome.brands.min.css', array(), $this->version, 'all' );
		wp_enqueue_style( 'bulma.min', plugin_dir_url( __FILE__ ) . 'css/bulma.min.css', array(), $this->version, 'all' );
		wp_enqueue_style( 'bulma-checkbox.min', plugin_dir_url( __FILE__ ) . 'css/bulma-checkbox.min.css', array(), $this->version, 'all' );
		wp_enqueue_style( 'bulma-radio.min', plugin_dir_url( __FILE__ ) . 'css/bulma-radio.min.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts($hook) {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in DH_Rename_Uploaded_Files_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The DH_Rename_Uploaded_Files_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		global $dhruf_page_hook_suffix;
		if( $hook != $dhruf_page_hook_suffix )
        	return; 

		wp_enqueue_script( $this->DH_Rename_Uploaded_Files, plugin_dir_url( __FILE__ ) . 'js/dh-rename-uploaded-files-admin.js', array( 'jquery' ), $this->version, false );
		wp_enqueue_script( 'fontawesome.min', plugin_dir_url( __FILE__ ) . 'js/fontawesome.min.js', array( 'jquery' ), $this->version, false );
		wp_enqueue_script( 'fontawesome.brands.min', plugin_dir_url( __FILE__ ) . 'js/fontawesome.brands.min.js', array( 'jquery' ), $this->version, false );

	}

		/**
		 * Register the administration menu for this plugin into the WordPress Dashboard menu.
		 *
		 * @since    1.0.0
		 */

	public function add_plugin_admin_menu() {

		/**
		 * Add a settings page for this plugin to the Settings menu.
		 *
		 * NOTE:  Alternative menu locations are available via WordPress administration menu functions.
		 *
		 *        Administration Menus: http://codex.wordpress.org/Administration_Menus
		 *
		 */
    	global $dhruf_page_hook_suffix;
		$dhruf_page_hook_suffix = add_options_page( 'DH – Rename Uploaded Files', 'DH – Rename Uploaded Files', 'manage_options', $this->DH_Rename_Uploaded_Files, array($this, 'display_plugin_setup_page')
						);
	}

		/**
		 * Add settings action link to the plugins page.
		 *
		 * @since    1.0.0
		 */

	public function add_action_links( $links ) {
    	/**
		 *  Documentation : https://codex.wordpress.org/Plugin_API/Filter_Reference/plugin_action_links_(plugin_file_name)
		 */
		$settings_link = array(
			'<a href="' . admin_url( 'options-general.php?page=' . $this->DH_Rename_Uploaded_Files ) . '">' . __('Settings', $this->DH_Rename_Uploaded_Files) . '</a>',
		);
  		return array_merge(  $settings_link, $links );

	}

	/**
	* Render the settings page for this plugin.
	*
	* @since    1.0.0
	*/

	public function display_plugin_setup_page() {
		include_once( 'partials/dh-rename-uploaded-files-admin-display.php' );
	}

}