<?php
/**
 * Tech template - Digital terminal aesthetic
 *
 * This template can be overridden by copying it to:
 * your-theme/devlab-maintenance-mode/tech.php
 *
 * @package DevLabMaintenanceMode
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow">
    <title><?php echo esc_html( get_bloginfo( 'name' ) ); ?> - <?php esc_html_e( 'Maintenance', 'devlab-maintenance-mode' ); ?></title>
    <?php wp_print_styles( 'mmbd-template-tech' ); ?>
    <?php do_action( 'mmbd_maintenance_head' ); ?>
</head>
<body>
    <div class="binary-bg binary-1">01001101 01000001 01001001 01001110</div>
    <div class="binary-bg binary-2">10110010 01001110 01000001 01001110</div>
    <div class="binary-bg binary-3">11001010 01010100 01000101 01001110</div>
    <div class="binary-bg binary-4">01010100 01000101 01000011 01001000</div>

    <div class="maintenance-container">
        <div class="terminal-header">
            <div class="terminal-dot dot-red"></div>
            <div class="terminal-dot dot-yellow"></div>
            <div class="terminal-dot dot-green"></div>
            <span class="terminal-title">system@maintenance ~ </span>
        </div>

        <div class="content-inner">
            <div class="prompt-line">
                <span class="prompt">$</span> <span class="command">./run_maintenance.sh</span>
            </div>

            <div class="maintenance-content">
                <?php echo wp_kses_post( $message ); ?>
            </div>

            <div class="progress-bar">
                <div class="progress-label">> System update in progress...</div>
                <div class="progress-track">
                    <div class="progress-fill"></div>
                </div>
            </div>

            <div class="prompt-line">
                <span class="prompt">$</span> <span class="cursor"></span>
            </div>

            <div class="site-name">
                // <?php echo esc_html( get_bloginfo( 'name' ) ); ?>
            </div>
        </div>
    </div>

    <?php do_action( 'mmbd_maintenance_footer' ); ?>
</body>
</html>
