<?php
/**
 * Playful template - Fun with floating shapes
 *
 * This template can be overridden by copying it to:
 * your-theme/devlab-maintenance-mode/playful.php
 *
 * @package DevLabMaintenanceMode
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow">
    <title><?php echo esc_html( get_bloginfo( 'name' ) ); ?> - <?php esc_html_e( 'Maintenance', 'devlab-maintenance-mode' ); ?></title>
    <?php wp_print_styles( 'mmbd-template-playful' ); ?>
    <?php do_action( 'mmbd_maintenance_head' ); ?>
</head>
<body>
    <div class="floating-shape shape-1"></div>
    <div class="floating-shape shape-2"></div>
    <div class="floating-shape shape-3"></div>
    <div class="floating-shape shape-4"></div>

    <div class="maintenance-container">
        <div class="emoji-icon">&#128736;&#65039;</div>

        <div class="maintenance-content">
            <?php echo wp_kses_post( $message ); ?>
        </div>

        <div class="site-name">
            <?php echo esc_html( get_bloginfo( 'name' ) ); ?>
        </div>
    </div>

    <?php do_action( 'mmbd_maintenance_footer' ); ?>
</body>
</html>
